/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.rail.util;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.rtm.rail.util.Point;
import jp.ngt.rtm.rail.util.RailDir;
import jp.ngt.rtm.rail.util.RailMap;
import jp.ngt.rtm.rail.util.RailMapSwitch;
import jp.ngt.rtm.rail.util.RailPosition;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public abstract class SwitchType {
    public final byte id;
    protected RailMapSwitch[] railMaps;
    protected Point[] points;

    protected SwitchType(int par1) {
        this.id = (byte)par1;
    }

    public abstract boolean init(List<RailPosition> var1, List<RailPosition> var2);

    public abstract String getName();

    public void onBlockChanged(World world) {
    }

    public void onUpdate(World world) {
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i].onUpdate(world);
        }
    }

    public abstract RailMap getRailMap(Entity var1);

    public RailMapSwitch[] getAllRailMap() {
        return this.railMaps;
    }

    public Point[] getPoints() {
        return this.points;
    }

    public Point getNearestPoint(Entity entity) {
        Point point = null;
        double distance = Double.MAX_VALUE;
        double angle = 90.0;
        for (Point p0 : this.getPoints()) {
            double d0 = entity.func_70092_e(p0.rpRoot.posX, 0.0, p0.rpRoot.posZ);
            if (!(d0 <= distance)) continue;
            point = p0;
            distance = d0;
            angle = d0;
        }
        return point;
    }

    public static class SwitchDiamondCross
    extends SwitchType {
        public SwitchDiamondCross() {
            super(3);
        }

        @Override
        public boolean init(List<RailPosition> switchList, List<RailPosition> normalList) {
            ArrayList<RailPosition> rpList = new ArrayList<RailPosition>();
            rpList.addAll(switchList);
            rpList.addAll(normalList);
            RailMapSwitch[] rails = new RailMapSwitch[2];
            int k = 0;
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (i >= j || Math.abs(((RailPosition)rpList.get((int)i)).direction - ((RailPosition)rpList.get((int)j)).direction) != 4) continue;
                    rails[k] = new RailMapSwitch((RailPosition)rpList.get(i), (RailPosition)rpList.get(j), RailDir.NONE, RailDir.NONE);
                    if (++k < 2) continue;
                    this.railMaps = rails;
                    this.points = new Point[4];
                    this.points[0] = new Point(rails[0].startRP, rails[0]);
                    this.points[1] = new Point(rails[0].endRP, rails[0]);
                    this.points[2] = new Point(rails[1].startRP, rails[1]);
                    this.points[3] = new Point(rails[1].endRP, rails[1]);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void onBlockChanged(World world) {
            super.onBlockChanged(world);
        }

        @Override
        public RailMap getRailMap(Entity entity) {
            double d2;
            RailMap map1 = this.points[0].getActiveRailMap(entity.field_70170_p);
            RailMap map2 = this.points[2].getActiveRailMap(entity.field_70170_p);
            int n1 = map1.getNearlestPoint(16, entity.field_70165_t, entity.field_70161_v);
            int n2 = map2.getNearlestPoint(16, entity.field_70165_t, entity.field_70161_v);
            double[] pos1 = map1.getRailPos(16, n1);
            double[] pos2 = map1.getRailPos(16, n2);
            double d1 = entity.func_70092_e(pos1[1], 0.0, pos1[0]);
            return d1 < (d2 = entity.func_70092_e(pos2[1], 0.0, pos2[0])) ? map1 : map2;
        }

        @Override
        public String getName() {
            return "Diamond Crossing";
        }
    }

    public static class SwitchScissorsCross
    extends SwitchType {
        public SwitchScissorsCross() {
            super(2);
        }

        @Override
        public boolean init(List<RailPosition> switchList, List<RailPosition> normalList) {
            int i;
            RailMapSwitch[] rails = new RailMapSwitch[4];
            RailPosition[][] rps = new RailPosition[4][2];
            int rpsCount = 0;
            for (i = 0; i < 4; ++i) {
                for (int j = i + 1; j < 4; ++j) {
                    int dirDif = Math.abs(switchList.get((int)i).direction - switchList.get((int)j).direction);
                    if (dirDif > 4) {
                        dirDif = 8 - dirDif;
                    }
                    if (dirDif <= 2 || rpsCount >= 4) continue;
                    rps[rpsCount] = new RailPosition[]{switchList.get(i), switchList.get(j)};
                    ++rpsCount;
                }
            }
            if (rpsCount == 4) {
                for (i = 0; i < 4; ++i) {
                    RailDir dir0 = RailDir.NONE;
                    RailDir dir1 = RailDir.NONE;
                    for (int j = 0; j < 4; ++j) {
                        if (i == j) continue;
                        if (rps[i][0] == rps[j][0]) {
                            dir0 = rps[i][0].getDir(rps[i][1], rps[j][1]);
                            continue;
                        }
                        if (rps[i][0] == rps[j][1]) {
                            dir0 = rps[i][0].getDir(rps[i][1], rps[j][0]);
                            continue;
                        }
                        if (rps[i][1] == rps[j][0]) {
                            dir1 = rps[i][1].getDir(rps[i][0], rps[j][1]);
                            continue;
                        }
                        if (rps[i][1] != rps[j][1]) continue;
                        dir1 = rps[i][1].getDir(rps[i][0], rps[j][0]);
                    }
                    rails[i] = new RailMapSwitch(rps[i][0], rps[i][1], dir0, dir1);
                }
                this.railMaps = rails;
                this.points = new Point[4];
                for (i = 0; i < 4; ++i) {
                    RailPosition rp = switchList.get(i);
                    RailMapSwitch rms1 = null;
                    RailMapSwitch rms2 = null;
                    for (int j = 0; j < 4; ++j) {
                        if (rails[j].startRP != rp && rails[j].endRP != rp) continue;
                        if (rms1 == null) {
                            rms1 = rails[j];
                            continue;
                        }
                        rms2 = rails[j];
                        break;
                    }
                    this.points[i] = new Point(rp, rms1, rms2);
                }
                return true;
            }
            return false;
        }

        @Override
        public void onBlockChanged(World world) {
            super.onBlockChanged(world);
            RailMapSwitch openRMS = null;
            block0: for (int j = 0; j < 2; ++j) {
                for (int i = 0; i < 4; ++i) {
                    RailMapSwitch rms = this.railMaps[i];
                    if (rms.startDir == rms.endDir) {
                        if (j == 0) {
                            if (!rms.isGettingPowered(world)) continue;
                            openRMS = rms;
                            continue block0;
                        }
                        if (rms == openRMS) {
                            rms.setState(true);
                            continue;
                        }
                        rms.setState(false);
                        continue;
                    }
                    if (j != 1) continue;
                    if (openRMS == null) {
                        rms.setState(true);
                        continue;
                    }
                    rms.setState(false);
                }
            }
        }

        @Override
        public RailMap getRailMap(Entity entity) {
            RailMap map = null;
            double distance = Double.MAX_VALUE;
            for (Point point : this.getPoints()) {
                int n1;
                double[] pos1;
                double d1;
                RailMap map1 = point.getActiveRailMap(entity.field_70170_p);
                if (map1 == map || !((d1 = entity.func_70092_e((pos1 = map1.getRailPos(16, n1 = map1.getNearlestPoint(16, entity.field_70165_t, entity.field_70161_v)))[1], 0.0, pos1[0])) < distance)) continue;
                distance = d1;
                map = map1;
            }
            return map;
        }

        @Override
        public String getName() {
            return "Scissors Crossing";
        }
    }

    public static class SwitchSingleCross
    extends SwitchType {
        public SwitchSingleCross() {
            super(1);
        }

        @Override
        public boolean init(List<RailPosition> switchList, List<RailPosition> normalList) {
            RailMapSwitch[] rails = new RailMapSwitch[3];
            RailPosition rpRoot1 = switchList.get(0);
            RailPosition rpRoot2 = switchList.get(1);
            RailDir b0 = RailDir.NONE;
            RailDir b1 = RailDir.NONE;
            int rmsCount = 0;
            for (RailPosition rpA : switchList) {
                for (RailPosition rpB : normalList) {
                    if (rpA.direction == rpB.direction) continue;
                    boolean flag = rpA == rpRoot1;
                    RailPosition rp2 = flag ? rpRoot2 : rpRoot1;
                    RailDir b2 = rpA.getDir(rp2, rpB);
                    if (flag) {
                        b0 = b2;
                    } else {
                        b1 = b2;
                    }
                    rails[rmsCount] = new RailMapSwitch(rpA, rpB, b2.invert(), RailDir.NONE);
                }
                ++rmsCount;
            }
            rails[2] = new RailMapSwitch(rpRoot1, rpRoot2, b0, b1);
            this.railMaps = rails;
            this.points = new Point[4];
            this.points[0] = new Point(rpRoot1, rails[0], rails[2]);
            this.points[1] = new Point(rpRoot2, rails[1], rails[2]);
            this.points[2] = new Point(rpRoot1 == rails[0].startRP ? rails[0].endRP : rails[0].startRP, rails[0]);
            this.points[3] = new Point(rpRoot2 == rails[1].startRP ? rails[1].endRP : rails[1].startRP, rails[1]);
            return true;
        }

        @Override
        public void onBlockChanged(World world) {
            super.onBlockChanged(world);
            if (this.railMaps[2].isGettingPowered(world)) {
                this.railMaps[0].setState(false);
                this.railMaps[1].setState(false);
                this.railMaps[2].setState(true);
            } else {
                this.railMaps[0].setState(true);
                this.railMaps[1].setState(true);
                this.railMaps[2].setState(false);
            }
        }

        @Override
        public RailMap getRailMap(Entity entity) {
            double d2;
            RailMap map2;
            RailMap map1 = this.points[0].getActiveRailMap(entity.field_70170_p);
            if (map1 == (map2 = this.points[1].getActiveRailMap(entity.field_70170_p))) {
                return map1;
            }
            int n1 = map1.getNearlestPoint(16, entity.field_70165_t, entity.field_70161_v);
            int n2 = map2.getNearlestPoint(16, entity.field_70165_t, entity.field_70161_v);
            double[] pos1 = map1.getRailPos(16, n1);
            double[] pos2 = map1.getRailPos(16, n2);
            double d1 = entity.func_70092_e(pos1[1], 0.0, pos1[0]);
            return d1 < (d2 = entity.func_70092_e(pos2[1], 0.0, pos2[0])) ? map1 : map2;
        }

        @Override
        public String getName() {
            return "Crossover";
        }
    }

    public static class SwitchBasic
    extends SwitchType {
        public SwitchBasic() {
            super(0);
        }

        @Override
        public boolean init(List<RailPosition> switchList, List<RailPosition> normalList) {
            RailMapSwitch[] rails = new RailMapSwitch[2];
            RailPosition rpRoot = switchList.get(0);
            RailPosition rpBranch1 = normalList.get(0);
            RailPosition rpBranch2 = normalList.get(1);
            RailDir dir = rpRoot.getDir(rpBranch1, rpBranch2);
            rails[0] = new RailMapSwitch(rpRoot, rpBranch1, dir, RailDir.NONE);
            rails[1] = new RailMapSwitch(rpRoot, rpBranch2, dir.invert(), RailDir.NONE);
            this.railMaps = rails;
            this.points = new Point[3];
            this.points[0] = new Point(rpRoot, rails[0], rails[1]);
            this.points[1] = new Point(rpBranch1, rails[0]);
            this.points[2] = new Point(rpBranch2, rails[1]);
            return true;
        }

        @Override
        public void onBlockChanged(World world) {
            super.onBlockChanged(world);
            if (this.railMaps[0].getStartRP().checkRSInput(world)) {
                this.railMaps[0].setState(false);
                this.railMaps[1].setState(true);
            } else {
                this.railMaps[0].setState(true);
                this.railMaps[1].setState(false);
            }
        }

        @Override
        public RailMap getRailMap(Entity entity) {
            return this.points[0].getActiveRailMap(entity.field_70170_p);
        }

        @Override
        public String getName() {
            return "Simple";
        }
    }
}

