/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.sound;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ngt.ngtlib.io.NGTJson;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.io.NGTText;
import jp.ngt.rtm.RTMSound;
import jp.ngt.rtm.entity.train.EntityTrainBase;
import jp.ngt.rtm.sound.MovingSoundEntity;
import jp.ngt.rtm.sound.MovingSoundTileEntity;
import jp.ngt.rtm.sound.MovingSoundTrain;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class MovingSoundMaker {
    private static final Map<String, Map<String, String>> NAME_COMPATIBLE_MAP = new HashMap<String, Map<String, String>>();
    private static final ParameterizedType TYPE = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{String.class, SoundListDummy.class};
        }

        @Override
        public Type getRawType() {
            return Map.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    };

    public static MovingSoundEntity create(Entity entity, String sound, boolean repeat) {
        if (!MovingSoundMaker.checkSoundFile(sound)) {
            return null;
        }
        if (entity instanceof EntityTrainBase) {
            return new MovingSoundTrain((EntityTrainBase)entity, sound, repeat);
        }
        return new MovingSoundEntity(entity, sound, repeat);
    }

    public static MovingSoundTileEntity create(TileEntity entity, String sound, boolean repeat) {
        if (!MovingSoundMaker.checkSoundFile(sound)) {
            return null;
        }
        return new MovingSoundTileEntity(entity, sound, repeat);
    }

    private static boolean checkSoundFile(String sound) {
        if (RTMSound.ALL_OGG_FILES.contains(sound = MovingSoundMaker.fixSoundName(sound))) {
            return true;
        }
        if (sound.split(":")[0].equals("minecraft")) {
            return true;
        }
        NGTLog.debug((String)"[MovingSound] Invalid sound : %s", (Object[])new Object[]{sound});
        return false;
    }

    private static String fixSoundName(String sound) {
        Map<String, String> map;
        String path;
        String domain;
        if (sound.contains("ogg")) {
            return sound;
        }
        if (sound.contains(":")) {
            String[] sa = sound.split(":");
            domain = sa[0];
            path = sa[1];
        } else {
            domain = "minecraft";
            path = sound;
        }
        if (!NAME_COMPATIBLE_MAP.containsKey(domain)) {
            MovingSoundMaker.loadSoundJson(domain);
        }
        if ((map = NAME_COMPATIBLE_MAP.get(domain)).containsKey(sound)) {
            return map.get(sound);
        }
        path = path.replace('.', '/');
        return domain + ":sounds/" + path + ".ogg";
    }

    private static void loadSoundJson(String domain) {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        try {
            String json = NGTText.getText((ResourceLocation)new ResourceLocation(domain, "sounds.json"), (boolean)true);
            Map map = (Map)NGTJson.getGson().fromJson(json, (Type)TYPE);
            for (Map.Entry entry : map.entrySet()) {
                if (((SoundListDummy)entry.getValue()).sounds.isEmpty()) continue;
                Object obj = ((SoundListDummy)entry.getValue()).sounds.get(0);
                String path = obj instanceof Map ? (String)((Map)obj).get("name") : (String)obj;
                path = path.contains(":") ? path.replace(":", ":sounds/") + ".ogg" : domain + ":sounds/" + path + ".ogg";
                String name = domain + ":" + (String)entry.getKey();
                nameMap.put(name, path);
                NGTLog.debug((String)"[MSM] Add Sound map (%s)->(%s)", (Object[])new Object[]{name, path});
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        NAME_COMPATIBLE_MAP.put(domain, nameMap);
    }

    private class SoundListDummy {
        public String category;
        public List sounds;

        private SoundListDummy() {
        }
    }
}

