/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.sound;

import java.io.File;
import java.io.IOException;
import jp.ngt.ngtlib.io.NGTFileLoader;
import jp.ngt.ngtlib.io.NGTJson;
import jp.ngt.ngtlib.io.NGTText;
import jp.ngt.ngtlib.util.NGTUtil;
import jp.ngt.rtm.RTMCore;
import jp.ngt.rtm.network.PacketNotice;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SpeakerSounds {
    private static final SpeakerSounds INSTANCE_CLIENT = new SpeakerSounds(false);
    private static final SpeakerSounds INSTANCE_SERVER = new SpeakerSounds(true);
    private static final String SAVE_FILE = "rtm/speaker_sounds.json";
    public static final int MAX_SOUND_ID = 64;
    private String[] sounds = new String[64];
    private boolean sideServer;

    private SpeakerSounds(boolean par1) {
        this.sideServer = par1;
        if (NGTUtil.isServer()) {
            this.loadSoundList();
        }
    }

    public static SpeakerSounds getInstance(boolean server) {
        return server ? INSTANCE_SERVER : INSTANCE_CLIENT;
    }

    private void loadSoundList() {
        File file = new File((File)NGTFileLoader.getModsDir().get(0), SAVE_FILE);
        if (file.exists()) {
            try {
                this.sounds = (String[])NGTJson.getObjectFromJson((String)NGTText.readText((File)file, (boolean)false, (String)""), String[].class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void syncSoundList() {
        for (int i = 0; i < this.sounds.length; ++i) {
            this.setSound(i + 1, this.sounds[i], true);
        }
    }

    private void saveSoundList() {
        File file = new File((File)NGTFileLoader.getModsDir().get(0), SAVE_FILE);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        NGTJson.writeToJson((String)NGTJson.getJsonFromObject((Object)this.sounds), (File)file);
    }

    public String getSound(int id) {
        return this.sounds[id - 1];
    }

    public void setSound(int id, String sound, boolean sync) {
        this.sounds[id - 1] = sound;
        String msg = String.format("speaker,%d,%s", id, sound);
        if (this.sideServer) {
            this.saveSoundList();
            RTMCore.NETWORK_WRAPPER.sendToAll((IMessage)new PacketNotice(1, msg));
        } else if (sync) {
            RTMCore.NETWORK_WRAPPER.sendToServer((IMessage)new PacketNotice(0, msg));
        }
    }

    public void onGetPacket(String msg, boolean sync) {
        String[] sa = msg.split(",");
        int id = Integer.valueOf(sa[1]);
        this.setSound(id, sa[2], sync);
    }
}

