/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.rtm.util;

import java.nio.FloatBuffer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class RenderUtil {
    private static FloatBuffer COLOR_BUFFER = GLAllocation.func_74529_h((int)16);
    private static float[] COLOR_BUF = new float[]{0.0f, 0.0f, 0.0f};

    public static void enableCustomLighting(int id, float x, float y, float z, float r, float g, float b) {
        int light = RenderUtil.getLight(id);
        if (light < 0) {
            return;
        }
        GL11.glDisable((int)16384);
        GL11.glDisable((int)16385);
        if (r < 0.0f) {
            float hue = (float)((int)((double)(System.currentTimeMillis() / 50L % 24000L) * 15.0) % 360) / 360.0f;
            float[] buf = RenderUtil.convertHueToRGB(hue);
            r = buf[0];
            g = buf[1];
            b = buf[2];
        }
        GL11.glEnable((int)light);
        GL11.glLight((int)light, (int)4611, (FloatBuffer)RenderUtil.setColorBuffer(x, y, z, 1.0f));
        float spe = 1.0f;
        GL11.glLight((int)light, (int)4610, (FloatBuffer)RenderUtil.setColorBuffer(r, g, b, 1.0f));
        float dif = 0.7f;
        GL11.glLight((int)light, (int)4609, (FloatBuffer)RenderUtil.setColorBuffer(dif, dif, dif, 1.0f));
        float amb = 0.2f;
        GL11.glLight((int)light, (int)4608, (FloatBuffer)RenderUtil.setColorBuffer(amb, amb, amb, 1.0f));
        GL11.glMaterial((int)1028, (int)4608, (FloatBuffer)RenderUtil.setColorBuffer(0.24725f, 0.1995f, 0.0745f, 1.0f));
        GL11.glMaterial((int)1028, (int)4609, (FloatBuffer)RenderUtil.setColorBuffer(0.75164f, 0.60648f, 0.22648f, 1.0f));
        GL11.glMaterial((int)1028, (int)4610, (FloatBuffer)RenderUtil.setColorBuffer(0.628281f, 0.555802f, 0.366065f, 1.0f));
        GL11.glMaterialf((int)1028, (int)5633, (float)51.2f);
        GL11.glMaterial((int)1028, (int)5632, (FloatBuffer)RenderUtil.setColorBuffer(0.0f, 0.0f, 0.0f, 0.0f));
    }

    public static void disableCustomLighting(int id) {
        int light = RenderUtil.getLight(id);
        if (light < 0) {
            return;
        }
        GL11.glDisable((int)light);
        GL11.glEnable((int)16384);
        GL11.glEnable((int)16385);
    }

    private static int getLight(int id) {
        switch (id) {
            case 0: {
                return 16388;
            }
            case 1: {
                return 16389;
            }
            case 2: {
                return 16390;
            }
            case 3: {
                return 16391;
            }
        }
        return -1;
    }

    private static FloatBuffer setColorBuffer(float x, float y, float z, float w) {
        COLOR_BUFFER.clear();
        COLOR_BUFFER.put(x).put(y).put(z).put(w);
        COLOR_BUFFER.flip();
        return COLOR_BUFFER;
    }

    public static float[] convertHueToRGB(float hue) {
        int huei = (int)(hue * 360.0f);
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        switch (huei / 60) {
            case 0: {
                r = 1.0f;
                g = (float)huei / 60.0f;
                b = 0.0f;
                break;
            }
            case 1: {
                r = (float)(120 - huei) / 60.0f;
                g = 1.0f;
                b = 0.0f;
                break;
            }
            case 2: {
                r = 0.0f;
                g = 1.0f;
                b = (float)(120 - huei) / 60.0f;
                break;
            }
            case 3: {
                r = 0.0f;
                g = (float)(240 - huei) / 60.0f;
                b = 1.0f;
                break;
            }
            case 4: {
                r = (float)(huei - 240) / 60.0f;
                g = 0.0f;
                b = 1.0f;
                break;
            }
            case 5: {
                r = 1.0f;
                g = 0.0f;
                b = (float)(360 - huei) / 60.0f;
            }
        }
        RenderUtil.COLOR_BUF[0] = r;
        RenderUtil.COLOR_BUF[1] = g;
        RenderUtil.COLOR_BUF[2] = b;
        return COLOR_BUF;
    }
}

