/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.client.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rzk.wirelessredstone.WirelessRedstone;
import rzk.wirelessredstone.client.gui.GuiSizedButton;
import rzk.wirelessredstone.network.PacketFrequency;
import rzk.wirelessredstone.network.PacketHandler;

@SideOnly(value=Side.CLIENT)
public class GuiFrequency
extends GuiScreen
implements GuiPageButtonList.GuiResponder {
    public static final ResourceLocation TEXTURE = new ResourceLocation("wirelessredstone", "textures/gui/frequency.png");
    protected int xSize;
    protected int ySize;
    private int guiLeft;
    private int guiTop;
    private GuiSizedButton sub1Button;
    private GuiSizedButton sub10Button;
    private GuiSizedButton add1Button;
    private GuiSizedButton add10Button;
    private GuiSizedButton extendButton;
    private GuiSizedButton closeButton;
    private GuiSizedButton doneButton;
    private GuiTextField frequencyField;
    private short frequency;
    private boolean extended;
    private final BlockPos pos;
    private final EnumHand hand;

    public GuiFrequency(PacketFrequency packet) {
        this.frequency = packet.getFrequency();
        this.extended = false;
        this.pos = packet.getPos();
        this.hand = packet.getHand();
    }

    public void func_73866_w_() {
        this.xSize = 192;
        this.ySize = this.extended ? 200 : 112;
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.field_146292_n.clear();
        this.sub1Button = (GuiSizedButton)this.func_189646_b(new GuiSizedButton(0, this.guiLeft + 26, this.guiTop + 26, 34, 16, "-1"));
        this.sub10Button = (GuiSizedButton)this.func_189646_b(new GuiSizedButton(1, this.guiLeft + 26, this.guiTop + 46, 34, 16, "-10"));
        this.add1Button = (GuiSizedButton)this.func_189646_b(new GuiSizedButton(2, this.guiLeft + this.xSize - 34 - 26, this.guiTop + 26, 34, 16, "+1"));
        this.add10Button = (GuiSizedButton)this.func_189646_b(new GuiSizedButton(3, this.guiLeft + this.xSize - 34 - 26, this.guiTop + 46, 34, 16, "+10"));
        this.extendButton = (GuiSizedButton)this.func_189646_b(new GuiSizedButton(4, this.guiLeft + 26, this.guiTop + 76, 44, 18, I18n.func_135052_a((String)(this.extended ? "gui.wirelessredstone.reduce.name" : "gui.wirelessredstone.extend.name"), (Object[])new Object[0])));
        this.extendButton.field_146125_m = false;
        this.doneButton = (GuiSizedButton)this.func_189646_b(new GuiSizedButton(6, this.guiLeft + this.xSize / 2 - 20, this.guiTop + 76, 40, 18, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.closeButton = (GuiSizedButton)this.func_189646_b(new GuiSizedButton(7, this.guiLeft + this.xSize - 16, this.guiTop + 4, 13, 13, "x", 0, -1));
        this.frequencyField = new GuiTextField(8, this.field_146289_q, this.guiLeft + this.xSize / 2 - 19, this.guiTop + 36, 38, 16);
        this.frequencyField.func_175205_a(str -> str.matches("^[0-9]*"));
        this.frequencyField.func_146203_f(5);
        this.frequencyField.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.setFrequency(Short.toUnsignedInt(this.frequency));
    }

    private void setFrequency(int frequency) {
        this.frequency = (short)Math.min(frequency, 65535);
        this.frequencyField.func_146180_a(String.valueOf(Short.toUnsignedInt(this.frequency)));
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                this.setFrequency(this.frequency - (GuiFrequency.func_146272_n() ? 100 : 1));
                break;
            }
            case 1: {
                this.setFrequency(this.frequency - (GuiFrequency.func_146272_n() ? 1000 : 10));
                break;
            }
            case 2: {
                this.setFrequency(this.frequency + (GuiFrequency.func_146272_n() ? 100 : 1));
                break;
            }
            case 3: {
                this.setFrequency(this.frequency + (GuiFrequency.func_146272_n() ? 1000 : 10));
                break;
            }
            case 4: {
                this.extended = !this.extended;
                this.extendButton.field_146126_j = I18n.func_135052_a((String)(this.extended ? "gui.wirelessredstone.reduce.name" : "gui.wirelessredstone.extend.name"), (Object[])new Object[0]);
                this.func_73866_w_();
                break;
            }
            case 6: {
                if (this.pos != null) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFrequency(this.frequency, this.extended, this.pos));
                } else if (this.hand != null) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFrequency(this.frequency, this.extended, this.hand));
                } else {
                    WirelessRedstone.logger.error("BlockPos and Hand are null, something went wrong");
                }
                this.close();
                break;
            }
            case 7: {
                this.close();
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.close();
        }
        this.frequencyField.func_146201_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.frequencyField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.drawBackgroundLayer();
        if (GuiFrequency.func_146272_n()) {
            this.sub1Button.field_146126_j = "-100";
            this.sub10Button.field_146126_j = "-1000";
            this.add1Button.field_146126_j = "+100";
            this.add10Button.field_146126_j = "+1000";
        } else {
            this.sub1Button.field_146126_j = "-1";
            this.sub10Button.field_146126_j = "-10";
            this.add1Button.field_146126_j = "+1";
            this.add10Button.field_146126_j = "+10";
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawForegroundLayer();
    }

    protected void drawBackgroundLayer() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    protected void drawForegroundLayer() {
        this.frequencyField.func_146194_f();
        String title = I18n.func_135052_a((String)"gui.wirelessredstone.frequency.name", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(title, this.guiLeft + this.xSize / 2 - this.field_146289_q.func_78256_a(title) / 2, this.guiTop + 6, 0x404040);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
    }

    public void func_175319_a(int id, String value) {
        if (value.trim().isEmpty()) {
            this.frequency = 0;
            this.doneButton.field_146124_l = false;
        } else {
            this.doneButton.field_146124_l = true;
            int freq = Integer.parseInt(value);
            if (freq <= 65535) {
                this.frequency = (short)freq;
            } else {
                this.doneButton.field_146124_l = false;
            }
        }
    }

    private void close() {
        this.field_146297_k.func_147108_a(null);
    }
}

