/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rzk.wirelessredstone.item.ItemFrequency;
import rzk.wirelessredstone.rsnetwork.Device;
import rzk.wirelessredstone.rsnetwork.RedstoneNetwork;

public class ItemRemote
extends ItemFrequency {
    public static boolean isPowered(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemRemote && stack.func_77960_j() != 0;
    }

    public static void setPowered(World world, ItemStack stack, boolean powered) {
        if (stack != null && stack.func_77973_b() instanceof ItemRemote) {
            RedstoneNetwork network;
            stack.func_77964_b(powered ? 1 : 0);
            if (!world.field_72995_K && (network = RedstoneNetwork.get(world)) != null) {
                Device device = Device.createRemote(ItemRemote.getFrequency(stack));
                if (powered) {
                    network.addDevice(device);
                } else {
                    network.removeDevice(device);
                }
            }
        }
    }

    @Override
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            return super.func_77659_a(world, player, hand);
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!ItemRemote.isPowered(stack)) {
            ItemRemote.setPowered(world, stack, true);
        }
        if (!world.field_72995_K) {
            player.func_184598_c(hand);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        if (ItemRemote.isPowered(stack)) {
            ItemRemote.setPowered(world, stack, false);
        }
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_184811_cZ().func_185145_a((Item)this, 10);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        boolean powered = ItemRemote.isPowered(stack);
        Style color = new Style().func_150238_a(powered ? TextFormatting.GREEN : TextFormatting.DARK_RED);
        ITextComponent state = new TextComponentTranslation(powered ? "tooltip.wirelessredstone.on.name" : "tooltip.wirelessredstone.off.name", new Object[0]).func_150255_a(color);
        tooltip.add(new TextComponentTranslation("tooltip.wirelessredstone.state.name", new Object[]{state}).func_150254_d());
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!isSelected && !world.field_72995_K && entity instanceof EntityPlayer && ItemRemote.isPowered(stack)) {
            ItemRemote.setPowered(world, stack, false);
            ((EntityPlayer)entity).func_184811_cZ().func_185145_a((Item)this, 10);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }
}

