/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.item;

import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import rzk.wirelessredstone.item.ItemFrequency;
import rzk.wirelessredstone.rsnetwork.Channel;
import rzk.wirelessredstone.rsnetwork.RedstoneNetwork;
import rzk.wirelessredstone.util.WRConfig;

public class ItemSniffer
extends ItemFrequency {
    public void setHighlightedBlocks(World world, ItemStack stack, int[] coords) {
        if (stack.func_77973_b() instanceof ItemSniffer) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
                stack.func_77982_d(nbt);
            }
            nbt.func_74772_a("timestamp", world.func_82737_E());
            nbt.func_74783_a("highlight", coords);
        }
    }

    public void removeHighlightBlocks(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77973_b() instanceof ItemSniffer && (nbt = stack.func_77978_p()) != null) {
            nbt.func_82580_o("timestamp");
            nbt.func_82580_o("highlight");
        }
    }

    @Override
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        RedstoneNetwork network;
        if (player.func_70093_af()) {
            return super.func_77659_a(world, player, hand);
        }
        ItemStack stack = player.func_184586_b(hand);
        player.func_184811_cZ().func_185145_a((Item)this, 20);
        if (!world.field_72995_K && (network = RedstoneNetwork.get(world, false)) != null) {
            short frequency = ItemSniffer.getFrequency(stack);
            Channel channel = network.getChannel(frequency);
            ITextComponent freqComponent = new TextComponentString(String.valueOf(Short.toUnsignedInt(frequency))).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA));
            if (channel == null || channel.getTransmitters().isEmpty()) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.wirelessredstone.no.transmitters", new Object[]{freqComponent}));
                this.removeHighlightBlocks(stack);
            } else {
                ObjectSet<BlockPos> transmitters = channel.getTransmitters();
                Iterator iterator = transmitters.iterator();
                TextComponentTranslation message = new TextComponentTranslation("message.wirelessredstone.active.transmitters", new Object[]{freqComponent, transmitters.size()});
                message.func_150258_a("\n");
                int current = 0;
                while (iterator.hasNext()) {
                    ++current;
                    BlockPos transmitter = (BlockPos)iterator.next();
                    ClickEvent click = new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/tp %d %d %d", transmitter.func_177958_n(), transmitter.func_177956_o() + 1, transmitter.func_177952_p()));
                    HoverEvent hover = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("message.wirelessredstone.teleport", new Object[0]));
                    Style style = new Style().func_150241_a(click).func_150209_a(hover).func_150238_a(TextFormatting.YELLOW);
                    message.func_150257_a(new TextComponentString(String.format("[x: %d, y: %d, z: %d]", transmitter.func_177958_n(), transmitter.func_177956_o(), transmitter.func_177952_p())).func_150255_a(style));
                    if (iterator.hasNext()) {
                        message.func_150258_a("," + (current % 2 == 0 ? (char)'\n' : ' '));
                    }
                    if (message.func_150260_c().length() < 1000) continue;
                    message.func_150258_a("...");
                    break;
                }
                player.func_145747_a((ITextComponent)message);
                int[] coords = new int[transmitters.size() * 3];
                current = 0;
                for (BlockPos transmitter : transmitters) {
                    if (!world.func_175667_e(transmitter)) continue;
                    coords[current] = transmitter.func_177958_n();
                    coords[++current] = transmitter.func_177956_o();
                    coords[++current] = transmitter.func_177952_p();
                    ++current;
                }
                this.setHighlightedBlocks(world, stack, coords);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (isSelected && !world.field_72995_K && stack.func_77973_b() instanceof ItemSniffer && stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            long timestamp = nbt.func_74763_f("timestamp");
            if (world.func_82737_E() >= timestamp + (long)WRConfig.snifferHighlightTime * 20L) {
                this.removeHighlightBlocks(stack);
            }
        }
    }
}

