/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.registry;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import rzk.wirelessredstone.WirelessRedstone;
import rzk.wirelessredstone.block.BlockReceiver;
import rzk.wirelessredstone.block.BlockTransmitter;

public final class ModBlocks {
    public static final ObjectList<Block> BLOCKS = new ObjectArrayList();
    public static final ObjectList<Item> ITEMS = new ObjectArrayList();
    public static Block redstoneTransmitter;
    public static Block redstoneReceiver;

    private ModBlocks() {
    }

    private static void initBlocks() {
        redstoneTransmitter = ModBlocks.registerBlock("redstone_transmitter", new BlockTransmitter());
        redstoneReceiver = ModBlocks.registerBlock("redstone_receiver", new BlockReceiver());
    }

    private static Block registerBlockWithoutItem(String name, Block block) {
        block.func_149647_a(WirelessRedstone.CREATIVE_TAB).func_149663_c("wirelessredstone." + name).setRegistryName("wirelessredstone", name);
        BLOCKS.add((Object)block);
        return block;
    }

    private static Block registerBlock(String name, Block block, Function<Block, ItemBlock> itemProvider) {
        ModBlocks.registerBlockWithoutItem(name, block);
        ItemBlock item = itemProvider.apply(block);
        item.setRegistryName(block.getRegistryName());
        ITEMS.add((Object)item);
        return block;
    }

    private static Block registerBlock(String name, Block block) {
        return ModBlocks.registerBlock(name, block, ItemBlock::new);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        ModBlocks.initBlocks();
        BLOCKS.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        ITEMS.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
    }
}

