/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.rsnetwork;

import net.minecraft.util.math.BlockPos;
import rzk.wirelessredstone.rsnetwork.DeviceImpl;

public interface Device {
    public short getFrequency();

    public Type getType();

    default public boolean isSender() {
        return this.getType() == Type.REMOTE || this.getType() == Type.TRANSMITTER;
    }

    default public boolean isReceiver() {
        return this.getType() == Type.RECEIVER;
    }

    default public boolean isRemote() {
        return this.getType() == Type.REMOTE;
    }

    default public boolean isBlock() {
        return !this.isRemote();
    }

    public static Device create(short frequency, Type type, BlockPos pos) {
        if (type == Type.REMOTE) {
            return new DeviceImpl(frequency, type);
        }
        return new DeviceImpl.Block(frequency, type, pos);
    }

    public static Device createTransmitter(short frequency, BlockPos pos) {
        return Device.create(frequency, Type.TRANSMITTER, pos);
    }

    public static Device createReceiver(short frequency, BlockPos pos) {
        return Device.create(frequency, Type.RECEIVER, pos);
    }

    public static Device createRemote(short frequency) {
        return Device.create(frequency, Type.REMOTE, null);
    }

    public static enum Type {
        TRANSMITTER,
        RECEIVER,
        REMOTE;

    }

    public static interface Block
    extends Device {
        public BlockPos getFreqPos();
    }
}

