/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.rsnetwork;

import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import rzk.wirelessredstone.block.BlockFrequency;
import rzk.wirelessredstone.registry.ModBlocks;
import rzk.wirelessredstone.rsnetwork.Channel;
import rzk.wirelessredstone.rsnetwork.Device;

public class RedstoneNetwork
extends WorldSavedData {
    public static final String DATA_NAME = "redstoneNetwork";
    private World world;
    private final Short2ObjectMap<Channel> channels = new Short2ObjectOpenHashMap();

    public RedstoneNetwork(String name) {
        super(name);
    }

    public RedstoneNetwork() {
        this(DATA_NAME);
    }

    void setReceiverState(BlockPos pos, boolean state) {
        if (this.world.func_175667_e(pos) && this.world.func_180495_p(pos).func_177230_c() instanceof BlockFrequency) {
            ((BlockFrequency)ModBlocks.redstoneReceiver).setPoweredState(this.world.func_180495_p(pos), this.world, pos, state);
        }
    }

    public void updateReceivers(short frequency) {
        if (this.channels.containsKey(frequency)) {
            Channel channel = (Channel)this.channels.get(frequency);
            boolean isActive = channel.isActive();
            for (BlockPos receiver : channel.getReceivers()) {
                this.setReceiverState(receiver, isActive);
            }
        }
    }

    public void addDevice(Device device) {
        if (device == null) {
            return;
        }
        short frequency = device.getFrequency();
        Channel channel = (Channel)this.channels.get(frequency);
        if (channel == null) {
            channel = Channel.create(frequency);
            this.channels.put(frequency, (Object)channel);
        }
        channel.addDevice(device);
        if (device.isSender()) {
            this.updateReceivers(frequency);
        } else if (device.isReceiver() && device.isBlock() && channel.isActive()) {
            this.setReceiverState(((Device.Block)device).getFreqPos(), true);
        }
        this.func_76185_a();
    }

    public void removeDevice(Device device) {
        if (device == null) {
            return;
        }
        short frequency = device.getFrequency();
        Channel channel = (Channel)this.channels.get(frequency);
        if (channel != null) {
            channel.removeDevice(device);
            if (device.isSender()) {
                this.updateReceivers(frequency);
            }
            this.func_76185_a();
        }
    }

    public void changeDeviceFrequency(Device device, short newFrequency) {
        if (device == null) {
            return;
        }
        Device.Type type = device.getType();
        this.removeDevice(device);
        BlockPos pos = null;
        if (device.isBlock()) {
            pos = ((Device.Block)device).getFreqPos();
        }
        this.addDevice(Device.create(newFrequency, type, pos));
        if (type == Device.Type.RECEIVER) {
            this.setReceiverState(pos, this.isChannelActive(newFrequency));
        }
    }

    public boolean isChannelActive(short frequency) {
        Channel channel = (Channel)this.channels.get(frequency);
        return channel != null && channel.isActive();
    }

    public void clearFrequency(short frequency) {
        Channel channel = (Channel)this.channels.get(frequency);
        if (channel != null) {
            channel.clear();
            this.updateReceivers(frequency);
            this.func_76185_a();
        }
    }

    public void clearAll() {
        for (Channel channel : this.channels.values()) {
            channel.clear();
            this.updateReceivers(channel.getFrequency());
        }
        this.func_76185_a();
    }

    public Channel getChannel(short frequency) {
        return (Channel)this.channels.get(frequency);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        Channel channel;
        NBTTagList channelsNBT;
        if (nbt.func_74764_b("channels")) {
            channelsNBT = nbt.func_150295_c("channels", 10);
            for (NBTBase channelNBT : channelsNBT) {
                channel = Channel.fromNBT((NBTTagCompound)channelNBT);
                if (channel == null || channel.isEmpty()) continue;
                this.channels.put(channel.getFrequency(), (Object)channel);
            }
        }
        if (nbt.func_74764_b("basic")) {
            channelsNBT = nbt.func_150295_c("basic", 10);
            for (NBTBase channelNBT : channelsNBT) {
                channel = Channel.fromNBT((NBTTagCompound)channelNBT);
                if (channel == null || channel.isEmpty()) continue;
                this.channels.put(channel.getFrequency(), (Object)channel);
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        if (!this.channels.isEmpty()) {
            this.channels.short2ObjectEntrySet().removeIf(entry -> ((Channel)entry.getValue()).isEmpty());
            NBTTagList channelNBT = new NBTTagList();
            for (Channel channel : this.channels.values()) {
                channelNBT.func_74742_a((NBTBase)channel.toNBT());
            }
            nbt.func_74782_a("channels", (NBTBase)channelNBT);
        }
        return nbt;
    }

    public World getWorld() {
        return this.world;
    }

    public static RedstoneNetwork get(World world, boolean create) {
        if (world == null) {
            return null;
        }
        RedstoneNetwork instance = null;
        MapStorage mapStorage = world.func_175693_T();
        if (mapStorage != null) {
            instance = (RedstoneNetwork)mapStorage.func_75742_a(RedstoneNetwork.class, DATA_NAME);
            if (create && instance == null) {
                instance = new RedstoneNetwork();
                mapStorage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
            }
            if (instance != null) {
                instance.world = world;
            }
        }
        return instance;
    }

    public static RedstoneNetwork get(World world) {
        return RedstoneNetwork.get(world, true);
    }
}

