/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.blocks;

import com.clussmanproductions.trafficcontrol.ModBlocks;
import com.clussmanproductions.trafficcontrol.ModTrafficControl;
import com.clussmanproductions.trafficcontrol.tileentity.StreetLightSingleTileEntity;
import com.clussmanproductions.trafficcontrol.tileentity.render.StreetLightSingleRenderer;
import com.clussmanproductions.trafficcontrol.util.CustomAngleCalculator;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class BlockStreetLightSingle
extends Block
implements ITileEntityProvider {
    public static final PropertyInteger ROTATION = PropertyInteger.func_177719_a((String)"rotation", (int)0, (int)15);

    public BlockStreetLightSingle() {
        super(Material.field_151576_e);
        this.setRegistryName("street_light_single");
        this.func_149663_c("trafficcontrol.street_light_single");
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149647_a(ModTrafficControl.CREATIVE_TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ClientRegistry.bindTileEntitySpecialRenderer(StreetLightSingleTileEntity.class, (TileEntitySpecialRenderer)new StreetLightSingleRenderer());
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return CustomAngleCalculator.rotationToMeta((Integer)state.func_177229_b((IProperty)ROTATION));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(CustomAngleCalculator.metaToRotation(meta)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATION});
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof StreetLightSingleTileEntity)) {
            return 0;
        }
        StreetLightSingleTileEntity streetLightSingleTileEntity = (StreetLightSingleTileEntity)te;
        return streetLightSingleTileEntity.isPowered() ? 0 : 15;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        int rotation = CustomAngleCalculator.getRotationForYaw(placer.field_70177_z);
        return this.func_176223_P().func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(rotation));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new StreetLightSingleTileEntity();
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof StreetLightSingleTileEntity) {
            StreetLightSingleTileEntity sls = (StreetLightSingleTileEntity)te;
            sls.removeLightSources();
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof StreetLightSingleTileEntity) {
            StreetLightSingleTileEntity streetLightSingleTileEntity = (StreetLightSingleTileEntity)te;
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public float func_185485_f(IBlockState state) {
        return 1.0f;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (worldIn.field_72995_K) {
            super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
            return;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof StreetLightSingleTileEntity) {
            StreetLightSingleTileEntity sls = (StreetLightSingleTileEntity)te;
            sls.setPowered(worldIn.func_175640_z(pos));
            if (sls.isPowered()) {
                sls.removeLightSources();
            } else {
                sls.addLightSources();
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent e) {
        if (e.getWorld().field_72995_K) {
            return;
        }
        BlockPos workingPos = new BlockPos(e.getPos().func_177958_n(), e.getPos().func_177956_o(), e.getPos().func_177952_p());
        workingPos = workingPos.func_177964_d(2).func_177985_f(2);
        IBlockState state = e.getWorld().func_180495_p(workingPos);
        if (state.func_177230_c() == ModBlocks.street_light_single && !CustomAngleCalculator.isEast((Integer)state.func_177229_b((IProperty)ROTATION)) && !CustomAngleCalculator.isSouth((Integer)state.func_177229_b((IProperty)ROTATION))) {
            e.getWorld().func_175656_a(e.getPos(), ModBlocks.light_source.func_176223_P());
            e.setCanceled(true);
        }
        workingPos = workingPos.func_177965_g(4);
        state = e.getWorld().func_180495_p(workingPos);
        if (state.func_177230_c() == ModBlocks.street_light_single && !CustomAngleCalculator.isSouth((Integer)state.func_177229_b((IProperty)ROTATION)) && !CustomAngleCalculator.isWest((Integer)state.func_177229_b((IProperty)ROTATION))) {
            e.getWorld().func_175656_a(e.getPos(), ModBlocks.light_source.func_176223_P());
            e.setCanceled(true);
        }
        workingPos = workingPos.func_177970_e(4);
        state = e.getWorld().func_180495_p(workingPos);
        if (state.func_177230_c() == ModBlocks.street_light_single && !CustomAngleCalculator.isWest((Integer)state.func_177229_b((IProperty)ROTATION)) && !CustomAngleCalculator.isNorth((Integer)state.func_177229_b((IProperty)ROTATION))) {
            e.getWorld().func_175656_a(e.getPos(), ModBlocks.light_source.func_176223_P());
            e.setCanceled(true);
        }
        workingPos = workingPos.func_177985_f(4);
        state = e.getWorld().func_180495_p(workingPos);
        if (state.func_177230_c() == ModBlocks.street_light_single && !CustomAngleCalculator.isNorth((Integer)state.func_177229_b((IProperty)ROTATION)) && !CustomAngleCalculator.isEast((Integer)state.func_177229_b((IProperty)ROTATION))) {
            e.getWorld().func_175656_a(e.getPos(), ModBlocks.light_source.func_176223_P());
            e.setCanceled(true);
        }
    }
}

