/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.blocks.model;

import java.util.ArrayList;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public abstract class BaseBakedModel
implements IBakedModel {
    VertexFormat format;

    public BaseBakedModel(VertexFormat format) {
        this.format = format;
    }

    private void putVertex(UnpackedBakedQuad.Builder builder, Vec3d normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite) {
        block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
            switch (this.format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block6;
                }
                case UV: {
                    if (this.format.func_177348_c(e).func_177369_e() == 0) {
                        u = sprite.func_94214_a((double)u);
                        v = sprite.func_94207_b((double)v);
                        builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                case COLOR: {
                    builder.put(e, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    builder.put(e, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    protected BakedQuad createQuad(Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4, TextureAtlasSprite sprite, UVMapping uvMapping) {
        Vec3d normal = v3.func_178788_d(v2).func_72431_c(v1.func_178788_d(v2)).func_72432_b();
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
        builder.setTexture(sprite);
        this.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, uvMapping.v1u, uvMapping.v1v, sprite);
        this.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, uvMapping.v2u, uvMapping.v2v, sprite);
        this.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, uvMapping.v3u, uvMapping.v3v, sprite);
        this.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, uvMapping.v4u, uvMapping.v4v, sprite);
        return builder.build();
    }

    protected ArrayList<BakedQuad> createBox(double lowerX, double lowerY, double lowerZ, double width, double height, double depth, BoxTextureCollection collection) {
        ArrayList<BakedQuad> retVal = new ArrayList<BakedQuad>();
        retVal.add(this.createQuad(BaseBakedModel.v(lowerX + width, lowerY + height, lowerZ), BaseBakedModel.v(lowerX + width, lowerY, lowerZ), BaseBakedModel.v(lowerX, lowerY, lowerZ), BaseBakedModel.v(lowerX, lowerY + height, lowerZ), collection.south, collection.southMapping));
        retVal.add(this.createQuad(BaseBakedModel.v(lowerX + width, lowerY + height, lowerZ + depth), BaseBakedModel.v(lowerX + width, lowerY, lowerZ + depth), BaseBakedModel.v(lowerX + width, lowerY, lowerZ), BaseBakedModel.v(lowerX + width, lowerY + height, lowerZ), collection.west, collection.westMapping));
        retVal.add(this.createQuad(BaseBakedModel.v(lowerX, lowerY + height, lowerZ + depth), BaseBakedModel.v(lowerX, lowerY, lowerZ + depth), BaseBakedModel.v(lowerX + width, lowerY, lowerZ + depth), BaseBakedModel.v(lowerX + width, lowerY + height, lowerZ + depth), collection.north, collection.northMapping));
        retVal.add(this.createQuad(BaseBakedModel.v(lowerX, lowerY + height, lowerZ), BaseBakedModel.v(lowerX, lowerY, lowerZ), BaseBakedModel.v(lowerX, lowerY, lowerZ + depth), BaseBakedModel.v(lowerX, lowerY + height, lowerZ + depth), collection.east, collection.eastMapping));
        retVal.add(this.createQuad(BaseBakedModel.v(lowerX + width, lowerY + height, lowerZ + depth), BaseBakedModel.v(lowerX + width, lowerY + height, lowerZ), BaseBakedModel.v(lowerX, lowerY + height, lowerZ), BaseBakedModel.v(lowerX, lowerY + height, lowerZ + depth), collection.up, collection.upMapping));
        retVal.add(this.createQuad(BaseBakedModel.v(lowerX + width, lowerY, lowerZ), BaseBakedModel.v(lowerX + width, lowerY, lowerZ + depth), BaseBakedModel.v(lowerX, lowerY, lowerZ + depth), BaseBakedModel.v(lowerX, lowerY, lowerZ), collection.down, collection.downMapping));
        return retVal;
    }

    protected ArrayList<BakedQuad> createBoxWithXRotation(double lowerX, double lowerY, double lowerZ, double width, double height, int depth, int rotation, BoxTextureCollection collection) {
        ArrayList<BakedQuad> retVal = new ArrayList<BakedQuad>();
        double rads = Math.toRadians(rotation);
        double oppositeRads = Math.toRadians(rotation + 90);
        double x1 = lowerX;
        double y1 = lowerY;
        double x2 = width * Math.cos(rads) + x1;
        double y2 = width * Math.sin(rads) + y1;
        double x3 = height * Math.cos(oppositeRads) + x2;
        double y3 = height * Math.sin(oppositeRads) + y2;
        double x4 = height * Math.cos(oppositeRads) + x1;
        double y4 = height * Math.sin(oppositeRads) + y1;
        retVal.add(this.createQuad(BaseBakedModel.v(x3, y3, lowerZ), BaseBakedModel.v(x2, y2, lowerZ), BaseBakedModel.v(x1, y1, lowerZ), BaseBakedModel.v(x4, y4, lowerZ), collection.south, collection.southMapping));
        retVal.add(this.createQuad(BaseBakedModel.v(x3, y3, lowerZ + (double)depth), BaseBakedModel.v(x2, y2, lowerZ + (double)depth), BaseBakedModel.v(x2, y2, lowerZ), BaseBakedModel.v(x3, y3, lowerZ), collection.west, collection.westMapping));
        retVal.add(this.createQuad(BaseBakedModel.v(x4, y4, lowerZ + (double)depth), BaseBakedModel.v(x1, y1, lowerZ + (double)depth), BaseBakedModel.v(x2, y2, lowerZ + (double)depth), BaseBakedModel.v(x3, y3, lowerZ + (double)depth), collection.north, collection.northMapping));
        retVal.add(this.createQuad(BaseBakedModel.v(x4, y4, lowerZ), BaseBakedModel.v(x1, y1, lowerZ), BaseBakedModel.v(x1, y1, lowerZ + (double)depth), BaseBakedModel.v(x4, y4, lowerZ + (double)depth), collection.east, collection.eastMapping));
        retVal.add(this.createQuad(BaseBakedModel.v(x3, y3, lowerZ + (double)depth), BaseBakedModel.v(x3, y3, lowerZ), BaseBakedModel.v(x4, y4, lowerZ), BaseBakedModel.v(x4, y4, lowerZ + (double)depth), collection.up, collection.upMapping));
        retVal.add(this.createQuad(BaseBakedModel.v(x2, y2, lowerZ), BaseBakedModel.v(x2, y2, lowerZ + (double)depth), BaseBakedModel.v(x1, y1, lowerZ + (double)depth), BaseBakedModel.v(x1, y1, lowerZ), collection.down, collection.downMapping));
        return retVal;
    }

    protected ArrayList<BakedQuad> createBoxWithZRotation(double lowerX, double lowerY, double lowerZ, double width, double height, int depth, int rotation, BoxTextureCollection collection) {
        ArrayList<BakedQuad> retVal = new ArrayList<BakedQuad>();
        double rads = Math.toRadians(rotation);
        double oppositeRads = Math.toRadians(rotation + 90);
        double z1 = lowerZ;
        double y1 = lowerY;
        double z2 = (double)depth * Math.cos(rads) + z1;
        double y2 = (double)depth * Math.sin(rads) + y1;
        double z3 = height * Math.cos(oppositeRads) + z2;
        double y3 = height * Math.sin(oppositeRads) + y2;
        double z4 = height * Math.cos(oppositeRads) + z1;
        double y4 = height * Math.sin(oppositeRads) + y1;
        retVal.add(this.createQuad(BaseBakedModel.v(lowerX + width, y3, z3), BaseBakedModel.v(lowerX + width, y2, z2), BaseBakedModel.v(lowerX + width, y1, z1), BaseBakedModel.v(lowerX + width, y4, z4), collection.south, collection.southMapping));
        retVal.add(this.createQuad(BaseBakedModel.v(lowerX, y3, z3), BaseBakedModel.v(lowerX, y2, z2), BaseBakedModel.v(lowerX + width, y2, z2), BaseBakedModel.v(lowerX + width, y3, z3), collection.west, collection.westMapping));
        retVal.add(this.createQuad(BaseBakedModel.v(lowerX, y4, z4), BaseBakedModel.v(lowerX, y1, z1), BaseBakedModel.v(lowerX, y2, z2), BaseBakedModel.v(lowerX, y3, z3), collection.north, collection.northMapping));
        retVal.add(this.createQuad(BaseBakedModel.v(lowerX + width, y4, z4), BaseBakedModel.v(lowerX + width, y1, z1), BaseBakedModel.v(lowerX, y1, z1), BaseBakedModel.v(lowerX, y4, z4), collection.east, collection.eastMapping));
        retVal.add(this.createQuad(BaseBakedModel.v(lowerX, y3, z3), BaseBakedModel.v(lowerX + width, y3, z3), BaseBakedModel.v(lowerX + width, y4, z4), BaseBakedModel.v(lowerX, y4, z4), collection.up, collection.upMapping));
        retVal.add(this.createQuad(BaseBakedModel.v(lowerX + width, y2, z2), BaseBakedModel.v(lowerX, y2, z2), BaseBakedModel.v(lowerX, y1, z1), BaseBakedModel.v(lowerX + width, y1, z1), collection.down, collection.downMapping));
        return retVal;
    }

    protected static Vec3d v(double x, double y, double z) {
        return new Vec3d(x / 16.0, y / 16.0, z / 16.0);
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public class BoxTextureCollection {
        TextureAtlasSprite north;
        TextureAtlasSprite east;
        TextureAtlasSprite south;
        TextureAtlasSprite west;
        TextureAtlasSprite up;
        TextureAtlasSprite down;
        UVMapping northMapping;
        UVMapping eastMapping;
        UVMapping southMapping;
        UVMapping westMapping;
        UVMapping upMapping;
        UVMapping downMapping;

        public BoxTextureCollection(TextureAtlasSprite north, TextureAtlasSprite east, TextureAtlasSprite south, TextureAtlasSprite west, TextureAtlasSprite up, TextureAtlasSprite down, UVMapping northMapping, UVMapping eastMapping, UVMapping southMapping, UVMapping westMapping, UVMapping upMapping, UVMapping downMapping) {
            this.north = north;
            this.east = east;
            this.south = south;
            this.west = west;
            this.up = up;
            this.down = down;
            this.northMapping = northMapping;
            this.eastMapping = eastMapping;
            this.southMapping = southMapping;
            this.westMapping = westMapping;
            this.upMapping = upMapping;
            this.downMapping = downMapping;
        }
    }

    public class UVMapping {
        public int v1u;
        public int v1v;
        public int v2u;
        public int v2v;
        public int v3u;
        public int v3v;
        public int v4u;
        public int v4v;

        public UVMapping(int v1u, int v1v, int v2u, int v2v, int v3u, int v3v, int v4u, int v4v) {
            this.v1u = v1u;
            this.v1v = v1v;
            this.v2u = v2u;
            this.v2v = v2v;
            this.v3u = v3u;
            this.v3v = v3v;
            this.v4u = v4u;
            this.v4v = v4v;
        }
    }
}

