/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.network;

import com.clussmanproductions.trafficcontrol.tileentity.SyncableTileEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSyncableTileEntity
implements IMessage {
    public BlockPos tileEntityPos;
    public NBTTagCompound data;

    public void fromBytes(ByteBuf buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.tileEntityPos = new BlockPos(x, y, z);
        this.data = tag;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.tileEntityPos.func_177958_n());
        buf.writeInt(this.tileEntityPos.func_177956_o());
        buf.writeInt(this.tileEntityPos.func_177952_p());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
    }

    public static class Handler
    implements IMessageHandler<PacketSyncableTileEntity, IMessage> {
        public IMessage onMessage(PacketSyncableTileEntity message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketSyncableTileEntity message, MessageContext ctx) {
            TileEntity te = ctx.getServerHandler().field_147369_b.field_70170_p.func_175625_s(message.tileEntityPos);
            if (te instanceof SyncableTileEntity) {
                SyncableTileEntity syncable = (SyncableTileEntity)te;
                syncable.handleClientToServerUpdateTag(message.data);
            }
        }
    }
}

