/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.proxy;

import com.clussmanproductions.trafficcontrol.ModTrafficControl;
import com.clussmanproductions.trafficcontrol.proxy.CommonProxy;
import com.clussmanproductions.trafficcontrol.tileentity.SignTileEntity;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;

public class ServerProxy
extends CommonProxy {
    @Override
    public void init(FMLInitializationEvent e) {
        String signsJson;
        super.init(e);
        try {
            signsJson = Resources.toString((URL)ModTrafficControl.class.getClassLoader().getResource("assets/trafficcontrol/misc/signs.json"), (Charset)Charsets.UTF_8);
        }
        catch (IOException ex) {
            FMLCommonHandler.instance().raiseException((Throwable)ex, "Failed to load signs", true);
            return;
        }
        JsonArray jsonArray = new JsonParser().parse(signsJson).getAsJsonArray();
        Iterator arrayIterator = jsonArray.iterator();
        HashMap<Integer, Integer> maxVariantsByType = new HashMap<Integer, Integer>();
        while (arrayIterator.hasNext()) {
            int typeID;
            int maxVariant;
            JsonElement signElement = (JsonElement)arrayIterator.next();
            if (!signElement.isJsonObject()) continue;
            JsonObject signObject = signElement.getAsJsonObject();
            String type = signObject.get("type").getAsString();
            int variant = signObject.get("variant").getAsInt();
            if (variant <= (maxVariant = maxVariantsByType.getOrDefault(typeID = SignTileEntity.getSignTypeByName(type), 0).intValue())) continue;
            maxVariantsByType.put(typeID, variant);
        }
        SignTileEntity.MAX_VARIANTS_BY_TYPE = ImmutableMap.copyOf(maxVariantsByType);
    }
}

