/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.tileentity;

import com.clussmanproductions.trafficcontrol.ModBlocks;
import com.clussmanproductions.trafficcontrol.blocks.BlockLightSource;
import com.clussmanproductions.trafficcontrol.blocks.BlockStreetLightDouble;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StreetLightDoubleTileEntity
extends TileEntity {
    private boolean powered;
    private int[] blockPos1 = new int[]{0, -1, 0};
    private int[] blockPos2 = new int[]{0, -1, 0};
    private int[] blockPos3 = new int[]{0, -1, 0};
    private int[] blockPos4 = new int[]{0, -1, 0};

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.blockPos1 = compound.func_74759_k("blockPos1");
        this.blockPos2 = compound.func_74759_k("blockPos2");
        this.blockPos3 = compound.func_74759_k("blockPos3");
        this.blockPos4 = compound.func_74759_k("blockPos4");
        this.powered = compound.func_74767_n("powered");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74783_a("blockPos1", this.blockPos1);
        compound.func_74783_a("blockPos2", this.blockPos2);
        compound.func_74783_a("blockPos3", this.blockPos3);
        compound.func_74783_a("blockPos4", this.blockPos4);
        compound.func_74757_a("powered", this.powered);
        return super.func_189515_b(compound);
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K || this.func_145837_r()) {
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == ModBlocks.street_light_double && !this.powered) {
            this.addLightSources();
        }
    }

    private void setBlockPosArray(BlockPos pos) {
        if (this.blockPos1[1] == -1) {
            this.blockPos1 = new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
        } else if (this.blockPos2[1] == -1) {
            this.blockPos2 = new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
        } else if (this.blockPos3[1] == -1) {
            this.blockPos3 = new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
        } else {
            this.blockPos4 = new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
        }
    }

    private void tryPlaceLightSource(BlockPos pos) {
        IBlockState proposedBlockState = this.field_145850_b.func_180495_p(pos);
        if (proposedBlockState.func_177230_c() != Blocks.field_150350_a && (proposedBlockState = this.field_145850_b.func_180495_p(pos = pos.func_177984_a())).func_177230_c() != Blocks.field_150350_a) {
            proposedBlockState = null;
        }
        if (proposedBlockState != null) {
            this.field_145850_b.func_175656_a(pos, ModBlocks.light_source.func_176223_P());
            this.setBlockPosArray(pos);
        }
    }

    public void removeLightSources() {
        IBlockState state4;
        BlockPos pos4;
        IBlockState state3;
        BlockPos pos3;
        IBlockState state2;
        BlockPos pos2;
        IBlockState state1;
        BlockPos pos1 = this.getBlockPos(1);
        if (pos1 != null && (state1 = this.field_145850_b.func_180495_p(pos1)).func_177230_c() instanceof BlockLightSource) {
            this.field_145850_b.func_175656_a(pos1, Blocks.field_150350_a.func_176223_P());
        }
        if ((pos2 = this.getBlockPos(2)) != null && (state2 = this.field_145850_b.func_180495_p(pos2)).func_177230_c() instanceof BlockLightSource) {
            this.field_145850_b.func_175656_a(pos2, Blocks.field_150350_a.func_176223_P());
        }
        if ((pos3 = this.getBlockPos(3)) != null && (state3 = this.field_145850_b.func_180495_p(pos3)).func_177230_c() instanceof BlockLightSource) {
            this.field_145850_b.func_175656_a(pos3, Blocks.field_150350_a.func_176223_P());
        }
        if ((pos4 = this.getBlockPos(4)) != null && (state4 = this.field_145850_b.func_180495_p(pos4)).func_177230_c() instanceof BlockLightSource) {
            this.field_145850_b.func_175656_a(pos4, Blocks.field_150350_a.func_176223_P());
        }
    }

    private BlockPos getBlockPos(int index) {
        switch (index) {
            case 1: {
                if (this.blockPos1[1] != -1) {
                    return new BlockPos(this.blockPos1[0], this.blockPos1[1], this.blockPos1[2]);
                }
            }
            case 2: {
                if (this.blockPos2[1] != -1) {
                    return new BlockPos(this.blockPos2[0], this.blockPos2[1], this.blockPos2[2]);
                }
            }
            case 3: {
                if (this.blockPos3[1] != -1) {
                    return new BlockPos(this.blockPos3[0], this.blockPos3[1], this.blockPos3[2]);
                }
            }
            case 4: {
                if (this.blockPos4[1] == -1) break;
                return new BlockPos(this.blockPos4[0], this.blockPos4[1], this.blockPos4[2]);
            }
        }
        return null;
    }

    public void addLightSources() {
        BlockPos pos = this.func_174877_v();
        pos = pos.func_177964_d(2).func_177985_f(2);
        this.tryPlaceLightSource(pos);
        pos = pos.func_177965_g(4);
        this.tryPlaceLightSource(pos);
        pos = pos.func_177970_e(4);
        this.tryPlaceLightSource(pos);
        pos = pos.func_177985_f(4);
        this.tryPlaceLightSource(pos);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        if (newSate.func_177230_c() instanceof BlockStreetLightDouble) {
            return false;
        }
        return super.shouldRefresh(world, pos, oldState, newSate);
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean powered) {
        this.powered = powered;
        this.func_70296_d();
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74757_a("powered", this.powered);
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.powered = tag.func_74767_n("powered");
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c).func_72321_a(2.0, 5.0, 2.0).func_72321_a(-2.0, 0.0, -2.0);
    }

    public double func_145833_n() {
        return 262144.0;
    }
}

