/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.tileentity.render;

import com.clussmanproductions.trafficcontrol.blocks.BlockBaseTrafficLight;
import com.clussmanproductions.trafficcontrol.tileentity.BaseTrafficLightTileEntity;
import com.clussmanproductions.trafficcontrol.util.EnumTrafficLightBulbTypes;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public abstract class BaseTrafficLightRenderer
extends TileEntitySpecialRenderer<BaseTrafficLightTileEntity> {
    private static ResourceLocation blackRL = new ResourceLocation("trafficcontrol:textures/blocks/black.png");

    public void render(BaseTrafficLightTileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (!(state.func_177230_c() instanceof BlockBaseTrafficLight)) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        double scale = 0.0625;
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)8.0f);
        GlStateManager.func_179114_b((float)((float)((Integer)state.func_177229_b((IProperty)BlockBaseTrafficLight.ROTATION)).intValue() * -22.5f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-8.0f, (float)-8.0f, (float)-8.0f);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)this.getBulbZLocation());
        List<BulbRenderer> bulbRenderers = this.getBulbRenderers();
        if (te.getIsPigAbove()) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("minecraft:textures/entity/pig/pig.png"));
        } else {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(blackRL);
        }
        for (BulbRenderer renderer : bulbRenderers) {
            renderer.renderBlack(te, blackRL);
        }
        ResourceLocation lastRL = blackRL;
        for (BulbRenderer renderer : bulbRenderers) {
            lastRL = renderer.render(te, lastRL);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    protected abstract double getBulbZLocation();

    protected abstract List<BulbRenderer> getBulbRenderers();

    private static ResourceLocation getResourceLocation(EnumTrafficLightBulbTypes bulbType) {
        switch (bulbType) {
            case Green: {
                return new ResourceLocation("trafficcontrol:textures/blocks/green.png");
            }
            case GreenArrowLeft: {
                return new ResourceLocation("trafficcontrol:textures/blocks/green_arrow_left.png");
            }
            case Red: {
                return new ResourceLocation("trafficcontrol:textures/blocks/red.png");
            }
            case RedArrowLeft: {
                return new ResourceLocation("trafficcontrol:textures/blocks/red_arrow_left.png");
            }
            case Yellow: {
                return new ResourceLocation("trafficcontrol:textures/blocks/yellow_solid.png");
            }
            case YellowArrowLeft: {
                return new ResourceLocation("trafficcontrol:textures/blocks/yellow_arrow_left.png");
            }
            case Cross: {
                return new ResourceLocation("trafficcontrol:textures/blocks/cross.png");
            }
            case DontCross: {
                return new ResourceLocation("trafficcontrol:textures/blocks/dontcross.png");
            }
            case GreenArrowRight: {
                return new ResourceLocation("trafficcontrol:textures/blocks/green_arrow_right.png");
            }
            case RedArrowRight: {
                return new ResourceLocation("trafficcontrol:textures/blocks/red_arrow_right.png");
            }
            case YellowArrowRight: {
                return new ResourceLocation("trafficcontrol:textures/blocks/yellow_arrow_right.png");
            }
        }
        return new ResourceLocation("trafficcontrol:textures/blocks/black.png");
    }

    public static class BulbRenderer {
        private double x;
        private double y;
        private int bulbSlot;

        public BulbRenderer(double x, double y, int bulbSlot) {
            this.x = x;
            this.y = y;
            this.bulbSlot = bulbSlot;
        }

        public ResourceLocation renderBlack(BaseTrafficLightTileEntity entity, ResourceLocation lastRL) {
            if (entity.getActiveBySlot(this.bulbSlot) && entity.getFlashBySlot(this.bulbSlot) && entity.getFlashCurrentBySlot(this.bulbSlot) || entity.getActiveBySlot(this.bulbSlot) && !entity.getFlashBySlot(this.bulbSlot)) {
                return lastRL;
            }
            if (!lastRL.equals((Object)blackRL)) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(blackRL);
            }
            return this.render(entity, blackRL, true);
        }

        public ResourceLocation render(BaseTrafficLightTileEntity entity, ResourceLocation lastRL) {
            return this.render(entity, lastRL, false);
        }

        private ResourceLocation render(BaseTrafficLightTileEntity entity, ResourceLocation lastRL, boolean doRenderBlack) {
            ResourceLocation thisRL;
            if (!doRenderBlack && (!entity.getActiveBySlot(this.bulbSlot) || entity.getFlashBySlot(this.bulbSlot) && !entity.getFlashCurrentBySlot(this.bulbSlot))) {
                return lastRL;
            }
            GlStateManager.func_179137_b((double)this.x, (double)this.y, (double)0.0);
            if (doRenderBlack && !lastRL.equals((Object)blackRL)) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(blackRL);
                lastRL = blackRL;
            } else if (!doRenderBlack && !(thisRL = BaseTrafficLightRenderer.getResourceLocation(entity.getBulbTypeBySlot(this.bulbSlot))).equals((Object)lastRL)) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(thisRL);
                lastRL = thisRL;
            }
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder builder = tess.func_178180_c();
            builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            builder.func_181662_b(5.6, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            builder.func_181662_b(5.6, 5.5, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            builder.func_181662_b(0.0, 5.5, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            builder.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            tess.func_78381_a();
            GlStateManager.func_179137_b((double)(-this.x), (double)(-this.y), (double)0.0);
            return lastRL;
        }
    }
}

