/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.tileentity.render;

import com.clussmanproductions.trafficcontrol.blocks.BlockType3Barrier;
import com.clussmanproductions.trafficcontrol.blocks.BlockType3BarrierBase;
import com.clussmanproductions.trafficcontrol.tileentity.SignTileEntity;
import com.clussmanproductions.trafficcontrol.tileentity.Type3BarrierTileEntity;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class RendererType3Barrier
extends TileEntitySpecialRenderer<Type3BarrierTileEntity> {
    public void render(Type3BarrierTileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IBlockState currentState = this.func_178459_a().func_180495_p(te.func_174877_v()).func_185899_b((IBlockAccess)this.func_178459_a(), te.func_174877_v());
        if (te.getRenderSign() && ((Boolean)currentState.func_177229_b((IProperty)BlockType3BarrierBase.ISFURTHESTLEFT)).booleanValue()) {
            this.renderAllSign(te, x, y, z);
        }
        if (te.getRenderThisSign()) {
            this.renderSecondarySign(te, x, y, z);
        }
    }

    private void renderAllSign(Type3BarrierTileEntity te, double x, double y, double z) {
        BlockPos farthestLeft = te.func_174877_v().func_185334_h();
        BlockPos farthestRight = te.func_174877_v().func_185334_h();
        IBlockState workingBlockState = this.func_178459_a().func_180495_p(te.func_174877_v()).func_185899_b((IBlockAccess)this.func_178459_a(), te.func_174877_v());
        EnumFacing facing = (EnumFacing)workingBlockState.func_177229_b((IProperty)BlockType3BarrierBase.FACING);
        while (workingBlockState.func_177230_c() instanceof BlockType3BarrierBase && !((Boolean)workingBlockState.func_177229_b((IProperty)BlockType3BarrierBase.ISFURTHESTRIGHT)).booleanValue()) {
            farthestRight = farthestRight.func_177972_a(facing.func_176746_e());
            workingBlockState = this.func_178459_a().func_180495_p(farthestRight).func_185899_b((IBlockAccess)this.func_178459_a(), farthestRight);
        }
        float renderX = 0.0f;
        float renderZ = 0.0f;
        switch (facing) {
            case NORTH: 
            case SOUTH: {
                renderX = Math.abs(farthestRight.func_177958_n() - farthestLeft.func_177958_n());
                renderZ = 1.126f;
                break;
            }
            case WEST: 
            case EAST: {
                renderX = Math.abs(farthestRight.func_177952_p() - farthestLeft.func_177952_p());
                renderZ = 1.126f;
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GlStateManager.func_179114_b((float)((4 - (facing.func_176736_b() + 2)) * 90), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        GlStateManager.func_179137_b((double)(renderX / 2.0f), (double)0.75, (double)(renderZ / 2.0f));
        this.func_147499_a(new ResourceLocation("trafficcontrol", "textures/blocks/road_closed_sign.png"));
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder builder = tess.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float textureBottomY = 0.25f;
        float heightFactor = 0.25f;
        if (te.getSignType() == Type3BarrierTileEntity.SignType.LaneClosed) {
            textureBottomY = 0.5f;
        } else if (te.getSignType() == Type3BarrierTileEntity.SignType.RoadClosedThruTraffic) {
            textureBottomY = 1.0f;
            heightFactor = 0.5f;
        }
        builder.func_181662_b(1.0, 0.0, 0.0).func_187315_a(0.5, (double)textureBottomY).func_181675_d();
        builder.func_181662_b(1.0, 0.6875, 0.0).func_187315_a(0.5, (double)(textureBottomY - heightFactor)).func_181675_d();
        builder.func_181662_b(0.0, 0.6875, 0.0).func_187315_a(0.0, (double)(textureBottomY - heightFactor)).func_181675_d();
        builder.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, (double)textureBottomY).func_181675_d();
        tess.func_78381_a();
        this.func_147499_a(new ResourceLocation("trafficcontrol", "textures/blocks/generic.png"));
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_181662_b(1.0, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        builder.func_181662_b(0.0, 0.0, 0.0).func_187315_a(1.0, 0.6875).func_181675_d();
        builder.func_181662_b(0.0, 0.6875, 0.0).func_187315_a(0.0, 0.6875).func_181675_d();
        builder.func_181662_b(1.0, 0.6875, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179121_F();
    }

    private void renderSecondarySign(Type3BarrierTileEntity te, double x, double y, double z) {
        EnumFacing facing = (EnumFacing)this.func_178459_a().func_180495_p(te.func_174877_v()).func_177229_b((IProperty)BlockType3Barrier.FACING);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GlStateManager.func_179114_b((float)((4 - (facing.func_176736_b() + 2)) * 90), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.375, (double)0.0, (double)0.063);
        String typeName = SignTileEntity.getSignTypeName(te.getThisSignType());
        String backName = SignTileEntity.getBackSignName(te.getThisSignType(), te.getThisSignVariant()) + ".png";
        String frontName = typeName + te.getThisSignVariant() + ".png";
        this.func_147499_a(new ResourceLocation("trafficcontrol", "textures/blocks/sign/" + typeName + "/" + frontName));
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder builder = tess.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_181662_b(0.75, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        builder.func_181662_b(0.75, 0.75, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        builder.func_181662_b(0.0, 0.75, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        builder.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        tess.func_78381_a();
        this.func_147499_a(new ResourceLocation("trafficcontrol", "textures/blocks/sign/" + typeName + "/" + backName));
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_181662_b(0.75, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        builder.func_181662_b(0.0, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        builder.func_181662_b(0.0, 0.75, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        builder.func_181662_b(0.75, 0.75, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179121_F();
    }
}

