/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import de.maxhenkel.voicechat.gui.CreateGroupScreen;
import de.maxhenkel.voicechat.gui.EnterPasswordScreen;
import de.maxhenkel.voicechat.gui.group.JoinGroupEntry;
import de.maxhenkel.voicechat.gui.group.JoinGroupList;
import de.maxhenkel.voicechat.gui.widgets.ButtonBase;
import de.maxhenkel.voicechat.gui.widgets.IngameListScreenBase;
import de.maxhenkel.voicechat.net.JoinGroupPacket;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import java.io.IOException;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class JoinGroupScreen
extends IngameListScreenBase {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_join_group.png");
    protected static final ITextComponent TITLE = new TextComponentTranslation("gui.voicechat.join_create_group.title", new Object[0]);
    protected static final ITextComponent CREATE_GROUP = new TextComponentTranslation("message.voicechat.create_group_button", new Object[0]);
    protected static final ITextComponent JOIN_CREATE_GROUP = new TextComponentTranslation("message.voicechat.join_create_group", new Object[0]);
    protected static final ITextComponent NO_GROUPS = new TextComponentTranslation("message.voicechat.no_groups", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
    protected static final int HEADER_SIZE = 16;
    protected static final int FOOTER_SIZE = 32;
    protected static final int UNIT_SIZE = 18;
    protected static final int CELL_HEIGHT = 36;
    protected JoinGroupList groupList;
    protected ButtonBase createGroup;
    protected int units;

    public JoinGroupScreen() {
        super(TITLE, 236, 0);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft += 2;
        this.guiTop = 32;
        int minUnits = MathHelper.func_76123_f((float)2.2222223f);
        this.units = Math.max(minUnits, (this.field_146295_m - 16 - 32 - this.guiTop * 2) / 18);
        this.ySize = 16 + this.units * 18 + 32;
        this.groupList = new JoinGroupList(this, this.field_146294_l, this.units * 18, this.guiTop + 16, 36);
        this.setList(this.groupList);
        this.createGroup = new ButtonBase(0, this.guiLeft + 7, this.guiTop + this.ySize - 20 - 7, this.xSize - 14, 20, CREATE_GROUP){

            @Override
            public void onPress() {
                JoinGroupScreen.this.field_146297_k.func_147108_a((GuiScreen)new CreateGroupScreen());
            }
        };
        this.func_189646_b(this.createGroup);
    }

    @Override
    public void renderBackground(int mouseX, int mouseY, float delta) {
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, 16);
        for (int i = 0; i < this.units; ++i) {
            this.func_73729_b(this.guiLeft, this.guiTop + 16 + 18 * i, 0, 16, this.xSize, 18);
        }
        this.func_73729_b(this.guiLeft, this.guiTop + 16 + 18 * this.units, 0, 34, this.xSize, 32);
        this.func_73729_b(this.guiLeft + 10, this.guiTop + 16 + 6 - 2, this.xSize, 0, 12, 12);
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, float delta) {
        this.field_146289_q.func_78276_b(JOIN_CREATE_GROUP.func_150254_d(), this.guiLeft + this.xSize / 2 - this.field_146289_q.func_78256_a(JOIN_CREATE_GROUP.func_150261_e()) / 2, this.guiTop + 5, 0x404040);
        if (this.groupList != null && !this.groupList.isEmpty()) {
            this.groupList.func_148128_a(mouseX, mouseY, delta);
        } else {
            this.func_73732_a(this.field_146289_q, NO_GROUPS.func_150261_e(), this.field_146294_l / 2, this.guiTop + 16 + this.units * 18 / 2 - this.field_146289_q.field_78288_b / 2, -1);
        }
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        if (this.groupList == null) {
            return;
        }
        for (JoinGroupEntry entry : this.groupList.children()) {
            if (!entry.isSelected()) continue;
            ClientGroup group = entry.getGroup().getGroup();
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            if (group.hasPassword()) {
                this.field_146297_k.func_147108_a((GuiScreen)new EnterPasswordScreen(group));
            } else {
                NetManager.sendToServer(new JoinGroupPacket(group.getId(), null));
            }
            return;
        }
    }
}

