/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.onboarding;

import de.maxhenkel.voicechat.gui.widgets.ButtonBase;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public abstract class OnboardingScreenBase
extends ListScreenBase {
    public static final ITextComponent NEXT = new TextComponentTranslation("message.voicechat.onboarding.next", new Object[0]);
    public static final ITextComponent BACK = new TextComponentTranslation("message.voicechat.onboarding.back", new Object[0]);
    public static final ITextComponent CANCEL = new TextComponentTranslation("message.voicechat.onboarding.cancel", new Object[0]);
    protected static final int TEXT_COLOR = -1;
    protected static final int PADDING = 8;
    protected static final int SMALL_PADDING = 2;
    protected static final int BUTTON_HEIGHT = 20;
    protected int contentWidth;
    protected int guiLeft;
    protected int guiTop;
    protected int contentHeight;
    @Nullable
    protected GuiScreen previous;

    public OnboardingScreenBase(ITextComponent title, @Nullable GuiScreen previous) {
        super(title);
        this.previous = previous;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.contentWidth = this.field_146294_l / 2;
        this.guiLeft = (this.field_146294_l - this.contentWidth) / 2;
        this.guiTop = 20;
        this.contentHeight = this.field_146295_m - this.guiTop * 2;
    }

    @Nullable
    public GuiScreen getNextScreen() {
        return null;
    }

    protected void addPositiveButton(int id, ITextComponent text, final Consumer<ButtonBase> onPress) {
        ButtonBase nextButton = new ButtonBase(id, this.guiLeft + this.contentWidth / 2 + 4, this.guiTop + this.contentHeight - 20, this.contentWidth / 2 - 4, 20, text){

            @Override
            public void onPress() {
                onPress.accept(this);
            }
        };
        this.func_189646_b(nextButton);
    }

    protected void addNextButton(int id) {
        this.addPositiveButton(id, NEXT, button -> this.field_146297_k.func_147108_a(this.getNextScreen()));
    }

    protected void addBackOrCancelButton(int id, boolean big) {
        ITextComponent text = CANCEL;
        if (this.previous instanceof OnboardingScreenBase) {
            text = BACK;
        }
        ButtonBase cancel = new ButtonBase(id, this.guiLeft, this.guiTop + this.contentHeight - 20, big ? this.contentWidth : this.contentWidth / 2 - 4, 20, text){

            @Override
            public void onPress() {
                OnboardingScreenBase.this.field_146297_k.func_147108_a(OnboardingScreenBase.this.previous);
            }
        };
        this.func_189646_b(cancel);
    }

    protected void addBackOrCancelButton(int id) {
        this.addBackOrCancelButton(id, false);
    }

    protected void renderTitle(ITextComponent titleComponent) {
        int titleWidth = this.field_146289_q.func_78256_a(titleComponent.func_150261_e());
        this.field_146289_q.func_175063_a(titleComponent.func_150254_d(), (float)(this.field_146294_l / 2 - titleWidth / 2), (float)this.guiTop, -1);
    }

    protected void renderMultilineText(ITextComponent textComponent) {
        List text = this.field_146289_q.func_78271_c(textComponent.func_150254_d(), this.contentWidth).stream().flatMap(string -> Arrays.stream(string.split("\\\\n"))).collect(Collectors.toList());
        for (int i = 0; i < text.size(); ++i) {
            String line = (String)text.get(i);
            this.field_146289_q.func_175063_a(line, (float)(this.field_146294_l / 2 - this.field_146289_q.func_78256_a(line) / 2), (float)(this.guiTop + this.field_146289_q.field_78288_b + 20 + i * (this.field_146289_q.field_78288_b + 1)), -1);
        }
    }
}

