/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.mixin;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import java.lang.reflect.Constructor;
import java.util.List;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.ResourcePackRepository;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ResourcePackRepository.class})
public class ResourcePackRepositoryMixin {
    @Shadow
    private List<ResourcePackRepository.Entry> field_110619_e;

    @Inject(method={"updateRepositoryEntriesAll"}, at={@At(value="HEAD")})
    public void updateRepositoryEntriesAllHead(CallbackInfo info) {
        this.addResourcePack(VoicechatClient.CLASSIC_ICONS);
        this.addResourcePack(VoicechatClient.WHITE_ICONS);
        this.addResourcePack(VoicechatClient.BLACK_ICONS);
    }

    @Inject(method={"updateRepositoryEntriesAll"}, at={@At(value="RETURN")})
    public void updateRepositoryEntriesAllReturn(CallbackInfo info) {
        this.addResourcePack(VoicechatClient.CLASSIC_ICONS);
        this.addResourcePack(VoicechatClient.WHITE_ICONS);
        this.addResourcePack(VoicechatClient.BLACK_ICONS);
    }

    private void addResourcePack(IResourcePack resourcePack) {
        ResourcePackRepository.Entry entry = this.createEntry(resourcePack);
        if (entry == null) {
            return;
        }
        try {
            entry.func_110516_a();
            this.field_110619_e.add(entry);
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Failed to update resource pack", e);
        }
    }

    private ResourcePackRepository.Entry createEntry(IResourcePack resourcePack) {
        try {
            Constructor constructor = ResourcePackRepository.Entry.class.getDeclaredConstructor(ResourcePackRepository.class, IResourcePack.class);
            constructor.setAccessible(true);
            return (ResourcePackRepository.Entry)constructor.newInstance((ResourcePackRepository)this, resourcePack);
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Failed to create resource pack entry", e);
            return null;
        }
    }
}

