/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.plugins.impl.packets;

import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.packets.EntitySoundPacket;
import de.maxhenkel.voicechat.api.packets.LocationalSoundPacket;
import de.maxhenkel.voicechat.api.packets.SoundPacket;
import de.maxhenkel.voicechat.api.packets.StaticSoundPacket;
import de.maxhenkel.voicechat.plugins.impl.PositionImpl;
import de.maxhenkel.voicechat.plugins.impl.packets.EntitySoundPacketImpl;
import de.maxhenkel.voicechat.plugins.impl.packets.LocationalSoundPacketImpl;
import de.maxhenkel.voicechat.plugins.impl.packets.StaticSoundPacketImpl;
import de.maxhenkel.voicechat.voice.common.GroupSoundPacket;
import de.maxhenkel.voicechat.voice.common.LocationSoundPacket;
import de.maxhenkel.voicechat.voice.common.PlayerSoundPacket;
import de.maxhenkel.voicechat.voice.common.SoundPacket;
import de.maxhenkel.voicechat.voice.common.Utils;
import java.util.UUID;
import javax.annotation.Nullable;

public class SoundPacketImpl
implements de.maxhenkel.voicechat.api.packets.SoundPacket {
    private final SoundPacket<?> packet;

    public SoundPacketImpl(SoundPacket<?> packet) {
        this.packet = packet;
    }

    @Override
    public UUID getChannelId() {
        return this.packet.getChannelId();
    }

    @Override
    public UUID getSender() {
        return this.packet.getSender();
    }

    @Override
    public byte[] getOpusEncodedData() {
        return this.packet.getData();
    }

    @Override
    public long getSequenceNumber() {
        return this.packet.getSequenceNumber();
    }

    @Override
    @Nullable
    public String getCategory() {
        return this.packet.getCategory();
    }

    public SoundPacket<?> getPacket() {
        return this.packet;
    }

    @Override
    public EntitySoundPacket.Builder<?> entitySoundPacketBuilder() {
        return new EntitySoundPacketImpl.BuilderImpl(this);
    }

    @Override
    public LocationalSoundPacket.Builder<?> locationalSoundPacketBuilder() {
        return new LocationalSoundPacketImpl.BuilderImpl(this);
    }

    @Override
    public StaticSoundPacket.Builder<?> staticSoundPacketBuilder() {
        return new StaticSoundPacketImpl.BuilderImpl(this);
    }

    @Override
    public EntitySoundPacket toEntitySoundPacket(UUID entityUuid, boolean whispering) {
        return new EntitySoundPacketImpl(new PlayerSoundPacket(this.packet.getChannelId(), this.packet.getSender(), this.packet.getData(), this.packet.getSequenceNumber(), whispering, this.getDistance(), null));
    }

    @Override
    public LocationalSoundPacket toLocationalSoundPacket(Position position) {
        if (position instanceof PositionImpl) {
            PositionImpl p = (PositionImpl)position;
            return new LocationalSoundPacketImpl(new LocationSoundPacket(this.packet.getChannelId(), this.packet.getSender(), p.getPosition(), this.packet.getData(), this.packet.getSequenceNumber(), this.getDistance(), null));
        }
        throw new IllegalArgumentException("position is not an instance of PositionImpl");
    }

    private float getDistance() {
        if (this instanceof EntitySoundPacket) {
            EntitySoundPacket p = (EntitySoundPacket)((Object)this);
            return p.getDistance();
        }
        if (this instanceof LocationalSoundPacket) {
            LocationalSoundPacket p = (LocationalSoundPacket)((Object)this);
            return p.getDistance();
        }
        return Utils.getDefaultDistance();
    }

    @Override
    public StaticSoundPacket toStaticSoundPacket() {
        return new StaticSoundPacketImpl(new GroupSoundPacket(this.packet.getChannelId(), this.packet.getSender(), this.packet.getData(), this.packet.getSequenceNumber(), null));
    }

    public static abstract class BuilderImpl<T extends BuilderImpl<T, P>, P extends de.maxhenkel.voicechat.api.packets.SoundPacket>
    implements SoundPacket.Builder<T, P> {
        protected UUID channelId;
        protected UUID sender;
        protected byte[] opusEncodedData;
        protected long sequenceNumber;
        @Nullable
        protected String category;

        public BuilderImpl(SoundPacketImpl soundPacket) {
            this.channelId = soundPacket.getChannelId();
            this.sender = soundPacket.getSender();
            this.opusEncodedData = soundPacket.getOpusEncodedData();
            this.sequenceNumber = soundPacket.getSequenceNumber();
            this.category = soundPacket.getCategory();
        }

        public BuilderImpl(UUID channelId, UUID sender, byte[] opusEncodedData, long sequenceNumber, @Nullable String category) {
            this.channelId = channelId;
            this.sender = sender;
            this.opusEncodedData = opusEncodedData;
            this.sequenceNumber = sequenceNumber;
            this.category = category;
        }

        @Override
        public T channelId(UUID channelId) {
            if (channelId == null) {
                throw new IllegalArgumentException("channelId can't be null");
            }
            this.channelId = channelId;
            return (T)this;
        }

        @Override
        public T opusEncodedData(byte[] data) {
            this.opusEncodedData = data;
            return (T)this;
        }

        @Override
        public T category(@Nullable String category) {
            this.category = category;
            return (T)this;
        }
    }
}

