/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.PlayerStatePacket;
import de.maxhenkel.voicechat.net.PlayerStatesPacket;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;

public class PlayerStateManager {
    private final ConcurrentHashMap<UUID, PlayerState> states;
    private final Server voicechatServer;

    public PlayerStateManager(Server voicechatServer) {
        this.voicechatServer = voicechatServer;
        this.states = new ConcurrentHashMap();
        CommonCompatibilityManager.INSTANCE.getNetManager().updateStateChannel.setServerListener((server, player, handler, packet) -> {
            PlayerState state = this.states.get(player.func_110124_au());
            if (state == null) {
                state = PlayerStateManager.defaultDisconnectedState(player);
            }
            state.setDisabled(packet.isDisabled());
            this.states.put(player.func_110124_au(), state);
            this.broadcastState(state);
            Voicechat.LOGGER.debug("Got state of {}: {}", player.getDisplayNameString(), state);
        });
    }

    public void broadcastState(PlayerState state) {
        PlayerStatePacket packet = new PlayerStatePacket(state);
        this.voicechatServer.getServer().func_184103_al().func_181057_v().forEach(p -> NetManager.sendToClient(p, packet));
        PluginManager.instance().onPlayerStateChanged(state);
    }

    public void onPlayerCompatibilityCheckSucceeded(EntityPlayerMP player) {
        PlayerStatesPacket packet = new PlayerStatesPacket(this.states);
        NetManager.sendToClient(player, packet);
        Voicechat.LOGGER.debug("Sending initial states to {}", player.getDisplayNameString());
    }

    public void onPlayerLoggedIn(EntityPlayerMP player) {
        PlayerState state = PlayerStateManager.defaultDisconnectedState(player);
        this.states.put(player.func_110124_au(), state);
        this.broadcastState(state);
        Voicechat.LOGGER.debug("Setting default state of {}: {}", player.getDisplayNameString(), state);
    }

    public void onPlayerLoggedOut(EntityPlayerMP player) {
        this.states.remove(player.func_110124_au());
        this.broadcastState(new PlayerState(player.func_110124_au(), player.func_146103_bH().getName(), false, true));
        Voicechat.LOGGER.debug("Removing state of {}", player.getDisplayNameString());
    }

    public void onPlayerVoicechatDisconnect(UUID uuid) {
        PlayerState state = this.states.get(uuid);
        if (state == null) {
            return;
        }
        state.setDisconnected(true);
        this.broadcastState(state);
        Voicechat.LOGGER.debug("Set state of {} to disconnected: {}", uuid, state);
    }

    public void onPlayerVoicechatConnect(EntityPlayerMP player) {
        PlayerState state = this.states.get(player.func_110124_au());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(player);
        }
        state.setDisconnected(false);
        this.states.put(player.func_110124_au(), state);
        this.broadcastState(state);
        Voicechat.LOGGER.debug("Set state of {} to connected: {}", player.getDisplayNameString(), state);
    }

    @Nullable
    public PlayerState getState(UUID playerUUID) {
        return this.states.get(playerUUID);
    }

    public static PlayerState defaultDisconnectedState(EntityPlayerMP player) {
        return new PlayerState(player.func_110124_au(), player.func_146103_bH().getName(), false, true);
    }

    public void setGroup(EntityPlayerMP player, @Nullable UUID group) {
        PlayerState state = this.states.get(player.func_110124_au());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(player);
            Voicechat.LOGGER.debug("Defaulting to default state for {}: {}", player.getDisplayNameString(), state);
        }
        state.setGroup(group);
        this.states.put(player.func_110124_au(), state);
        this.broadcastState(state);
        Voicechat.LOGGER.debug("Setting group of {}: {}", player.getDisplayNameString(), state);
    }

    public Collection<PlayerState> getStates() {
        return this.states.values();
    }
}

