/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.Side;
import xaero.lib.XaeroLib;
import xaero.lib.client.event.ClientEventsForge;
import xaero.lib.client.event.ModClientEventsForge;
import xaero.lib.common.event.CommonEventsForge;
import xaero.lib.common.permission.system.ForgePermissionSystem;
import xaero.lib.common.permission.system.PermissionSystemRegistry;

@Mod(modid="xaerolib", name="XaeroLib", acceptedMinecraftVersions="[1.12,1.12.2]", acceptableRemoteVersions="*")
public class XaeroLibForge
extends XaeroLib {
    public static final boolean FAKE_DEV_ENVIRONMENT = false;
    @Mod.Instance(value="xaerolib")
    public static XaeroLibForge instance;
    public Throwable deferredWorkError;
    private CommonEventsForge commonEvents;

    @Mod.EventHandler
    private void preInitForge(FMLPreInitializationEvent event) {
        INSTANCE = this;
        this.registerEvents(event.getSide());
    }

    private void registerEvents(Side distribution) {
        this.commonEvents = new CommonEventsForge();
        MinecraftForge.EVENT_BUS.register((Object)this.commonEvents);
        if (distribution == Side.CLIENT) {
            this.registerClientEvents();
        }
    }

    private void registerClientEvents() {
        ClientEventsForge clientEvents = new ClientEventsForge();
        MinecraftForge.EVENT_BUS.register((Object)clientEvents);
        MinecraftForge.EVENT_BUS.register((Object)new ModClientEventsForge(clientEvents));
    }

    @Mod.EventHandler
    private void initForge(FMLInitializationEvent event) {
        this.loadCommon();
        if (event.getSide() == Side.SERVER) {
            this.loadServer();
            return;
        }
        this.loadClient();
    }

    @Mod.EventHandler
    private void postInitForge(FMLPostInitializationEvent event) {
        try {
            this.loadCommonLater();
            if (event.getSide() == Side.SERVER) {
                this.loadServerLater();
                return;
            }
            this.loadClientLater();
        }
        catch (Throwable t) {
            this.deferredWorkError = t;
        }
    }

    @Override
    public void loadCommonLater() {
        PermissionSystemRegistry.INSTANCE.register(new ForgePermissionSystem());
        super.loadCommonLater();
        ForgePermissionSystem.registerNodes();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        this.checkDeferredWorkErrors();
        this.commonEvents.serverStarting(event.getServer());
    }

    public void checkDeferredWorkErrors() {
        if (this.deferredWorkError == null) {
            return;
        }
        if (this.deferredWorkError instanceof RuntimeException) {
            throw (RuntimeException)this.deferredWorkError;
        }
        throw new RuntimeException(this.deferredWorkError);
    }

    public CommonEventsForge getCommonEvents() {
        return this.commonEvents;
    }
}

