/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.config.option.ui.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import xaero.lib.client.config.option.ui.factory.IConfigOptionWidgetFactory;
import xaero.lib.client.config.option.ui.factory.ICustomOptionEditScreenFactory;
import xaero.lib.client.config.option.ui.factory.ViewEnforcedCondition;
import xaero.lib.client.config.option.value.redirect.ClientOptionValueRedirectorManager;
import xaero.lib.client.gui.IScreenBase;
import xaero.lib.client.gui.config.EditConfigScreen;
import xaero.lib.client.gui.config.EditStringConfigOptionScreen;
import xaero.lib.client.gui.widget.CycleButtonOption;
import xaero.lib.client.gui.widget.GuiActionButton;
import xaero.lib.client.gui.widget.IClickableWidget;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.client.gui.widget.XaeroCycleButton;
import xaero.lib.client.gui.widget.XaeroSliderWidget;
import xaero.lib.common.config.Config;
import xaero.lib.common.config.channel.ConfigChannel;
import xaero.lib.common.config.option.BuiltInProfiledConfigOptions;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.option.IndexedConfigOption;
import xaero.lib.common.config.util.ConfigUtils;

public class StandardConfigWidgetFactories {
    public static <T, CT extends IndexedConfigOption<T>> IConfigOptionWidgetFactory<CT> getIndexedCycleButtonFactory() {
        return new IConfigOptionWidgetFactory<CT>(){

            @Override
            public GuiButton create(CT option, Config config, Config enforced, int x, int y, int w, boolean includeNullValue, Runnable onChange, ConfigChannel channel, boolean clientSide, int screenWidth) {
                return StandardConfigWidgetFactories.createCycleButton(option, config, enforced, x, y, w, includeNullValue, ((IndexedConfigOption)option).getValidValues(), onChange, channel, clientSide);
            }
        };
    }

    public static <T, CT extends IndexedConfigOption<T>> IConfigOptionWidgetFactory<CT> getIndexedSliderFactory() {
        return new IConfigOptionWidgetFactory<CT>(){

            @Override
            public GuiButton create(CT option, Config config, Config enforced, int x, int y, int w, boolean includeNullValue, Runnable onChange, ConfigChannel channel, boolean clientSide, int screenWidth) {
                return StandardConfigWidgetFactories.createSliderWithValues(option, config, enforced, x, y, w, includeNullValue, ((IndexedConfigOption)option).getValidValues(), onChange, channel, clientSide, screenWidth);
            }
        };
    }

    public static <CT extends ConfigOption<?>> IConfigOptionWidgetFactory<CT> getStringEditFactory() {
        return new IConfigOptionWidgetFactory<CT>(){

            @Override
            public GuiButton create(CT option, Config config, Config enforced, int x, int y, int w, boolean includeNullValue, Runnable onChange, ConfigChannel channel, boolean clientSide, int screenWidth) {
                return StandardConfigWidgetFactories.createStringEditButton(option, config, enforced, x, y, w, includeNullValue, onChange, channel, clientSide, screenWidth);
            }
        };
    }

    public static <CT extends ConfigOption<?>> IConfigOptionWidgetFactory<CT> getOpenScreenFactory(final ICustomOptionEditScreenFactory<CT> screenFactory, final ViewEnforcedCondition viewEnforcedCondition) {
        return new IConfigOptionWidgetFactory<CT>(){

            @Override
            public GuiButton create(CT option, Config config, Config enforced, int x, int y, int w, boolean includeNullValue, Runnable onChange, ConfigChannel channel, boolean clientSide, int screenWidth) {
                return StandardConfigWidgetFactories.createOpenScreenButton(option, config, enforced, x, y, w, includeNullValue, onChange, channel, clientSide, screenFactory, viewEnforcedCondition);
            }
        };
    }

    private static <T, CT extends ConfigOption<T>> GuiButton createCycleButton(final CT option, final Config config, final Config enforced, int x, int y, int w, boolean includeNullValue, List<T> values, final Runnable onChange, ConfigChannel channel, final boolean clientSide) {
        final ArrayList<CycleButtonOption<Object>> allValues = new ArrayList<CycleButtonOption<Object>>();
        if (includeNullValue) {
            allValues.add(new CycleButtonOption<Object>(null));
        }
        values.stream().map(new Function<T, CycleButtonOption<T>>(){

            @Override
            public CycleButtonOption<T> apply(T v) {
                return new CycleButtonOption(v);
            }
        }).forEach(new Consumer<CycleButtonOption<T>>(){

            @Override
            public void accept(CycleButtonOption<T> vo) {
                allValues.add(vo);
            }
        });
        final ClientOptionValueRedirectorManager redirectorManager = clientSide ? channel.getClientConfigManager().getRedirectorManager() : null;
        XaeroCycleButton resultButton = XaeroCycleButton.builder(new Function<CycleButtonOption<T>, ITextComponent>(){

            @Override
            public ITextComponent apply(CycleButtonOption<T> v) {
                return ConfigUtils.getEffectiveValueName(redirectorManager, option, config, enforced);
            }
        }).withValues(allValues).withInitialValue(new CycleButtonOption(config.get(option))).create(x, y, w, 20, option.getDisplayName(), new BiConsumer<XaeroCycleButton<CycleButtonOption<T>>, CycleButtonOption<T>>(){

            @Override
            public void accept(XaeroCycleButton<CycleButtonOption<T>> button, CycleButtonOption<T> value) {
                if (clientSide && redirectorManager.redirectScreen(option)) {
                    return;
                }
                config.set(option, value.get());
                button.setValue(value);
                onChange.run();
            }
        });
        if (clientSide && redirectorManager.shouldDeactivateWidget(option)) {
            resultButton.field_146124_l = false;
        }
        StandardConfigWidgetFactories.addTooltipToWidget(resultButton, option, enforced, redirectorManager, null);
        return resultButton;
    }

    private static <T, CT extends ConfigOption<T>> GuiButton createSliderWithValues(final CT option, final Config config, final Config enforced, int x, int y, int w, boolean includeNullValue, List<T> values, Runnable onChange, final ConfigChannel channel, final boolean clientSide, int scaledScreenWidth) {
        double sliderValue;
        ClientOptionValueRedirectorManager redirectorManager;
        List<T> allValues = values;
        if (includeNullValue) {
            allValues = new ArrayList<T>();
            allValues.add(null);
            allValues.addAll(values);
        }
        final List<T> finalValues = allValues;
        Object currentValue = config.get(option);
        ClientOptionValueRedirectorManager clientOptionValueRedirectorManager = redirectorManager = clientSide ? channel.getClientConfigManager().getRedirectorManager() : null;
        if (finalValues.size() == 1 || clientSide && redirectorManager.shouldRedirect(option)) {
            sliderValue = 1.0;
        } else {
            sliderValue = (double)allValues.indexOf(currentValue) / (double)(finalValues.size() - 1);
            sliderValue = MathHelper.func_151237_a((double)sliderValue, (double)0.0, (double)1.0);
        }
        XaeroSliderWidget resultSlider = new XaeroSliderWidget(x, y, w, 20, StandardConfigWidgetFactories.getSliderLabel(option, config, enforced, channel, clientSide).func_150254_d(), sliderValue, new DoubleConsumer(){

            @Override
            public void accept(double newSliderValue) {
                if (clientSide && redirectorManager.redirectScreen(option)) {
                    return;
                }
                int newIndex = (int)Math.round(newSliderValue * (double)(finalValues.size() - 1));
                Object newValue = finalValues.get(newIndex);
                if (newValue != config.get(option)) {
                    config.set(option, newValue);
                    if (Minecraft.func_71410_x().field_71462_r instanceof EditConfigScreen) {
                        ((EditConfigScreen)Minecraft.func_71410_x().field_71462_r).handleChangesOnExit();
                    }
                }
            }
        }, new Supplier<String>(){

            @Override
            public String get() {
                return StandardConfigWidgetFactories.getSliderLabel(option, config, enforced, channel, clientSide).func_150254_d();
            }
        }, scaledScreenWidth);
        if (clientSide && redirectorManager.shouldDeactivateWidget(option)) {
            resultSlider.field_146124_l = false;
        }
        StandardConfigWidgetFactories.addTooltipToWidget(resultSlider, option, enforced, redirectorManager, null);
        return resultSlider;
    }

    private static <T> ITextComponent getSliderLabel(ConfigOption<T> option, Config config, Config enforced, ConfigChannel channel, boolean clientSide) {
        ClientOptionValueRedirectorManager redirectorManager = clientSide ? channel.getClientConfigManager().getRedirectorManager() : null;
        return ConfigUtils.optionNameValue(option.getDisplayName(), ConfigUtils.getEffectiveValueName(redirectorManager, option, config, enforced));
    }

    private static GuiButton createStringEditButton(ConfigOption<?> option, Config config, Config enforced, int x, int y, int w, boolean includeNullValue, Runnable onChange, ConfigChannel channel, boolean clientSide, int screenWidth) {
        return StandardConfigWidgetFactories.createOpenScreenButton(option, config, enforced, x, y, w, includeNullValue, onChange, channel, clientSide, new ICustomOptionEditScreenFactory<ConfigOption<?>>(){

            @Override
            public GuiScreen get(EditConfigScreen parent, GuiScreen escape, Config config1, Config enforced1, ConfigOption<?> option1, Runnable onChange1, boolean readOnly, boolean includeNullValue1) {
                return new EditStringConfigOptionScreen(parent, escape, config1, enforced1, option1, includeNullValue1, includeNullValue1, onChange1);
            }
        }, null);
    }

    private static <CT extends ConfigOption<?>> GuiButton createOpenScreenButton(final CT option, final Config config, final Config enforced, int x, int y, int w, final boolean includeNullValue, final Runnable onChange, ConfigChannel channel, final boolean clientSide, final ICustomOptionEditScreenFactory<CT> screenFactory, final ViewEnforcedCondition viewEnforcedCondition) {
        final ClientOptionValueRedirectorManager redirectorManager = clientSide ? channel.getClientConfigManager().getRedirectorManager() : null;
        ITextComponent displayName = option.getDisplayName();
        final boolean needsEnforcedIndicator = StandardConfigWidgetFactories.widgetNeedsEnforcedTooltipPrefix(option, enforced);
        if (needsEnforcedIndicator) {
            displayName = new TextComponentTranslation("gui.xaero_config_value_enforced", new Object[]{displayName.func_150259_f().func_150255_a(new Style().func_150238_a(TextFormatting.WHITE)), new TextComponentTranslation("gui.xaero_config_value_enforced_indicator", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW))}).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
        }
        GuiActionButton resultButton = new GuiActionButton(x, y, w, 20, displayName.func_150254_d()){

            @Override
            protected void onPress() {
                if (clientSide && redirectorManager.redirectScreen(option)) {
                    return;
                }
                GuiScreen parent = Minecraft.func_71410_x().field_71462_r;
                if (!(parent instanceof EditConfigScreen)) {
                    return;
                }
                GuiScreen escape = null;
                if (parent instanceof IScreenBase) {
                    escape = ((IScreenBase)parent).getEscape();
                }
                boolean readOnly = needsEnforcedIndicator && viewEnforcedCondition != null && viewEnforcedCondition.getCondition().getAsBoolean();
                Config screenConfig = readOnly ? enforced : config;
                Minecraft.func_71410_x().func_147108_a(screenFactory.get((EditConfigScreen)parent, escape, screenConfig, enforced, option, onChange, readOnly, includeNullValue));
            }
        };
        if (clientSide && redirectorManager.shouldDeactivateWidget(option)) {
            resultButton.field_146124_l = false;
        }
        StandardConfigWidgetFactories.addTooltipToWidget(resultButton, option, enforced, redirectorManager, viewEnforcedCondition);
        return resultButton;
    }

    private static <CT extends ConfigOption<?>> void addTooltipToWidget(GuiButton widget, CT option, Config enforced, ClientOptionValueRedirectorManager redirectorManager, ViewEnforcedCondition viewEnforcedCondition) {
        if (!(widget instanceof IClickableWidget)) {
            return;
        }
        if (redirectorManager != null && redirectorManager.shouldRedirect(option)) {
            ((IClickableWidget)widget).setXaero_tooltip(new Tooltip(redirectorManager.getTooltip(option)));
            return;
        }
        Object tooltipComponent = null;
        if (StandardConfigWidgetFactories.widgetNeedsEnforcedTooltipPrefix(option, enforced)) {
            tooltipComponent = viewEnforcedCondition != null ? viewEnforcedCondition.getTooltip().func_150259_f() : new TextComponentTranslation("gui.xaero_config_value_enforced_tooltip_prefix", new Object[0]);
            tooltipComponent.func_150256_b().func_150238_a(TextFormatting.YELLOW);
        }
        if (option.getTooltip() != null) {
            ITextComponent mainTooltip = option.getTooltip().func_150259_f();
            mainTooltip.func_150256_b().func_150238_a(TextFormatting.WHITE);
            if (tooltipComponent == null) {
                tooltipComponent = mainTooltip;
            } else {
                tooltipComponent.func_150253_a().add(new TextComponentString(" \\n \\n "));
                tooltipComponent.func_150253_a().add(mainTooltip);
            }
        }
        if (tooltipComponent == null) {
            return;
        }
        ((IClickableWidget)widget).setXaero_tooltip(new Tooltip((ITextComponent)tooltipComponent));
    }

    public static boolean widgetNeedsEnforcedTooltipPrefix(ConfigOption<?> option, Config enforced) {
        return enforced != null && option != BuiltInProfiledConfigOptions.PROFILE_NAME && enforced.get(option) != null;
    }
}

