/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.config.option.value.io.serialization;

import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import xaero.lib.common.config.option.value.io.serialization.ConfigValueIOCodec;

public class BuiltInConfigValueIOCodecs {
    public static final ConfigValueIOCodec<Boolean> BOOLEAN = new ConfigValueIOCodec<Boolean>(new Function<Boolean, String>(){

        @Override
        public String apply(Boolean b) {
            return "" + b;
        }
    }, new Function<String, Boolean>(){

        @Override
        public Boolean apply(String s) {
            return s.equals("true");
        }
    }, 5);
    public static final ConfigValueIOCodec<Integer> INTEGER = new ConfigValueIOCodec<Integer>(new Function<Integer, String>(){

        @Override
        public String apply(Integer i) {
            return "" + i;
        }
    }, new Function<String, Integer>(){

        @Override
        public Integer apply(String s) {
            return Integer.parseInt(s);
        }
    }, "-2147483648".length());
    public static final ConfigValueIOCodec<Double> DOUBLE = new ConfigValueIOCodec<Double>(new Function<Double, String>(){

        @Override
        public String apply(Double d) {
            return "" + d;
        }
    }, new Function<String, Double>(){

        @Override
        public Double apply(String s) {
            return Double.parseDouble(s);
        }
    }, 100);
    public static final ConfigValueIOCodec<ResourceLocation> RESOURCE_LOCATION = new ConfigValueIOCodec<ResourceLocation>(new Function<ResourceLocation, String>(){

        @Override
        public String apply(ResourceLocation rl) {
            return rl.toString();
        }
    }, new Function<String, ResourceLocation>(){

        @Override
        public ResourceLocation apply(String s) {
            return new ResourceLocation(s);
        }
    }, 200);

    public static ConfigValueIOCodec<String> getString(int maxLength) {
        return new ConfigValueIOCodec<String>(new Function<String, String>(){

            @Override
            public String apply(String s) {
                return s;
            }
        }, new Function<String, String>(){

            @Override
            public String apply(String s) {
                return s;
            }
        }, maxLength);
    }
}

