/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet.config.profile;

import java.util.function.BiConsumer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import xaero.lib.XaeroLib;
import xaero.lib.common.packet.XaeroPacket;
import xaero.lib.common.player.ServerPlayerData;
import xaero.lib.platform.Services;

public final class ConfigProfileCreatePacket
extends XaeroPacket {
    private String id;
    private String name;
    private String profileToCopy;

    public ConfigProfileCreatePacket(String id, String name, String profileToCopy) {
        this.id = id;
        this.name = name;
        this.profileToCopy = profileToCopy;
    }

    public ConfigProfileCreatePacket() {
    }

    @Override
    public void write(PacketBuffer buffer) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("i", this.id);
        tag.func_74778_a("n", this.name);
        tag.func_74778_a("c", this.profileToCopy);
        buffer.func_150786_a(tag);
    }

    @Override
    public void read(PacketBuffer buffer) {
        NBTTagCompound tag = this.readUnlimitedTag(buffer);
        if (tag == null) {
            return;
        }
        this.id = tag.func_74779_i("i");
        this.name = tag.func_74779_i("n");
        this.profileToCopy = tag.func_74779_i("c");
    }

    public static final class ServerHandler
    implements BiConsumer<ConfigProfileCreatePacket, EntityPlayerMP> {
        @Override
        public void accept(ConfigProfileCreatePacket packet, EntityPlayerMP player) {
            block2: {
                try {
                    ServerPlayerData.get(player).getConfigSynchronizer().onCreateConfigProfilePacket(packet.id, packet.name, packet.profileToCopy);
                }
                catch (Throwable t) {
                    if (!Services.PLATFORM.isDevelopmentEnvironment()) break block2;
                    XaeroLib.LOGGER.error("packet error", t);
                }
            }
        }
    }
}

