/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet.config.profile;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import xaero.lib.XaeroLib;
import xaero.lib.common.packet.XaeroPacket;
import xaero.lib.common.player.ServerPlayerData;

public class ConfigProfileDeletePacket
extends XaeroPacket {
    private String profileId;

    public ConfigProfileDeletePacket(String profileId) {
        this.profileId = profileId;
    }

    public ConfigProfileDeletePacket() {
    }

    @Override
    public void write(PacketBuffer buffer) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("i", this.profileId);
        buffer.func_150786_a(tag);
    }

    @Override
    public void read(PacketBuffer buffer) {
        NBTTagCompound tag = this.readTag(buffer, new NBTSizeTracker(65536L));
        if (tag == null) {
            return;
        }
        this.profileId = tag.func_74779_i("i");
    }

    public static final class ClientHandler
    implements Consumer<ConfigProfileDeletePacket> {
        @Override
        public void accept(ConfigProfileDeletePacket packet) {
            XaeroLib.INSTANCE.getClient().getConfigSynchronizer().onDeleteConfigProfilePacket(packet.profileId);
        }
    }

    public static final class ServerHandler
    implements BiConsumer<ConfigProfileDeletePacket, EntityPlayerMP> {
        @Override
        public void accept(ConfigProfileDeletePacket packet, EntityPlayerMP player) {
            ServerPlayerData.get(player).getConfigSynchronizer().onDeleteConfigProfilePacket(packet.profileId);
        }
    }
}

