/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiControls;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.client.controls.util.KeyMappingUtils;
import xaero.lib.client.gui.config.context.BuiltInEditConfigScreenContexts;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.single.SingleConfigManager;
import xaero.lib.common.reflection.util.ReflectionUtils;
import xaero.lib.common.util.MathUtils;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.animation.Animation;
import xaero.map.animation.SinAnimation;
import xaero.map.animation.SlowingAnimation;
import xaero.map.common.config.WorldMapConfigConstants;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.config.primary.option.WorldMapPrimaryClientConfigOptions;
import xaero.map.config.util.WorldMapClientConfigUtils;
import xaero.map.controls.ControlsRegister;
import xaero.map.effects.Effects;
import xaero.map.element.HoveredMapElementHolder;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.gui.ExportScreen;
import xaero.map.gui.GuiCaveModeOptions;
import xaero.map.gui.GuiMapSwitching;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.gui.GuiWorldMapSettings;
import xaero.map.gui.IRightClickableElement;
import xaero.map.gui.MapMouseButtonPress;
import xaero.map.gui.MapTileSelection;
import xaero.map.gui.ScreenBase;
import xaero.map.gui.dropdown.rightclick.GuiRightClickMenu;
import xaero.map.gui.dropdown.rightclick.RightClickOption;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.Waypoint;
import xaero.map.radar.tracker.PlayerTeleporter;
import xaero.map.radar.tracker.PlayerTrackerMapElement;
import xaero.map.region.BranchLeveledRegion;
import xaero.map.region.LayeredRegionManager;
import xaero.map.region.LeveledRegion;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.texture.RegionTexture;
import xaero.map.teleport.MapTeleporter;
import xaero.map.world.MapDimension;
import xaero.map.world.MapDimensionTypeInfo;
import xaero.map.world.MapWorld;

public class GuiMap
extends ScreenBase
implements IRightClickableElement {
    public static final VertexFormat POSITION_TEX_TEX_TEX = new VertexFormat();
    public static final VertexFormatElement TEX_2F_1 = new VertexFormatElement(1, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.UV, 2);
    public static final VertexFormatElement TEX_2F_2 = new VertexFormatElement(2, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.UV, 2);
    public static final VertexFormatElement TEX_2F_3 = new VertexFormatElement(3, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.UV, 2);
    public static final Field KEY_BINDING_PRESSED_FIELD;
    private static final ITextComponent FULL_RELOAD_IN_PROGRESS;
    private static final ITextComponent UNKNOWN_DIMENSION_TYPE1;
    private static final ITextComponent UNKNOWN_DIMENSION_TYPE2;
    private static final double ZOOM_STEP = 1.2;
    private static final int white = -1;
    private static final int blackTrans = 0x33000000;
    private static final int whiteTrans = 0x28FFFFFF;
    private static final int redTrans = 687800320;
    private static final int yellowTrans = 687865600;
    private static final int purpleTrans = 687800575;
    private static final int greenTrans = 671153920;
    private static final int black = -16777216;
    private static int lastAmountOfRegionsViewed;
    private long loadingAnimationStart;
    private Entity player;
    private int screenScale = 0;
    private int mouseDownPosX = -1;
    private int mouseDownPosY = -1;
    private double mouseDownCameraX = -1.0;
    private double mouseDownCameraZ = -1.0;
    private int mouseCheckPosX = -1;
    private int mouseCheckPosY = -1;
    private long mouseCheckTimeNano = -1L;
    private int prevMouseCheckPosX = -1;
    private int prevMouseCheckPosY = -1;
    private long prevMouseCheckTimeNano = -1L;
    private double cameraX = 0.0;
    private double cameraZ = 0.0;
    private boolean shouldResetCameraPos;
    private int[] cameraDestination = null;
    private SlowingAnimation cameraDestinationAnimX = null;
    private SlowingAnimation cameraDestinationAnimZ = null;
    private double scale;
    private double userScale;
    private static double destScale;
    private boolean pauseZoomKeys;
    private int lastZoomMethod;
    private double prevPlayerDimDiv;
    private HoveredMapElementHolder<?, ?> viewed = null;
    private boolean viewedInList;
    private HoveredMapElementHolder<?, ?> viewedOnMousePress = null;
    private boolean overWaypointsMenu;
    private Animation zoomAnim;
    public boolean waypointMenu = false;
    private boolean overPlayersMenu;
    public boolean playersMenu = false;
    private static ImprovedFramebuffer primaryScaleFBO;
    private float[] colourBuffer = new float[4];
    private ArrayList<MapRegion> regionBuffer = new ArrayList();
    private ArrayList<BranchLeveledRegion> branchRegionBuffer = new ArrayList();
    private boolean prevWaitingForBranchCache = true;
    private boolean prevLoadingLeaves = true;
    private Integer lastNonNullViewedDimensionId;
    private Integer lastViewedDimensionId;
    private String lastViewedMultiworldId;
    private int mouseBlockPosX;
    private int mouseBlockPosY;
    private int mouseBlockPosZ;
    private Integer mouseBlockDim;
    private double mouseBlockCoordinateScale = 1.0;
    private long lastStartTime;
    private final GuiMapSwitching mapSwitchingGui;
    private MapMouseButtonPress leftMouseButton;
    private MapMouseButtonPress rightMouseButton;
    private MapProcessor mapProcessor;
    private MapDimension futureDimension;
    private ScaledResolution scaledresolution;
    public boolean noUploadingLimits;
    private boolean[] waitingForBranchCache = new boolean[1];
    private GuiButton settingsButton;
    private GuiButton exportButton;
    private GuiButton waypointsButton;
    private GuiButton playersButton;
    private GuiButton radarButton;
    private GuiButton zoomInButton;
    private GuiButton zoomOutButton;
    private GuiButton keybindingsButton;
    private GuiButton caveModeButton;
    private GuiButton dimensionToggleButton;
    private GuiButton buttonPressed;
    private GuiRightClickMenu rightClickMenu;
    private int rightClickX;
    private int rightClickY;
    private int rightClickZ;
    private Integer rightClickDim;
    private double rightClickCoordinateScale;
    private GuiTextField focusedField;
    private boolean lastFrameRenderedRootTextures;
    private MapTileSelection mapTileSelection;
    private GuiCaveModeOptions caveModeOptions;

    public GuiMap(GuiScreen parent, GuiScreen escape, MapProcessor mapProcessor, Entity player) {
        super(parent, escape, (ITextComponent)new TextComponentTranslation("gui.xaero_world_map_screen", new Object[0]));
        this.player = player;
        this.shouldResetCameraPos = true;
        this.leftMouseButton = new MapMouseButtonPress();
        this.rightMouseButton = new MapMouseButtonPress();
        this.mapSwitchingGui = new GuiMapSwitching(mapProcessor);
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        boolean openingAnimationConfig = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.OPENING_ANIMATION);
        this.userScale = destScale * (double)(openingAnimationConfig ? 1.5f : 1.0f);
        this.zoomAnim = new SlowingAnimation(this.userScale, destScale, 0.88, destScale * 0.001);
        this.mapProcessor = mapProcessor;
        this.caveModeOptions = new GuiCaveModeOptions();
        if (SupportMods.minimap()) {
            SupportMods.xaeroMinimap.onMapConstruct();
        }
    }

    private double getScaleMultiplier(int screenShortSide) {
        return screenShortSide <= 1080 ? 1.0 : (double)screenShortSide / 1080.0;
    }

    public void addGuiButton(GuiButton b) {
        super.func_189646_b(b);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        MapWorld mapWorld = this.mapProcessor.getMapWorld();
        this.futureDimension = mapWorld == null ? null : mapWorld.getFutureDimension();
        boolean waypointsEnabled = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.WAYPOINTS);
        this.waypointMenu = this.waypointMenu && waypointsEnabled;
        this.mapSwitchingGui.init(this, this.field_146297_k, this.field_146294_l, this.field_146295_m);
        boolean effectiveCaveModeAllowed = WorldMapClientConfigUtils.getEffectiveCaveModeAllowed();
        final Tooltip caveModeButtonTooltip = new Tooltip((ITextComponent)new TextComponentTranslation(effectiveCaveModeAllowed ? "gui.xaero_box_cave_mode" : "gui.xaero_box_cave_mode_not_allowed", new Object[0]));
        this.caveModeButton = new GuiTexturedButton(0, this.field_146295_m - 40, 20, 20, 229, 64, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                GuiMap.this.onCaveModeButton(b);
            }
        }, new Supplier<Tooltip>(){

            @Override
            public Tooltip get() {
                return caveModeButtonTooltip;
            }
        });
        this.caveModeButton.field_146124_l = effectiveCaveModeAllowed;
        this.func_189646_b(this.caveModeButton);
        this.caveModeOptions.onInit(this, this.mapProcessor);
        final Tooltip dimensionToggleButtonTooltip = new Tooltip((ITextComponent)new TextComponentTranslation("gui.xaero_dimension_toggle_button", new Object[]{KeyMappingUtils.getKeyName((KeyBinding)ControlsRegister.keyToggleDimension)}));
        this.dimensionToggleButton = new GuiTexturedButton(0, this.field_146295_m - 60, 20, 20, 197, 80, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                GuiMap.this.onDimensionToggleButton(b);
            }
        }, new Supplier<Tooltip>(){

            @Override
            public Tooltip get() {
                return dimensionToggleButtonTooltip;
            }
        });
        this.func_189646_b(this.dimensionToggleButton);
        this.loadingAnimationStart = System.currentTimeMillis();
        this.scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        this.screenScale = this.scaledresolution.func_78325_e();
        this.pauseZoomKeys = false;
        final Tooltip openSettingsTooltip = new Tooltip((ITextComponent)new TextComponentTranslation("gui.xaero_box_open_settings", new Object[]{KeyMappingUtils.getKeyName((KeyBinding)ControlsRegister.keyOpenSettings)}));
        this.settingsButton = new GuiTexturedButton(0, 0, 30, 30, 113, 0, 20, 20, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                GuiMap.this.onSettingsButton(b);
            }
        }, new Supplier<Tooltip>(){

            @Override
            public Tooltip get() {
                return openSettingsTooltip;
            }
        });
        this.func_189646_b(this.settingsButton);
        final Tooltip waypointsTooltip = waypointsEnabled ? new Tooltip(this.waypointMenu ? "gui.xaero_box_close_waypoints" : "gui.xaero_box_open_waypoints") : new Tooltip(!SupportMods.minimap() ? "gui.xaero_box_waypoints_minimap_required" : "gui.xaero_box_waypoints_disabled");
        final Tooltip playersTooltip = new Tooltip(this.playersMenu ? "gui.xaero_box_close_players" : "gui.xaero_box_open_players");
        this.waypointsButton = new GuiTexturedButton(this.field_146294_l - 20, this.field_146295_m - 20, 20, 20, 213, 0, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                GuiMap.this.onWaypointsButton(b);
            }
        }, new Supplier<Tooltip>(){

            @Override
            public Tooltip get() {
                return waypointsTooltip;
            }
        });
        this.func_189646_b(this.waypointsButton);
        this.waypointsButton.field_146124_l = waypointsEnabled;
        this.playersButton = new GuiTexturedButton(this.field_146294_l - 20, this.field_146295_m - 40, 20, 20, 197, 32, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                GuiMap.this.onPlayersButton(b);
            }
        }, new Supplier<Tooltip>(){

            @Override
            public Tooltip get() {
                return playersTooltip;
            }
        });
        this.func_189646_b(this.playersButton);
        boolean minimapRadarConfig = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.MINIMAP_RADAR);
        final Tooltip radarButtonTooltip = new Tooltip((ITextComponent)new TextComponentTranslation(minimapRadarConfig ? "gui.xaero_box_minimap_radar" : "gui.xaero_box_no_minimap_radar", new Object[]{new TextComponentString(KeyMappingUtils.getKeyName((KeyBinding)(SupportMods.minimap() ? SupportMods.xaeroMinimap.getToggleRadarKey() : null))).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN))}));
        this.radarButton = new GuiTexturedButton(this.field_146294_l - 20, this.field_146295_m - 60, 20, 20, minimapRadarConfig ? 213 : 229, 32, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                GuiMap.this.onRadarButton(b);
            }
        }, new Supplier<Tooltip>(){

            @Override
            public Tooltip get() {
                return radarButtonTooltip;
            }
        });
        this.func_189646_b(this.radarButton);
        this.getRadarButton().field_146124_l = SupportMods.minimap();
        final Tooltip exportButtonTooltip = new Tooltip("gui.xaero_box_export");
        this.exportButton = new GuiTexturedButton(this.field_146294_l - 20, this.field_146295_m - 80, 20, 20, 133, 0, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                GuiMap.this.onExportButton(b);
            }
        }, new Supplier<Tooltip>(){

            @Override
            public Tooltip get() {
                return exportButtonTooltip;
            }
        });
        this.func_189646_b(this.exportButton);
        final Tooltip controlsButtonTooltip = new Tooltip((ITextComponent)new TextComponentTranslation("gui.xaero_box_controls", new Object[]{SupportMods.minimap() ? SupportMods.xaeroMinimap.getControlsTooltip() : ""}));
        this.keybindingsButton = new GuiTexturedButton(this.field_146294_l - 20, this.field_146295_m - 100, 20, 20, 197, 0, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                GuiMap.this.onKeybindingsButton(b);
            }
        }, new Supplier<Tooltip>(){

            @Override
            public Tooltip get() {
                return controlsButtonTooltip;
            }
        });
        this.func_189646_b(this.keybindingsButton);
        final Tooltip zoomInButtonTooltip = new Tooltip((ITextComponent)new TextComponentTranslation("gui.xaero_box_zoom_in", new Object[]{new TextComponentString(KeyMappingUtils.getKeyName((KeyBinding)ControlsRegister.keyZoomIn)).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN))}));
        this.zoomInButton = new GuiTexturedButton(this.field_146294_l - 20, this.field_146295_m - 140, 20, 20, 165, 0, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                GuiMap.this.onZoomInButton(b);
            }
        }, new Supplier<Tooltip>(){

            @Override
            public Tooltip get() {
                return zoomInButtonTooltip;
            }
        });
        final Tooltip zoomOutButtonTooltip = new Tooltip((ITextComponent)new TextComponentTranslation("gui.xaero_box_zoom_out", new Object[]{new TextComponentString(KeyMappingUtils.getKeyName((KeyBinding)ControlsRegister.keyZoomOut)).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN))}));
        this.zoomOutButton = new GuiTexturedButton(this.field_146294_l - 20, this.field_146295_m - 120, 20, 20, 181, 0, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                GuiMap.this.onZoomOutButton(b);
            }
        }, new Supplier<Tooltip>(){

            @Override
            public Tooltip get() {
                return zoomOutButtonTooltip;
            }
        });
        if (((Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.ZOOM_BUTTONS)).booleanValue()) {
            this.func_189646_b(this.zoomOutButton);
            this.func_189646_b(this.zoomInButton);
        }
        if (SupportMods.minimap()) {
            SupportMods.xaeroMinimap.requestWaypointsRefresh();
            if (this.waypointMenu) {
                SupportMods.xaeroMinimap.onMapInit(this, this.field_146297_k, this.field_146294_l, this.field_146295_m);
            }
        }
        if (this.playersMenu) {
            WorldMap.trackedPlayerMenuRenderer.onMapInit(this, this.field_146297_k, this.field_146294_l, this.field_146295_m);
        }
        if (this.rightClickMenu != null) {
            this.rightClickMenu.setClosed(true);
            this.rightClickMenu = null;
        }
        Keyboard.enableRepeatEvents((boolean)true);
    }

    private void onCaveModeButton(GuiButton b) {
        this.caveModeOptions.toggle(this);
    }

    private void onDimensionToggleButton(GuiButton b) {
        this.mapProcessor.getMapWorld().toggleDimension(!GuiMap.func_146272_n());
        String messageType = this.mapProcessor.getMapWorld().getCustomDimensionId() == null ? "gui.xaero_switched_to_current_dimension" : "gui.xaero_switched_to_dimension";
        this.mapProcessor.getMessageBox().addMessage((ITextComponent)new TextComponentTranslation(messageType, new Object[]{this.mapProcessor.getMapWorld().getFutureDimension().getDropdownLabel()}));
        this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
    }

    private void onSettingsButton(GuiButton b) {
        this.field_146297_k.func_147108_a((GuiScreen)new GuiWorldMapSettings((GuiScreen)this, (GuiScreen)this, BuiltInEditConfigScreenContexts.CLIENT));
    }

    private void onKeybindingsButton(GuiButton b) {
        this.field_146297_k.func_147108_a((GuiScreen)new GuiControls((GuiScreen)this, this.field_146297_k.field_71474_y));
    }

    private void onExportButton(GuiButton b) {
        this.field_146297_k.func_147108_a((GuiScreen)new ExportScreen((GuiScreen)this, (GuiScreen)this, this.mapProcessor, this.mapTileSelection));
    }

    private void toggleWaypointMenu() {
        if (this.playersMenu) {
            this.togglePlayerMenu();
        }
        boolean bl = this.waypointMenu = !this.waypointMenu;
        if (!this.waypointMenu) {
            SupportMods.xaeroMinimap.getWaypointMenuRenderer().onMenuClosed();
            this.unfocusAll();
        }
    }

    private void togglePlayerMenu() {
        if (this.waypointMenu) {
            this.toggleWaypointMenu();
        }
        boolean bl = this.playersMenu = !this.playersMenu;
        if (!this.playersMenu) {
            WorldMap.trackedPlayerMenuRenderer.onMenuClosed();
            this.unfocusAll();
        }
    }

    private void onPlayersButton(GuiButton b) {
        this.togglePlayerMenu();
        this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
    }

    private void onWaypointsButton(GuiButton b) {
        this.toggleWaypointMenu();
        this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
    }

    public void onRadarButton(GuiButton b) {
        WorldMapClientConfigUtils.tryTogglingCurrentProfileOption((ConfigOption<Boolean>)WorldMapProfiledConfigOptions.MINIMAP_RADAR);
        this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
    }

    private void onZoomInButton(GuiButton b) {
        this.buttonPressed = b;
    }

    private void onZoomOutButton(GuiButton b) {
        this.buttonPressed = b;
    }

    public void func_73864_a(int par1, int par2, int par3) throws IOException {
        boolean result;
        super.func_73864_a(par1, par2, par3);
        if (this.handledMouseInput) {
            return;
        }
        boolean bl = result = this.waypointMenu && SupportMods.xaeroMinimap.getWaypointMenuRenderer().getFilterField().func_146192_a(par1, par2, par3);
        if (!result) {
            boolean bl2 = result = this.playersMenu && WorldMap.trackedPlayerMenuRenderer.getFilterField().func_146192_a(par1, par2, par3);
        }
        if (!result) {
            boolean bl3 = result = this.caveModeOptions.isEnabled() && this.caveModeOptions.getCaveModeStartField().func_146192_a(par1, par2, par3);
        }
        if (!result) {
            if (par3 == 0) {
                this.leftMouseButton.clicked = true;
                this.leftMouseButton.isDown = true;
                this.leftMouseButton.pressedAtX = (int)Misc.getMouseX(this.field_146297_k);
                this.leftMouseButton.pressedAtY = (int)Misc.getMouseY(this.field_146297_k);
            } else if (par3 == 1) {
                this.rightMouseButton.clicked = true;
                this.rightMouseButton.isDown = true;
                this.rightMouseButton.pressedAtX = (int)Misc.getMouseX(this.field_146297_k);
                this.rightMouseButton.pressedAtY = (int)Misc.getMouseY(this.field_146297_k);
                this.viewedOnMousePress = this.viewed;
                this.rightClickX = this.mouseBlockPosX;
                this.rightClickY = this.mouseBlockPosY;
                this.rightClickZ = this.mouseBlockPosZ;
                this.rightClickDim = this.mouseBlockDim;
                this.rightClickCoordinateScale = this.mouseBlockCoordinateScale;
                if (SupportMods.minimap()) {
                    SupportMods.xaeroMinimap.onRightClick();
                }
                if (this.viewedOnMousePress == null || !this.viewedOnMousePress.isRightClickValid()) {
                    this.mapTileSelection = new MapTileSelection(this.rightClickX >> 4, this.rightClickZ >> 4);
                }
            } else {
                result = this.onInputPress(true, par3);
            }
            if (!result && this.caveModeOptions.isEnabled()) {
                this.caveModeOptions.toggle(this);
                result = true;
            }
        }
        if (this.waypointMenu && SupportMods.xaeroMinimap.getWaypointMenuRenderer().getFilterField().func_146206_l()) {
            this.setFocused(SupportMods.xaeroMinimap.getWaypointMenuRenderer().getFilterField());
        } else if (this.playersMenu && WorldMap.trackedPlayerMenuRenderer.getFilterField().func_146206_l()) {
            this.setFocused(WorldMap.trackedPlayerMenuRenderer.getFilterField());
        } else if (this.caveModeOptions.isEnabled() && this.caveModeOptions.getCaveModeStartField().func_146206_l()) {
            this.setFocused(this.caveModeOptions.getCaveModeStartField());
        } else {
            this.setFocused(null);
        }
    }

    public void func_146286_b(int par1, int par2, int par3) {
        this.buttonPressed = null;
        int mouseX = (int)Misc.getMouseX(this.field_146297_k);
        int mouseY = (int)Misc.getMouseY(this.field_146297_k);
        if (this.leftMouseButton.isDown && par3 == 0) {
            this.leftMouseButton.isDown = false;
            if (Math.abs(this.leftMouseButton.pressedAtX - mouseX) < 5 && Math.abs(this.leftMouseButton.pressedAtY - mouseY) < 5) {
                this.mapClicked(0, this.leftMouseButton.pressedAtX, this.leftMouseButton.pressedAtY);
            }
            this.leftMouseButton.pressedAtX = -1;
            this.leftMouseButton.pressedAtY = -1;
        }
        if (this.rightMouseButton.isDown && par3 == 1) {
            this.rightMouseButton.isDown = false;
            this.mapClicked(1, mouseX, mouseY);
            this.rightMouseButton.pressedAtX = -1;
            this.rightMouseButton.pressedAtY = -1;
        }
        if (this.waypointMenu) {
            SupportMods.xaeroMinimap.onMapMouseRelease(par1, par2, par3);
        }
        if (this.playersMenu) {
            WorldMap.trackedPlayerMenuRenderer.onMapMouseRelease(par1, par2, par3);
        }
        super.func_146286_b(par1, par2, par3);
        this.onInputRelease(true, par3);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (this.handledMouseInput) {
            return;
        }
        int wheel = Mouse.getEventDWheel() / 120;
        if (wheel != 0) {
            int direction;
            int n = direction = wheel > 0 ? 1 : -1;
            if (this.overWaypointsMenu) {
                SupportMods.xaeroMinimap.getWaypointMenuRenderer().mouseScrolled(direction);
            } else if (this.playersMenu && this.overPlayersMenu) {
                WorldMap.trackedPlayerMenuRenderer.mouseScrolled(direction);
            } else {
                this.changeZoom(wheel, 0);
            }
        }
    }

    private void changeZoom(double factor, int zoomMethod) {
        this.closeDropdowns();
        this.lastZoomMethod = zoomMethod;
        this.cameraDestinationAnimX = null;
        this.cameraDestinationAnimZ = null;
        if (GuiMap.func_146271_m()) {
            double destScaleBefore = destScale;
            if (destScale >= 1.0) {
                destScale = factor > 0.0 ? Math.ceil(destScale) : Math.floor(destScale);
                if (destScaleBefore == destScale) {
                    destScale += factor > 0.0 ? 1.0 : -1.0;
                }
                if (destScale == 0.0) {
                    destScale = 0.5;
                }
            } else {
                double reversedScale = 1.0 / destScale;
                double log2 = Math.log(reversedScale) / Math.log(2.0);
                log2 = factor > 0.0 ? Math.floor(log2) : Math.ceil(log2);
                destScale = 1.0 / Math.pow(2.0, log2);
                if (destScaleBefore == destScale) {
                    destScale = 1.0 / Math.pow(2.0, log2 + (double)(factor > 0.0 ? -1 : 1));
                }
            }
        } else {
            destScale *= Math.pow(1.2, factor);
        }
        if (destScale < 0.0625) {
            destScale = 0.0625;
        } else if (destScale > 50.0) {
            destScale = 50.0;
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.leftMouseButton.isDown = false;
        this.rightMouseButton.isDown = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73863_a(int scaledMouseX, int scaledMouseY, float partialTicks) {
        int direction;
        MapDimension currentFutureDim;
        OpenGlHelper.func_176072_g((int)OpenGlHelper.field_176089_P, (int)0);
        while (GL11.glGetError() != 0) {
        }
        GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        Minecraft mc = Minecraft.func_71410_x();
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        SingleConfigManager primaryConfigManager = WorldMap.INSTANCE.getConfigs().getPrimaryClientConfigManager();
        long startTime = System.currentTimeMillis();
        MapDimension mapDimension = currentFutureDim = !this.mapProcessor.isMapWorldUsable() ? null : this.mapProcessor.getMapWorld().getFutureDimension();
        if (currentFutureDim != this.futureDimension) {
            this.func_146280_a(mc, this.field_146294_l, this.field_146295_m);
        }
        double playerDimDiv = this.prevPlayerDimDiv;
        Object object = this.mapProcessor.renderThreadPauseSync;
        synchronized (object) {
            MapDimension mapDim;
            if (!this.mapProcessor.isRenderingPaused() && (mapDim = this.mapProcessor.getMapWorld().getCurrentDimension()) != null) {
                playerDimDiv = mapDim.calculateDimDiv(this.player.field_70170_p.field_73011_w);
            }
        }
        double scaledPlayerX = this.player.field_70165_t / playerDimDiv;
        double scaledPlayerZ = this.player.field_70161_v / playerDimDiv;
        if (this.shouldResetCameraPos) {
            this.cameraX = (float)scaledPlayerX;
            this.cameraZ = (float)scaledPlayerZ;
            this.shouldResetCameraPos = false;
        } else if (this.prevPlayerDimDiv != 0.0 && playerDimDiv != this.prevPlayerDimDiv) {
            double oldScaledPlayerX = this.player.field_70165_t / this.prevPlayerDimDiv;
            double oldScaledPlayerZ = this.player.field_70161_v / this.prevPlayerDimDiv;
            this.cameraX = this.cameraX - oldScaledPlayerX + scaledPlayerX;
            this.cameraZ = this.cameraZ - oldScaledPlayerZ + scaledPlayerZ;
            this.cameraDestinationAnimX = null;
            this.cameraDestinationAnimZ = null;
            this.cameraDestination = null;
        }
        this.prevPlayerDimDiv = playerDimDiv;
        double cameraXBefore = this.cameraX;
        double cameraZBefore = this.cameraZ;
        double scaleBefore = this.scale;
        this.mapSwitchingGui.preMapRender(this, mc, this.field_146294_l, this.field_146295_m);
        long passed = this.lastStartTime == 0L ? 16L : startTime - this.lastStartTime;
        double passedScrolls = (float)passed / 64.0f;
        int n = this.buttonPressed == this.zoomInButton || KeyMappingUtils.isPhysicallyDown((KeyBinding)ControlsRegister.keyZoomIn) ? 1 : (direction = this.buttonPressed == this.zoomOutButton || KeyMappingUtils.isPhysicallyDown((KeyBinding)ControlsRegister.keyZoomOut) ? -1 : 0);
        if (direction != 0) {
            boolean ctrlKey = GuiMap.func_146271_m();
            if (!ctrlKey || !this.pauseZoomKeys) {
                this.changeZoom((double)direction * passedScrolls, this.buttonPressed == this.zoomInButton || this.buttonPressed == this.zoomOutButton ? 2 : 1);
                if (ctrlKey) {
                    this.pauseZoomKeys = true;
                }
            }
        } else {
            this.pauseZoomKeys = false;
        }
        this.lastStartTime = startTime;
        if (this.cameraDestination != null) {
            this.cameraDestinationAnimX = new SlowingAnimation(this.cameraX, this.cameraDestination[0], 0.9, 0.01);
            this.cameraDestinationAnimZ = new SlowingAnimation(this.cameraZ, this.cameraDestination[1], 0.9, 0.01);
            this.cameraDestination = null;
        }
        if (this.cameraDestinationAnimX != null) {
            this.cameraX = this.cameraDestinationAnimX.getCurrent();
            if (this.cameraX == this.cameraDestinationAnimX.getDestination()) {
                this.cameraDestinationAnimX = null;
            }
        }
        if (this.cameraDestinationAnimZ != null) {
            this.cameraZ = this.cameraDestinationAnimZ.getCurrent();
            if (this.cameraZ == this.cameraDestinationAnimZ.getDestination()) {
                this.cameraDestinationAnimZ = null;
            }
        }
        this.lastViewedDimensionId = null;
        this.lastViewedMultiworldId = null;
        this.mouseBlockPosY = -1;
        boolean discoveredForHighlights = false;
        Object object2 = this.mapProcessor.renderThreadPauseSync;
        synchronized (object2) {
            if (!this.mapProcessor.isRenderingPaused()) {
                boolean mapLoaded = this.mapProcessor.getCurrentWorldId() != null && !this.mapProcessor.isWaitingForWorldUpdate() && this.mapProcessor.getMapSaveLoad().isRegionDetectionComplete();
                boolean noWorldMapEffect = mc.field_71439_g == null || Misc.hasEffect((EntityPlayer)mc.field_71439_g, Effects.NO_WORLD_MAP) || Misc.hasEffect((EntityPlayer)mc.field_71439_g, Effects.NO_WORLD_MAP_HARMFUL);
                Item mapItem = this.mapProcessor.getMapItem();
                boolean allowedBasedOnItem = mapItem == null || mc.field_71439_g != null && Misc.hasItem((EntityPlayer)mc.field_71439_g, mapItem);
                boolean isLocked = this.mapProcessor.isCurrentMapLocked();
                if (mapLoaded && !noWorldMapEffect && allowedBasedOnItem && !isLocked) {
                    HoveredMapElementHolder<?, ?> hovered;
                    boolean renderingMenus;
                    String subWorldNameToRender;
                    LeveledRegion<?> leveledRegion;
                    double secondaryOffsetY;
                    double secondaryOffsetX;
                    MapRegion leafRegion;
                    if (SupportMods.vivecraft) {
                        GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179086_m((int)16384);
                    }
                    this.mapProcessor.updateCaveStart();
                    this.lastNonNullViewedDimensionId = this.lastViewedDimensionId = Integer.valueOf(this.mapProcessor.getMapWorld().getCurrentDimension().getDimId());
                    this.lastViewedMultiworldId = this.mapProcessor.getMapWorld().getCurrentDimension().getCurrentMultiworld();
                    if (SupportMods.minimap()) {
                        SupportMods.xaeroMinimap.checkWaypoints(this.mapProcessor.getMapWorld().isMultiplayer(), this.lastViewedDimensionId, this.lastViewedMultiworldId, this.field_146294_l, this.field_146295_m, this, this.mapProcessor.getMapWorld());
                    }
                    int mouseXPos = (int)Misc.getMouseX(mc);
                    int mouseYPos = (int)Misc.getMouseY(mc);
                    double scaleMultiplier = this.getScaleMultiplier(Math.min(mc.field_71443_c, mc.field_71440_d));
                    this.scale = this.userScale * scaleMultiplier;
                    if (this.mouseCheckPosX == -1 || System.nanoTime() - this.mouseCheckTimeNano > 30000000L) {
                        this.prevMouseCheckPosX = this.mouseCheckPosX;
                        this.prevMouseCheckPosY = this.mouseCheckPosY;
                        this.prevMouseCheckTimeNano = this.mouseCheckTimeNano;
                        this.mouseCheckPosX = mouseXPos;
                        this.mouseCheckPosY = mouseYPos;
                        this.mouseCheckTimeNano = System.nanoTime();
                    }
                    if (!this.leftMouseButton.isDown) {
                        if (this.mouseDownPosX != -1) {
                            this.mouseDownPosX = -1;
                            this.mouseDownPosY = -1;
                            if (this.prevMouseCheckTimeNano != -1L) {
                                double speed_z;
                                double frameTime60FPS;
                                double downTime = 0.0;
                                int draggedX = 0;
                                int draggedY = 0;
                                draggedX = mouseXPos - this.prevMouseCheckPosX;
                                downTime = System.nanoTime() - this.prevMouseCheckTimeNano;
                                double speedScale = downTime / (frameTime60FPS = 1.6666666666666666E7);
                                double speed_x = (double)(-draggedX) / this.scale / speedScale;
                                double speed = Math.sqrt(speed_x * speed_x + (speed_z = (double)(-(draggedY = mouseYPos - this.prevMouseCheckPosY)) / this.scale / speedScale) * speed_z);
                                if (speed > 0.0) {
                                    double cos = speed_x / speed;
                                    double sin = speed_z / speed;
                                    double maxSpeed = 500.0 / this.userScale;
                                    speed = Math.abs(speed) > maxSpeed ? Math.copySign(maxSpeed, speed) : speed;
                                    double speed_factor = 0.9;
                                    double ln = Math.log(speed_factor);
                                    double move_distance = -speed / ln;
                                    double moveX = cos * move_distance;
                                    double moveZ = sin * move_distance;
                                    this.cameraDestinationAnimX = new SlowingAnimation(this.cameraX, this.cameraX + moveX, 0.9, 0.01);
                                    this.cameraDestinationAnimZ = new SlowingAnimation(this.cameraZ, this.cameraZ + moveZ, 0.9, 0.01);
                                }
                            }
                        }
                    } else if (this.viewed == null || !this.viewedInList || this.mouseDownPosX != -1) {
                        if (this.mouseDownPosX != -1) {
                            this.cameraX = (double)(this.mouseDownPosX - mouseXPos) / this.scale + this.mouseDownCameraX;
                            this.cameraZ = (double)(this.mouseDownPosY - mouseYPos) / this.scale + this.mouseDownCameraZ;
                        } else {
                            this.mouseDownPosX = mouseXPos;
                            this.mouseDownPosY = mouseYPos;
                            this.mouseDownCameraX = this.cameraX;
                            this.mouseDownCameraZ = this.cameraZ;
                            this.cameraDestinationAnimX = null;
                            this.cameraDestinationAnimZ = null;
                        }
                    }
                    int mouseFromCentreX = mouseXPos - mc.field_71443_c / 2;
                    int mouseFromCentreY = mouseYPos - mc.field_71440_d / 2;
                    double oldMousePosX = (double)mouseFromCentreX / this.scale + this.cameraX;
                    double oldMousePosZ = (double)mouseFromCentreY / this.scale + this.cameraZ;
                    double preScale = this.scale;
                    if (destScale != this.userScale) {
                        if (this.zoomAnim != null) {
                            this.userScale = this.zoomAnim.getCurrent();
                            this.scale = this.userScale * scaleMultiplier;
                        }
                        if (this.zoomAnim == null || MathUtils.round((double)this.zoomAnim.getDestination(), (int)4) != MathUtils.round((double)destScale, (int)4)) {
                            this.zoomAnim = new SinAnimation(this.userScale, destScale, 100L);
                        }
                    }
                    if (this.scale > preScale && this.lastZoomMethod != 2) {
                        this.cameraX = oldMousePosX - (double)mouseFromCentreX / this.scale;
                        this.cameraZ = oldMousePosZ - (double)mouseFromCentreY / this.scale;
                    }
                    int textureLevel = 0;
                    double fboScale = this.scale >= 1.0 ? Math.max(1.0, Math.floor(this.scale)) : this.scale;
                    if (this.userScale < 1.0) {
                        double reversedScale = 1.0 / this.userScale;
                        double log2 = Math.floor(Math.log(reversedScale) / Math.log(2.0));
                        textureLevel = Math.min((int)log2, 3);
                    }
                    this.mapProcessor.getMapSaveLoad().mainTextureLevel = textureLevel;
                    int leveledRegionShift = 9 + textureLevel;
                    double secondaryScale = this.scale / fboScale;
                    GlStateManager.func_179094_E();
                    double mousePosX = (double)mouseFromCentreX / this.scale + this.cameraX;
                    double mousePosZ = (double)mouseFromCentreY / this.scale + this.cameraZ;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)971.0f);
                    this.mouseBlockPosX = (int)Math.floor(mousePosX);
                    this.mouseBlockPosZ = (int)Math.floor(mousePosZ);
                    this.mouseBlockDim = this.mapProcessor.getMapWorld().getCurrentDimension().getDimId();
                    this.mouseBlockCoordinateScale = this.getCurrentMapCoordinateScale();
                    if (SupportMods.minimap()) {
                        SupportMods.xaeroMinimap.onBlockHover();
                    }
                    int mouseRegX = this.mouseBlockPosX >> leveledRegionShift;
                    int mouseRegZ = this.mouseBlockPosZ >> leveledRegionShift;
                    int renderedCaveLayer = this.mapProcessor.getCurrentCaveLayer();
                    LeveledRegion<?> reg = this.mapProcessor.getLeveledRegion(renderedCaveLayer, mouseRegX, mouseRegZ, textureLevel);
                    int maxRegBlockCoord = (1 << leveledRegionShift) - 1;
                    int mouseRegPixelX = (this.mouseBlockPosX & maxRegBlockCoord) >> textureLevel;
                    int mouseRegPixelZ = (this.mouseBlockPosZ & maxRegBlockCoord) >> textureLevel;
                    this.mouseBlockPosX = (mouseRegX << leveledRegionShift) + (mouseRegPixelX << textureLevel);
                    this.mouseBlockPosZ = (mouseRegZ << leveledRegionShift) + (mouseRegPixelZ << textureLevel);
                    if (this.mapTileSelection != null && this.rightClickMenu == null) {
                        this.mapTileSelection.setEnd(this.mouseBlockPosX >> 4, this.mouseBlockPosZ >> 4);
                    }
                    MapTileChunk chunk = (leafRegion = this.mapProcessor.getLeafMapRegion(renderedCaveLayer, this.mouseBlockPosX >> 9, this.mouseBlockPosZ >> 9, false)) == null ? null : leafRegion.getChunk(this.mouseBlockPosX >> 6 & 7, this.mouseBlockPosZ >> 6 & 7);
                    int debugTextureX = this.mouseBlockPosX >> leveledRegionShift - 3 & 7;
                    int debugTextureY = this.mouseBlockPosZ >> leveledRegionShift - 3 & 7;
                    RegionTexture tex = reg != null && reg.hasTextures() ? (RegionTexture)reg.getTexture(debugTextureX, debugTextureY) : null;
                    boolean debugConfig = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.DEBUG);
                    if (debugConfig) {
                        if (reg != null) {
                            ArrayList<String> debugLines = new ArrayList<String>();
                            if (tex != null) {
                                MapBlock block;
                                MapTile mouseTile;
                                tex.addDebugLines(debugLines);
                                MapTile mapTile = mouseTile = chunk == null ? null : chunk.getTile(this.mouseBlockPosX >> 4 & 3, this.mouseBlockPosZ >> 4 & 3);
                                if (mouseTile != null && (block = mouseTile.getBlock(this.mouseBlockPosX & 0xF, this.mouseBlockPosZ & 0xF)) != null) {
                                    this.func_73732_a(mc.field_71466_p, block.toString(), this.field_146294_l / 2, 22, -1);
                                    if (block.getNumberOfOverlays() != 0) {
                                        for (int i = 0; i < block.getOverlays().size(); ++i) {
                                            this.func_73732_a(mc.field_71466_p, block.getOverlays().get(i).toString(), this.field_146294_l / 2, 32 + i * 10, -1);
                                        }
                                    }
                                }
                            }
                            debugLines.add("");
                            debugLines.add(reg.toString());
                            reg.addDebugLines(debugLines, this.mapProcessor, debugTextureX, debugTextureY);
                            for (int i = 0; i < debugLines.size(); ++i) {
                                this.func_73731_b(mc.field_71466_p, (String)debugLines.get(i), 5, 15 + 10 * i, -1);
                            }
                        }
                        MapDimensionTypeInfo dimType = this.mapProcessor.getMapWorld().getCurrentDimension().getDimensionType();
                        this.func_73731_b(mc.field_71466_p, "MultiWorld ID: " + this.mapProcessor.getMapWorld().getCurrentMultiworld() + " Dim Type: " + (dimType == null ? "unknown" : dimType.getName()), 5, 265, -1);
                        LayeredRegionManager regions = this.mapProcessor.getMapWorld().getCurrentDimension().getLayeredMapRegions();
                        this.func_73731_b(mc.field_71466_p, String.format("regions: %d loaded: %d processed: %d viewed: %d benchmarks %s", regions.size(), regions.loadedCount(), this.mapProcessor.getProcessedCount(), lastAmountOfRegionsViewed, WorldMap.textureUploadBenchmark.getTotalsString()), 5, 275, -1);
                        this.func_73731_b(mc.field_71466_p, String.format("toLoad: %d toSave: %d tile pool: %d overlays: %d toLoadBranchCache: %d buffers: %d", this.mapProcessor.getMapSaveLoad().getSizeOfToLoad(), this.mapProcessor.getMapSaveLoad().getToSave().size(), this.mapProcessor.getTilePool().size(), this.mapProcessor.getOverlayManager().getNumberOfUniqueOverlays(), this.mapProcessor.getMapSaveLoad().getSizeOfToLoadBranchCache(), WorldMap.textureDirectBufferPool.size()), 5, 285, -1);
                        long i = Runtime.getRuntime().maxMemory();
                        long j = Runtime.getRuntime().totalMemory();
                        long k = Runtime.getRuntime().freeMemory();
                        long l = j - k;
                        this.func_73731_b(mc.field_71466_p, String.format("FPS: %d", Minecraft.func_175610_ah()), 5, 295, -1);
                        this.func_73731_b(mc.field_71466_p, String.format("Mem: % 2d%% %03d/%03dMB", l * 100L / i, GuiMap.bytesToMb(l), GuiMap.bytesToMb(i)), 5, 315, -1);
                        this.func_73731_b(mc.field_71466_p, String.format("Allocated: % 2d%% %03dMB", j * 100L / i, GuiMap.bytesToMb(j)), 5, 325, -1);
                        this.func_73731_b(mc.field_71466_p, String.format("Available VRAM: %dMB", this.mapProcessor.getMapLimiter().getAvailableVRAM() / 1024), 5, 335, -1);
                    }
                    int pixelInsideTexX = mouseRegPixelX & 0x3F;
                    int pixelInsideTexZ = mouseRegPixelZ & 0x3F;
                    boolean hasAmbiguousHeight = false;
                    int mouseBlockBottomY = -1;
                    int mouseBlockTopY = -1;
                    int pointedAtBiome = -1;
                    if (tex != null) {
                        mouseBlockBottomY = this.mouseBlockPosY = tex.getHeight(pixelInsideTexX, pixelInsideTexZ);
                        mouseBlockTopY = tex.getTopHeight(pixelInsideTexX, pixelInsideTexZ);
                        hasAmbiguousHeight = this.mouseBlockPosY != mouseBlockTopY;
                        pointedAtBiome = tex.getBiome(pixelInsideTexX, pixelInsideTexZ);
                    }
                    if (hasAmbiguousHeight) {
                        if (mouseBlockTopY != -1) {
                            this.mouseBlockPosY = mouseBlockTopY;
                        } else if (((Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.DETECT_AMBIGUOUS_Y)).booleanValue()) {
                            this.mouseBlockPosY = -1;
                        }
                    }
                    GlStateManager.func_179121_F();
                    if (primaryScaleFBO == null || GuiMap.primaryScaleFBO.field_147621_c != mc.field_71443_c || GuiMap.primaryScaleFBO.field_147618_d != mc.field_71440_d) {
                        if (!Minecraft.func_71410_x().field_71474_y.field_151448_g) {
                            Minecraft.func_71410_x().field_71474_y.func_74306_a(GameSettings.Options.FBO_ENABLE, 0);
                            WorldMap.LOGGER.info("FBO is off. Turning it on.");
                        }
                        primaryScaleFBO = new ImprovedFramebuffer(mc.field_71443_c, mc.field_71440_d, false);
                    }
                    if (GuiMap.primaryScaleFBO.field_147616_f == -1) {
                        GlStateManager.func_179121_F();
                        return;
                    }
                    primaryScaleFBO.func_147610_a(false);
                    GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179086_m((int)16384);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179152_a((float)(1.0f / (float)this.screenScale), (float)(1.0f / (float)this.screenScale), (float)1.0f);
                    GlStateManager.func_179109_b((float)(mc.field_71443_c / 2), (float)(mc.field_71440_d / 2), (float)0.0f);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179129_p();
                    int flooredCameraX = (int)Math.floor(this.cameraX);
                    int flooredCameraZ = (int)Math.floor(this.cameraZ);
                    double primaryOffsetX = 0.0;
                    double primaryOffsetY = 0.0;
                    if (fboScale < 1.0) {
                        double pixelInBlocks = 1.0 / fboScale;
                        int xInFullPixels = (int)Math.floor(this.cameraX / pixelInBlocks);
                        int zInFullPixels = (int)Math.floor(this.cameraZ / pixelInBlocks);
                        double fboOffsetX = (double)xInFullPixels * pixelInBlocks;
                        double fboOffsetZ = (double)zInFullPixels * pixelInBlocks;
                        flooredCameraX = (int)Math.floor(fboOffsetX);
                        flooredCameraZ = (int)Math.floor(fboOffsetZ);
                        primaryOffsetX = fboOffsetX - (double)flooredCameraX;
                        primaryOffsetY = fboOffsetZ - (double)flooredCameraZ;
                        secondaryOffsetX = (this.cameraX - fboOffsetX) * fboScale;
                        secondaryOffsetY = (this.cameraZ - fboOffsetZ) * fboScale;
                    } else {
                        int offset;
                        secondaryOffsetX = (this.cameraX - (double)flooredCameraX) * fboScale;
                        secondaryOffsetY = (this.cameraZ - (double)flooredCameraZ) * fboScale;
                        if (secondaryOffsetX >= 1.0) {
                            offset = (int)secondaryOffsetX;
                            GlStateManager.func_179109_b((float)(-offset), (float)0.0f, (float)0.0f);
                            secondaryOffsetX -= (double)offset;
                        }
                        if (secondaryOffsetY >= 1.0) {
                            offset = (int)secondaryOffsetY;
                            GlStateManager.func_179109_b((float)0.0f, (float)offset, (float)0.0f);
                            secondaryOffsetY -= (double)offset;
                        }
                    }
                    GlStateManager.func_179139_a((double)fboScale, (double)(-fboScale), (double)1.0);
                    GlStateManager.func_179137_b((double)(-primaryOffsetX), (double)(-primaryOffsetY), (double)0.0);
                    GlStateManager.func_179098_w();
                    double leftBorder = this.cameraX - (double)(mc.field_71443_c / 2) / this.scale;
                    double rightBorder = leftBorder + (double)mc.field_71443_c / this.scale;
                    double topBorder = this.cameraZ - (double)(mc.field_71440_d / 2) / this.scale;
                    double bottomBorder = topBorder + (double)mc.field_71440_d / this.scale;
                    int minRegX = (int)Math.floor(leftBorder) >> leveledRegionShift;
                    int maxRegX = (int)Math.floor(rightBorder) >> leveledRegionShift;
                    int minRegZ = (int)Math.floor(topBorder) >> leveledRegionShift;
                    int maxRegZ = (int)Math.floor(bottomBorder) >> leveledRegionShift;
                    int blockToTextureConversion = 6 + textureLevel;
                    int minTextureX = (int)Math.floor(leftBorder) >> blockToTextureConversion;
                    int maxTextureX = (int)Math.floor(rightBorder) >> blockToTextureConversion;
                    int minTextureZ = (int)Math.floor(topBorder) >> blockToTextureConversion;
                    int maxTextureZ = (int)Math.floor(bottomBorder) >> blockToTextureConversion;
                    int minLeafRegX = minTextureX << blockToTextureConversion >> 9;
                    int maxLeafRegX = (maxTextureX + 1 << blockToTextureConversion) - 1 >> 9;
                    int minLeafRegZ = minTextureZ << blockToTextureConversion >> 9;
                    int maxLeafRegZ = (maxTextureZ + 1 << blockToTextureConversion) - 1 >> 9;
                    lastAmountOfRegionsViewed = (maxRegX - minRegX + 1) * (maxRegZ - minRegZ + 1);
                    if (this.mapProcessor.getMapLimiter().getMostRegionsAtATime() < lastAmountOfRegionsViewed) {
                        this.mapProcessor.getMapLimiter().setMostRegionsAtATime(lastAmountOfRegionsViewed);
                    }
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179118_c();
                    this.regionBuffer.clear();
                    this.branchRegionBuffer.clear();
                    float brightness = this.mapProcessor.getBrightness();
                    int globalRegionCacheHashCode = WorldMap.settings.getRegionCacheHashCode();
                    int globalCaveStart = this.mapProcessor.getMapWorld().getCurrentDimension().getLayeredMapRegions().getLayer(renderedCaveLayer).getCaveStart();
                    int globalCaveDepth = (Integer)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.CAVE_MODE_DEPTH);
                    boolean reloadEverything = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.RELOAD_VIEWED);
                    int globalReloadVersion = (Integer)primaryConfigManager.getEffective(WorldMapPrimaryClientConfigOptions.RELOAD_VIEWED_VERSION);
                    boolean oldMinimapMessesUpTextureFilter = SupportMods.minimap() && SupportMods.xaeroMinimap.compatibilityVersion < 11;
                    int globalVersion = (Integer)primaryConfigManager.getEffective(WorldMapPrimaryClientConfigOptions.GLOBAL_VERSION);
                    boolean prevWaitingForBranchCache = this.prevWaitingForBranchCache;
                    this.waitingForBranchCache[0] = false;
                    GuiMap.setupTextureMatricesAndTextures(brightness);
                    LeveledRegion.setComparison(this.mouseBlockPosX >> leveledRegionShift, this.mouseBlockPosZ >> leveledRegionShift, textureLevel, this.mouseBlockPosX >> 9, this.mouseBlockPosZ >> 9);
                    LeveledRegion<?> lastUpdatedRootLeveledRegion = null;
                    boolean cacheOnlyMode = this.mapProcessor.getMapWorld().isCacheOnlyMode();
                    boolean frameRenderedRootTextures = false;
                    boolean loadingLeaves = false;
                    for (int leveledRegX = minRegX; leveledRegX <= maxRegX; ++leveledRegX) {
                        for (int leveledRegZ = minRegZ; leveledRegZ <= maxRegZ; ++leveledRegZ) {
                            boolean rootHasTextures;
                            int leveledSideInRegions = 1 << textureLevel;
                            int leveledSideInBlocks = leveledSideInRegions * 512;
                            int leafRegionMinX = leveledRegX * leveledSideInRegions;
                            int leafRegionMinZ = leveledRegZ * leveledSideInRegions;
                            leveledRegion = null;
                            for (int leafX = 0; leafX < leveledSideInRegions; ++leafX) {
                                for (int leafZ = 0; leafZ < leveledSideInRegions; ++leafZ) {
                                    int regZ;
                                    int regX = leafRegionMinX + leafX;
                                    if (regX < minLeafRegX || regX > maxLeafRegX || (regZ = leafRegionMinZ + leafZ) < minLeafRegZ || regZ > maxLeafRegZ) continue;
                                    MapRegion region = this.mapProcessor.getLeafMapRegion(renderedCaveLayer, regX, regZ, false);
                                    if (region == null) {
                                        region = this.mapProcessor.getLeafMapRegion(renderedCaveLayer, regX, regZ, this.mapProcessor.regionExists(renderedCaveLayer, regX, regZ));
                                    }
                                    if (region == null) continue;
                                    if (leveledRegion == null) {
                                        leveledRegion = this.mapProcessor.getLeveledRegion(renderedCaveLayer, leveledRegX, leveledRegZ, textureLevel);
                                    }
                                    if (prevWaitingForBranchCache) continue;
                                    MapRegion mapRegion = region;
                                    synchronized (mapRegion) {
                                        if (textureLevel != 0 && region.getLoadState() == 0 && region.loadingNeededForBranchLevel != 0 && region.loadingNeededForBranchLevel != textureLevel) {
                                            region.loadingNeededForBranchLevel = 0;
                                            region.getParent().setShouldCheckForUpdatesRecursive(true);
                                        }
                                        if (region.canRequestReload_unsynced() && (!cacheOnlyMode && (reloadEverything && region.getReloadVersion() != globalReloadVersion || region.getCacheHashCode() != globalRegionCacheHashCode || region.caveStartOutdated(globalCaveStart, globalCaveDepth) || region.getVersion() != globalVersion || region.getLoadState() != 2 && region.shouldCache()) || region.getLoadState() == 0 && (!region.isMetaLoaded() || textureLevel == 0 || region.loadingNeededForBranchLevel == textureLevel) || (region.isMetaLoaded() || region.getLoadState() != 0 || !region.hasHadTerrain()) && region.getHighlightsHash() != region.getDim().getHighlightHandler().getRegionHash(region.getRegionX(), region.getRegionZ()))) {
                                            loadingLeaves = true;
                                            region.calculateSortingDistance();
                                            Misc.addToListOfSmallest(10, this.regionBuffer, region);
                                        }
                                        continue;
                                    }
                                }
                            }
                            if (leveledRegion == null) continue;
                            LeveledRegion<?> rootLeveledRegion = leveledRegion.getRootRegion();
                            if (rootLeveledRegion == leveledRegion) {
                                rootLeveledRegion = null;
                            }
                            if (rootLeveledRegion != null && !rootLeveledRegion.isLoaded()) {
                                if (!rootLeveledRegion.recacheHasBeenRequested() && !rootLeveledRegion.reloadHasBeenRequested()) {
                                    rootLeveledRegion.calculateSortingDistance();
                                    Misc.addToListOfSmallest(10, this.branchRegionBuffer, (BranchLeveledRegion)rootLeveledRegion);
                                }
                                this.waitingForBranchCache[0] = true;
                                rootLeveledRegion = null;
                            }
                            if (!this.mapProcessor.isUploadingPaused() && !WorldMap.pauseRequests) {
                                if (leveledRegion instanceof BranchLeveledRegion) {
                                    BranchLeveledRegion branchRegion = (BranchLeveledRegion)leveledRegion;
                                    branchRegion.checkForUpdates(this.mapProcessor, prevWaitingForBranchCache, this.waitingForBranchCache, this.branchRegionBuffer, textureLevel, minLeafRegX, minLeafRegZ, maxLeafRegX, maxLeafRegZ);
                                }
                                if ((textureLevel != 0 && !prevWaitingForBranchCache || textureLevel == 0 && !this.prevLoadingLeaves) && this.lastFrameRenderedRootTextures && rootLeveledRegion != null && rootLeveledRegion != lastUpdatedRootLeveledRegion) {
                                    BranchLeveledRegion branchRegion = (BranchLeveledRegion)rootLeveledRegion;
                                    branchRegion.checkForUpdates(this.mapProcessor, prevWaitingForBranchCache, this.waitingForBranchCache, this.branchRegionBuffer, textureLevel, minLeafRegX, minLeafRegZ, maxLeafRegX, maxLeafRegZ);
                                    lastUpdatedRootLeveledRegion = rootLeveledRegion;
                                }
                                this.mapProcessor.getMapWorld().getCurrentDimension().getLayeredMapRegions().bumpLoadedRegion(leveledRegion);
                                if (rootLeveledRegion != null) {
                                    this.mapProcessor.getMapWorld().getCurrentDimension().getLayeredMapRegions().bumpLoadedRegion(rootLeveledRegion);
                                }
                            } else {
                                this.waitingForBranchCache[0] = prevWaitingForBranchCache;
                            }
                            int minXBlocks = leveledRegX * leveledSideInBlocks;
                            int minZBlocks = leveledRegZ * leveledSideInBlocks;
                            int textureSize = 64 * leveledSideInRegions;
                            int firstTextureX = leveledRegX << 3;
                            int firstTextureZ = leveledRegZ << 3;
                            int levelDiff = 3 - textureLevel;
                            int rootSize = 1 << levelDiff;
                            int maxInsideCoord = rootSize - 1;
                            int firstRootTextureX = firstTextureX >> levelDiff & 7;
                            int firstRootTextureZ = firstTextureZ >> levelDiff & 7;
                            int firstInsideTextureX = firstTextureX & maxInsideCoord;
                            int firstInsideTextureZ = firstTextureZ & maxInsideCoord;
                            boolean hasTextures = leveledRegion.hasTextures();
                            boolean bl = rootHasTextures = rootLeveledRegion != null && rootLeveledRegion.hasTextures();
                            if (hasTextures || rootHasTextures) {
                                for (int o = 0; o < 8; ++o) {
                                    int textureX = minXBlocks + o * textureSize;
                                    if ((double)textureX > rightBorder || (double)(textureX + textureSize) < leftBorder) continue;
                                    for (int p = 0; p < 8; ++p) {
                                        RegionTexture<Object> regionTexture;
                                        int textureZ = minZBlocks + p * textureSize;
                                        if ((double)textureZ > bottomBorder || (double)(textureZ + textureSize) < topBorder) continue;
                                        RegionTexture regionTexture2 = regionTexture = hasTextures ? (RegionTexture)leveledRegion.getTexture(o, p) : null;
                                        if (regionTexture == null || regionTexture.getGlColorTexture() == -1) {
                                            int insideZ;
                                            int rootTextureZ;
                                            int insideX;
                                            int rootTextureX;
                                            if (!rootHasTextures || (regionTexture = rootLeveledRegion.getTexture(rootTextureX = firstRootTextureX + ((insideX = firstInsideTextureX + o) >> levelDiff), rootTextureZ = firstRootTextureZ + ((insideZ = firstInsideTextureZ + p) >> levelDiff))) == null) continue;
                                            RegionTexture<Object> regionTexture3 = regionTexture;
                                            synchronized (regionTexture3) {
                                                if (regionTexture.getGlColorTexture() == -1) {
                                                    continue;
                                                }
                                                frameRenderedRootTextures = true;
                                                int insideTextureX = insideX & maxInsideCoord;
                                                int insideTextureZ = insideZ & maxInsideCoord;
                                                float textureX1 = (float)insideTextureX / (float)rootSize;
                                                float textureX2 = (float)(insideTextureX + 1) / (float)rootSize;
                                                float textureY1 = (float)insideTextureZ / (float)rootSize;
                                                float textureY2 = (float)(insideTextureZ + 1) / (float)rootSize;
                                                boolean hasLight = regionTexture.getTextureHasLight();
                                                GuiMap.bindMapTextureWithLighting3(regionTexture, 9728, oldMinimapMessesUpTextureFilter, 0, hasLight);
                                                GuiMap.renderTexturedModalSubRectWithLighting(textureX - flooredCameraX, textureZ - flooredCameraZ, textureX1, textureY1, textureX2, textureY2, textureSize, textureSize, hasLight);
                                                continue;
                                            }
                                        }
                                        RegionTexture insideX = regionTexture;
                                        synchronized (insideX) {
                                            if (regionTexture.getGlColorTexture() == -1) {
                                                continue;
                                            }
                                            boolean hasLight = regionTexture.getTextureHasLight();
                                            GuiMap.bindMapTextureWithLighting3(regionTexture, 9728, oldMinimapMessesUpTextureFilter, 0, hasLight);
                                            GuiMap.renderTexturedModalRectWithLighting2(textureX - flooredCameraX, textureZ - flooredCameraZ, textureSize, textureSize, hasLight);
                                            continue;
                                        }
                                    }
                                }
                            }
                            if (leveledRegion.loadingAnimation()) {
                                GlStateManager.func_179094_E();
                                GlStateManager.func_179137_b((double)((double)leveledSideInBlocks * ((double)leveledRegX + 0.5) - (double)flooredCameraX), (double)((double)leveledSideInBlocks * ((double)leveledRegZ + 0.5) - (double)flooredCameraZ), (double)0.0);
                                float loadingAnimationPassed = System.currentTimeMillis() - this.loadingAnimationStart;
                                if (loadingAnimationPassed > 0.0f) {
                                    GuiMap.restoreTextureStates();
                                    int period = 2000;
                                    int numbersOfActors = 3;
                                    float loadingAnimation = loadingAnimationPassed % (float)period / (float)period * 360.0f;
                                    float step = 360.0f / (float)numbersOfActors;
                                    GlStateManager.func_179114_b((float)loadingAnimation, (float)0.0f, (float)0.0f, (float)1.0f);
                                    int numberOfVisibleActors = 1 + (int)loadingAnimationPassed % (3 * period) / period;
                                    GlStateManager.func_179152_a((float)leveledSideInRegions, (float)leveledSideInRegions, (float)1.0f);
                                    for (int i = 0; i < numberOfVisibleActors; ++i) {
                                        GlStateManager.func_179114_b((float)step, (float)0.0f, (float)0.0f, (float)1.0f);
                                        GuiMap.func_73734_a((int)16, (int)-8, (int)32, (int)8, (int)-1);
                                    }
                                    GlStateManager.func_179084_k();
                                    GuiMap.setupTextureMatricesAndTextures(brightness);
                                }
                                GlStateManager.func_179121_F();
                            }
                            if (debugConfig && leveledRegion instanceof MapRegion) {
                                MapRegion region = (MapRegion)leveledRegion;
                                GuiMap.restoreTextureStates();
                                GlStateManager.func_179094_E();
                                GlStateManager.func_179109_b((float)(512 * region.getRegionX() + 32 - flooredCameraX), (float)(512 * region.getRegionZ() + 32 - flooredCameraZ), (float)0.0f);
                                GlStateManager.func_179152_a((float)10.0f, (float)10.0f, (float)1.0f);
                                this.func_73731_b(mc.field_71466_p, "" + region.getLoadState(), 0, 0, -1);
                                GlStateManager.func_179121_F();
                                GlStateManager.func_179084_k();
                                GuiMap.setupTextureMatricesAndTextures(brightness);
                            }
                            if (!debugConfig || textureLevel <= 0) continue;
                            GuiMap.restoreTextureStates();
                            for (int leafX = 0; leafX < leveledSideInRegions; ++leafX) {
                                for (int leafZ = 0; leafZ < leveledSideInRegions; ++leafZ) {
                                    boolean currentlyLoading;
                                    int regX = leafRegionMinX + leafX;
                                    int regZ = leafRegionMinZ + leafZ;
                                    MapRegion region = this.mapProcessor.getLeafMapRegion(renderedCaveLayer, regX, regZ, false);
                                    if (region == null) continue;
                                    boolean bl2 = currentlyLoading = this.mapProcessor.getMapSaveLoad().getNextToLoadByViewing() == region;
                                    if (!currentlyLoading && !region.isLoaded() && !region.isMetaLoaded()) continue;
                                    GlStateManager.func_179094_E();
                                    GlStateManager.func_179109_b((float)(512 * region.getRegionX() - flooredCameraX), (float)(512 * region.getRegionZ() - flooredCameraZ), (float)0.0f);
                                    GuiMap.func_73734_a((int)0, (int)0, (int)512, (int)512, (int)(currentlyLoading ? 687800575 : (region.isLoaded() ? 671153920 : 687865600)));
                                    GlStateManager.func_179121_F();
                                }
                            }
                            GlStateManager.func_179084_k();
                            GuiMap.setupTextureMatricesAndTextures(brightness);
                        }
                    }
                    this.lastFrameRenderedRootTextures = frameRenderedRootTextures;
                    GuiMap.restoreTextureStates();
                    LeveledRegion<?> nextToLoad = this.mapProcessor.getMapSaveLoad().getNextToLoadByViewing();
                    boolean shouldRequest = false;
                    shouldRequest = nextToLoad != null ? nextToLoad.shouldAllowAnotherRegionToLoad() : true;
                    boolean bl = shouldRequest = shouldRequest && this.mapProcessor.getAffectingLoadingFrequencyCount() < 16;
                    if (shouldRequest && !WorldMap.pauseRequests) {
                        int i;
                        int toRequest = 2;
                        int counter = 0;
                        for (i = 0; i < this.branchRegionBuffer.size() && counter < toRequest; ++i) {
                            BranchLeveledRegion region = this.branchRegionBuffer.get(i);
                            if (region.reloadHasBeenRequested() || region.recacheHasBeenRequested() || region.isLoaded()) continue;
                            region.setReloadHasBeenRequested(true, "Gui");
                            this.mapProcessor.getMapSaveLoad().requestBranchCache(region, "Gui");
                            if (counter == 0) {
                                this.mapProcessor.getMapSaveLoad().setNextToLoadByViewing(region);
                            }
                            ++counter;
                        }
                        toRequest = 1;
                        counter = 0;
                        if (!prevWaitingForBranchCache) {
                            for (i = 0; i < this.regionBuffer.size() && counter < toRequest; ++i) {
                                MapRegion region = this.regionBuffer.get(i);
                                if (region == nextToLoad && this.regionBuffer.size() > 1) continue;
                                leveledRegion = region;
                                synchronized (leveledRegion) {
                                    if (!region.canRequestReload_unsynced()) {
                                        continue;
                                    }
                                    if (region.getLoadState() == 2) {
                                        region.requestRefresh(this.mapProcessor);
                                    } else {
                                        this.mapProcessor.getMapSaveLoad().requestLoad(region, "Gui");
                                    }
                                    if (counter == 0) {
                                        this.mapProcessor.getMapSaveLoad().setNextToLoadByViewing((LeveledRegion<?>)region);
                                    }
                                    ++counter;
                                    if (region.getLoadState() == 4) {
                                        break;
                                    }
                                    continue;
                                }
                            }
                        }
                    }
                    this.prevWaitingForBranchCache = this.waitingForBranchCache[0];
                    this.prevLoadingLeaves = loadingLeaves;
                    int chunkHighlightLeftX = this.mouseBlockPosX >> 4 << 4;
                    int chunkHighlightRightX = (this.mouseBlockPosX >> 4) + 1 << 4;
                    int chunkHighlightTopZ = this.mouseBlockPosZ >> 4 << 4;
                    int chunkHighlightBottomZ = (this.mouseBlockPosZ >> 4) + 1 << 4;
                    MapRenderHelper.renderDynamicHighlight(flooredCameraX, flooredCameraZ, chunkHighlightLeftX, chunkHighlightRightX, chunkHighlightTopZ, chunkHighlightBottomZ, 0.0f, 0.0f, 0.0f, 0.2f, 1.0f, 1.0f, 1.0f, 0.1569f);
                    MapTileSelection mapTileSelectionToRender = this.mapTileSelection;
                    if (mapTileSelectionToRender == null && mc.field_71462_r instanceof ExportScreen) {
                        mapTileSelectionToRender = ((ExportScreen)mc.field_71462_r).getSelection();
                    }
                    if (mapTileSelectionToRender != null) {
                        MapRenderHelper.renderDynamicHighlight(flooredCameraX, flooredCameraZ, mapTileSelectionToRender.getLeft() << 4, mapTileSelectionToRender.getRight() + 1 << 4, mapTileSelectionToRender.getTop() << 4, mapTileSelectionToRender.getBottom() + 1 << 4, 0.0f, 0.0f, 0.0f, 0.2f, 1.0f, 0.5f, 0.5f, 0.4f);
                    }
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179118_c();
                    primaryScaleFBO.func_147609_e();
                    Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
                    GlStateManager.func_179089_o();
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179139_a((double)secondaryScale, (double)secondaryScale, (double)1.0);
                    primaryScaleFBO.func_147612_c();
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                    GlStateManager.func_179132_a((boolean)false);
                    int lineX = -mc.field_71443_c / 2;
                    int lineY = mc.field_71440_d / 2 - 5;
                    int lineW = mc.field_71443_c;
                    int lineH = 6;
                    GuiMap.func_73734_a((int)lineX, (int)lineY, (int)(lineX + lineW), (int)(lineY + lineH), (int)-16777216);
                    lineX = mc.field_71443_c / 2 - 5;
                    lineY = -mc.field_71440_d / 2;
                    lineW = 6;
                    lineH = mc.field_71440_d;
                    GuiMap.func_73734_a((int)lineX, (int)lineY, (int)(lineX + lineW), (int)(lineY + lineH), (int)-16777216);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179126_j();
                    if (SupportMods.vivecraft) {
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179120_a((int)1, (int)0, (int)0, (int)1);
                    }
                    GuiMap.renderTexturedModalRect((float)(-mc.field_71443_c / 2) - (float)secondaryOffsetX, (float)(-mc.field_71440_d / 2) - (float)secondaryOffsetY, mc.field_71443_c, mc.field_71440_d);
                    GlStateManager.func_179132_a((boolean)true);
                    if (SupportMods.vivecraft) {
                        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                    }
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179139_a((double)this.scale, (double)this.scale, (double)1.0);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179141_d();
                    double screenSizeBasedScale = scaleMultiplier;
                    GlStateManager.func_179129_p();
                    WorldMap.trackedPlayerRenderer.update(mc);
                    try {
                        this.viewed = WorldMap.mapElementRenderHandler.render(this, this.cameraX, this.cameraZ, mc.field_71443_c, mc.field_71440_d, screenSizeBasedScale, this.scale, playerDimDiv, mousePosX, mousePosZ, brightness, renderedCaveLayer != Integer.MAX_VALUE, this.viewed, mc, partialTicks, this.scaledresolution);
                    }
                    catch (Throwable t) {
                        WorldMap.LOGGER.error("error rendering map elements", t);
                        throw t;
                    }
                    this.viewedInList = false;
                    GlStateManager.func_179089_o();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)970.0f);
                    if (((Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.FOOTSTEPS)).booleanValue()) {
                        ArrayList<Double[]> footprints;
                        ArrayList<Double[]> rootSize = footprints = this.mapProcessor.getFootprints();
                        synchronized (rootSize) {
                            for (int i = 0; i < footprints.size(); ++i) {
                                Double[] coords = footprints.get(i);
                                this.setColourBuffer(1.0f, 0.1f, 0.1f, 1.0f);
                                this.drawDotOnMap(coords[0] / playerDimDiv - this.cameraX, coords[1] / playerDimDiv - this.cameraZ, 0.0f, 1.0 / this.scale);
                            }
                        }
                    }
                    if (((Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.ARROW)).booleanValue()) {
                        boolean toTheLeft = scaledPlayerX < leftBorder;
                        boolean toTheRight = scaledPlayerX > rightBorder;
                        boolean down = scaledPlayerZ > bottomBorder;
                        boolean up = scaledPlayerZ < topBorder;
                        GlStateManager.func_179147_l();
                        float configuredR = 1.0f;
                        float configuredG = 1.0f;
                        float configuredB = 1.0f;
                        int effectiveArrowColorIndex = (Integer)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.ARROW_COLOR);
                        if (effectiveArrowColorIndex == -2 && !SupportMods.minimap()) {
                            effectiveArrowColorIndex = 0;
                        }
                        if (effectiveArrowColorIndex == -2 && SupportMods.xaeroMinimap.getArrowColorIndex() == -1) {
                            effectiveArrowColorIndex = -1;
                        }
                        if (effectiveArrowColorIndex == -1) {
                            int rgb = Misc.getTeamColour((Entity)(mc.field_71439_g == null ? mc.func_175606_aa() : mc.field_71439_g));
                            if (rgb == -1) {
                                effectiveArrowColorIndex = 0;
                            } else {
                                configuredR = (float)(rgb >> 16 & 0xFF) / 255.0f;
                                configuredG = (float)(rgb >> 8 & 0xFF) / 255.0f;
                                configuredB = (float)(rgb & 0xFF) / 255.0f;
                            }
                        } else if (effectiveArrowColorIndex == -2) {
                            float[] c = SupportMods.xaeroMinimap.getArrowColor();
                            if (c == null) {
                                effectiveArrowColorIndex = 0;
                            } else {
                                configuredR = c[0];
                                configuredG = c[1];
                                configuredB = c[2];
                            }
                        }
                        if (effectiveArrowColorIndex >= 0) {
                            float[] c = WorldMapConfigConstants.ARROW_COLORS[effectiveArrowColorIndex];
                            configuredR = c[0];
                            configuredG = c[1];
                            configuredB = c[2];
                        }
                        if (toTheLeft || toTheRight || up || down) {
                            double arrowX = scaledPlayerX;
                            double arrowZ = scaledPlayerZ;
                            float a = 0.0f;
                            if (toTheLeft) {
                                a = up ? 1.5f : (down ? 0.5f : 1.0f);
                                arrowX = leftBorder;
                            } else if (toTheRight) {
                                a = up ? 2.5f : (down ? 3.5f : 3.0f);
                                arrowX = rightBorder;
                            }
                            if (down) {
                                arrowZ = bottomBorder;
                            } else if (up) {
                                if (a == 0.0f) {
                                    a = 2.0f;
                                }
                                arrowZ = topBorder;
                            }
                            this.setColourBuffer(0.0f, 0.0f, 0.0f, 0.9f);
                            this.drawFarArrowOnMap(arrowX - this.cameraX, arrowZ + 2.0 * screenSizeBasedScale / this.scale - this.cameraZ, a, screenSizeBasedScale / this.scale);
                            this.setColourBuffer(configuredR, configuredG, configuredB, 1.0f);
                            this.drawFarArrowOnMap(arrowX - this.cameraX, arrowZ - this.cameraZ, a, screenSizeBasedScale / this.scale);
                        } else {
                            this.setColourBuffer(0.0f, 0.0f, 0.0f, 0.9f);
                            this.drawArrowOnMap(scaledPlayerX - this.cameraX, scaledPlayerZ + 2.0 * screenSizeBasedScale / this.scale - this.cameraZ, this.player.field_70177_z, screenSizeBasedScale / this.scale);
                            this.setColourBuffer(configuredR, configuredG, configuredB, 1.0f);
                            this.drawArrowOnMap(scaledPlayerX - this.cameraX, scaledPlayerZ - this.cameraZ, this.player.field_70177_z, screenSizeBasedScale / this.scale);
                        }
                    }
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179121_F();
                    int cursorDisplayOffset = 0;
                    if (((Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.COORDINATES)).booleanValue()) {
                        String coordsString = "X: " + this.mouseBlockPosX;
                        if (mouseBlockBottomY != -1) {
                            coordsString = coordsString + " Y: " + mouseBlockBottomY;
                        }
                        if (hasAmbiguousHeight && mouseBlockTopY != -1) {
                            coordsString = coordsString + " (" + mouseBlockTopY + ")";
                        }
                        coordsString = coordsString + " Z: " + this.mouseBlockPosZ;
                        MapRenderHelper.drawCenteredStringWithBackground(this.field_146289_q, coordsString, this.field_146294_l / 2, 2 + cursorDisplayOffset, -1, 0.0f, 0.0f, 0.0f, 0.4f);
                        cursorDisplayOffset += 10;
                    }
                    if (((Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.DISPLAY_HOVERED_BIOME)).booleanValue() && pointedAtBiome != -1) {
                        Biome biome = Biome.func_150568_d((int)pointedAtBiome);
                        String biomeText = biome == null ? I18n.func_135052_a((String)"gui.xaero_wm_unknown_biome", (Object[])new Object[0]) : biome.func_185359_l();
                        MapRenderHelper.drawCenteredStringWithBackground(this.field_146289_q, biomeText, this.field_146294_l / 2, 2 + cursorDisplayOffset, -1, 0.0f, 0.0f, 0.0f, 0.4f);
                    }
                    int subtleTooltipOffset = 12;
                    if (((Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.DISPLAY_ZOOM)).booleanValue()) {
                        String zoomString = (double)Math.round(destScale * 1000.0) / 1000.0 + "x";
                        MapRenderHelper.drawCenteredStringWithBackground(mc.field_71466_p, zoomString, this.field_146294_l / 2, this.field_146295_m - subtleTooltipOffset, -1, 0.0f, 0.0f, 0.0f, 0.4f);
                    }
                    if (this.mapProcessor.getMapWorld().getCurrentDimension().getFullReloader() != null) {
                        MapRenderHelper.drawCenteredStringWithBackground(mc.field_71466_p, FULL_RELOAD_IN_PROGRESS, this.field_146294_l / 2, this.field_146295_m - (subtleTooltipOffset += 12), -1, 0.0f, 0.0f, 0.0f, 0.4f);
                    }
                    if (this.mapProcessor.getMapWorld().isUsingUnknownDimensionType()) {
                        MapRenderHelper.drawCenteredStringWithBackground(mc.field_71466_p, UNKNOWN_DIMENSION_TYPE2, this.field_146294_l / 2, this.field_146295_m - (subtleTooltipOffset += 24), -1, 0.0f, 0.0f, 0.0f, 0.4f);
                        MapRenderHelper.drawCenteredStringWithBackground(mc.field_71466_p, UNKNOWN_DIMENSION_TYPE1, this.field_146294_l / 2, this.field_146295_m - (subtleTooltipOffset += 12), -1, 0.0f, 0.0f, 0.0f, 0.4f);
                    }
                    if (((Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.DISPLAY_CAVE_MODE_START)).booleanValue()) {
                        subtleTooltipOffset += 12;
                        if (globalCaveStart != Integer.MAX_VALUE && globalCaveStart != Integer.MIN_VALUE) {
                            String caveModeStartString = I18n.func_135052_a((String)"gui.xaero_wm_cave_mode_start_display", (Object[])new Object[]{globalCaveStart});
                            MapRenderHelper.drawCenteredStringWithBackground(mc.field_71466_p, caveModeStartString, this.field_146294_l / 2, this.field_146295_m - subtleTooltipOffset, -1, 0.0f, 0.0f, 0.0f, 0.4f);
                        }
                    }
                    if (SupportMods.minimap() && (subWorldNameToRender = SupportMods.xaeroMinimap.getSubWorldNameToRender()) != null) {
                        MapRenderHelper.drawCenteredStringWithBackground(mc.field_71466_p, subWorldNameToRender, this.field_146294_l / 2, this.field_146295_m - (subtleTooltipOffset += 24), -1, 0.0f, 0.0f, 0.0f, 0.4f);
                    }
                    discoveredForHighlights = mouseBlockBottomY != -1;
                    ITextComponent subtleHighlightTooltip = this.mapProcessor.getMapWorld().getCurrentDimension().getHighlightHandler().getBlockHighlightSubtleTooltip(this.mouseBlockPosX, this.mouseBlockPosZ, discoveredForHighlights);
                    if (subtleHighlightTooltip != null) {
                        MapRenderHelper.drawCenteredStringWithBackground(mc.field_71466_p, subtleHighlightTooltip, this.field_146294_l / 2, this.field_146295_m - (subtleTooltipOffset += 12), -1, 0.0f, 0.0f, 0.0f, 0.4f);
                    }
                    this.overWaypointsMenu = false;
                    this.overPlayersMenu = false;
                    boolean bl3 = renderingMenus = this.waypointMenu || this.playersMenu;
                    if (renderingMenus) {
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)972.0f);
                    }
                    if (this.waypointMenu) {
                        HoveredMapElementHolder<?, ?> hovered2;
                        if (SupportMods.xaeroMinimap.getWaypointsSorted() != null && (hovered2 = SupportMods.xaeroMinimap.renderWaypointsMenu(this, this.scale, this.field_146294_l, this.field_146295_m, scaledMouseX, scaledMouseY, this.leftMouseButton.isDown, this.leftMouseButton.clicked, this.viewed, mc)) != null) {
                            this.overWaypointsMenu = true;
                            if (hovered2.getElement() instanceof Waypoint) {
                                this.viewed = hovered2;
                                this.viewedInList = true;
                                if (this.leftMouseButton.clicked) {
                                    this.cameraDestination = new int[]{(int)((Waypoint)this.viewed.getElement()).getRenderX(), (int)((Waypoint)this.viewed.getElement()).getRenderZ()};
                                    this.leftMouseButton.isDown = false;
                                    boolean closeWaypointsWhenHopping = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.CLOSE_WAYPOINTS_AFTER_HOP);
                                    if (closeWaypointsWhenHopping) {
                                        this.onWaypointsButton(this.waypointsButton);
                                    }
                                }
                            }
                        }
                    } else if (this.playersMenu && (hovered = WorldMap.trackedPlayerMenuRenderer.renderMenu(this, this.scale, this.field_146294_l, this.field_146295_m, scaledMouseX, scaledMouseY, this.leftMouseButton.isDown, this.leftMouseButton.clicked, this.viewed, mc)) != null) {
                        this.overPlayersMenu = true;
                        if (hovered.getElement() instanceof PlayerTrackerMapElement && WorldMap.trackedPlayerMenuRenderer.canJumpTo((PlayerTrackerMapElement)hovered.getElement())) {
                            this.viewed = hovered;
                            this.viewedInList = true;
                            if (this.leftMouseButton.clicked) {
                                PlayerTrackerMapElement clickedPlayer = (PlayerTrackerMapElement)this.viewed.getElement();
                                MapDimension clickedPlayerDim = this.mapProcessor.getMapWorld().getDimension(clickedPlayer.getDimension());
                                MapDimensionTypeInfo clickedPlayerDimType = MapDimension.getDimensionType(clickedPlayerDim, clickedPlayer.getDimension());
                                double clickedPlayerDimDiv = this.mapProcessor.getMapWorld().getCurrentDimension().calculateDimDiv(clickedPlayerDimType);
                                double jumpX = clickedPlayer.getX() / clickedPlayerDimDiv;
                                double jumpZ = clickedPlayer.getZ() / clickedPlayerDimDiv;
                                this.cameraDestination = new int[]{(int)jumpX, (int)jumpZ};
                                this.leftMouseButton.isDown = false;
                            }
                        }
                    }
                    if (renderingMenus) {
                        GlStateManager.func_179121_F();
                    }
                    if (SupportMods.minimap()) {
                        SupportMods.xaeroMinimap.drawSetChange(this.scaledresolution);
                    }
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else if (!mapLoaded) {
                    this.renderLoadingScreen();
                } else if (isLocked) {
                    this.renderMessageScreen(I18n.func_135052_a((String)"gui.xaero_current_map_locked1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_current_map_locked2", (Object[])new Object[0]));
                } else if (noWorldMapEffect) {
                    this.renderMessageScreen(I18n.func_135052_a((String)"gui.xaero_no_world_map_message", (Object[])new Object[0]));
                } else if (!allowedBasedOnItem) {
                    String configuredMapItemString = (String)configManager.getEffective(WorldMapProfiledConfigOptions.MAP_ITEM);
                    this.renderMessageScreen(I18n.func_135052_a((String)"gui.xaero_no_world_map_item_message", (Object[])new Object[0]), configuredMapItemString);
                }
            } else {
                this.renderLoadingScreen();
            }
            this.mapSwitchingGui.renderText(mc, scaledMouseX, scaledMouseY, this.field_146294_l, this.field_146295_m);
            mc.func_110434_K().func_110577_a(WorldMap.guiTextures);
            this.func_73729_b(this.field_146294_l - 34, 2, 0, 37, 32, 32);
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)973.0f);
        super.func_73863_a(scaledMouseX, scaledMouseY, partialTicks);
        if (this.rightClickMenu != null) {
            this.rightClickMenu.func_191745_a(mc, scaledMouseX, scaledMouseY, partialTicks);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)10.0f);
        if (mc.field_71462_r == this) {
            if (!(this.renderTooltips(scaledMouseX, scaledMouseY, partialTicks) || this.leftMouseButton.isDown || this.rightMouseButton.isDown)) {
                if (this.viewed != null) {
                    Tooltip hoveredTooltip = this.hoveredElementTooltipHelper(this.viewed, this.viewedInList);
                    if (hoveredTooltip != null) {
                        hoveredTooltip.drawBox(scaledMouseX, scaledMouseY, this.field_146294_l, this.field_146295_m);
                    }
                } else {
                    object2 = this.mapProcessor.renderThreadPauseSync;
                    synchronized (object2) {
                        ITextComponent bluntHighlightTooltip;
                        if (!this.mapProcessor.isRenderingPaused() && this.mapProcessor.getCurrentWorldId() != null && this.mapProcessor.getMapSaveLoad().isRegionDetectionComplete() && (bluntHighlightTooltip = this.mapProcessor.getMapWorld().getCurrentDimension().getHighlightHandler().getBlockHighlightBluntTooltip(this.mouseBlockPosX, this.mouseBlockPosZ, discoveredForHighlights)) != null) {
                            new Tooltip(bluntHighlightTooltip).drawBox(scaledMouseX, scaledMouseY, this.field_146294_l, this.field_146295_m);
                        }
                    }
                }
            }
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
            this.mapProcessor.getMessageBoxRenderer().render(this.mapProcessor.getMessageBox(), this.field_146289_q, 1, this.field_146295_m / 2, false);
        }
        GlStateManager.func_179121_F();
        this.rightMouseButton.clicked = false;
        this.leftMouseButton.clicked = false;
        this.noUploadingLimits = this.cameraX == cameraXBefore && this.cameraZ == cameraZBefore && scaleBefore == this.scale;
    }

    protected void renderPreDropdown(int scaledMouseX, int scaledMouseY, float partialTicks) {
        super.renderPreDropdown(scaledMouseX, scaledMouseY, partialTicks);
        if (this.waypointMenu) {
            SupportMods.xaeroMinimap.getWaypointMenuRenderer().postMapRender(this, scaledMouseX, scaledMouseY, this.field_146294_l, this.field_146295_m, partialTicks);
        }
        if (this.playersMenu) {
            WorldMap.trackedPlayerMenuRenderer.postMapRender(this, scaledMouseX, scaledMouseY, this.field_146294_l, this.field_146295_m, partialTicks);
        }
        this.caveModeOptions.postMapRender(this, scaledMouseX, scaledMouseY, this.field_146294_l, this.field_146295_m, partialTicks);
        this.mapSwitchingGui.postMapRender(this.field_146297_k, scaledMouseX, scaledMouseY, this.field_146294_l, this.field_146295_m);
    }

    private <E, C> Tooltip hoveredElementTooltipHelper(HoveredMapElementHolder<E, C> hovered, boolean viewedInList) {
        return hovered.getRenderer().getReader().getTooltip(hovered.getElement(), hovered.getRenderer().getContext(), viewedInList);
    }

    private void renderLoadingScreen() {
        this.renderMessageScreen("Preparing World Map...");
    }

    private void renderMessageScreen(String message) {
        this.renderMessageScreen(message, null);
    }

    private void renderMessageScreen(String message, String message2) {
        GuiMap.func_73734_a((int)0, (int)0, (int)this.field_146297_k.field_71443_c, (int)this.field_146297_k.field_71440_d, (int)-16777216);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
        this.func_73732_a(this.field_146297_k.field_71466_p, message, this.scaledresolution.func_78326_a() / 2, this.scaledresolution.func_78328_b() / 2, -1);
        if (message2 != null) {
            this.func_73732_a(this.field_146297_k.field_71466_p, message2, this.scaledresolution.func_78326_a() / 2, this.scaledresolution.func_78328_b() / 2 + 10, -1);
        }
        GlStateManager.func_179121_F();
    }

    public void drawDotOnMap(double x, double z, float angle, double sc) {
        this.drawObjectOnMap(x, z, angle, sc, 2.5f, 2.5f, 0, 69, 5, 5, 9729);
    }

    public void drawArrowOnMap(double x, double z, float angle, double sc) {
        this.drawObjectOnMap(x, z, angle, sc, 13.0f, 5.0f, 0, 0, 26, 28, 9729);
    }

    public void drawFarArrowOnMap(double x, double z, float angle, double sc) {
        this.drawObjectOnMap(x, z, angle * 90.0f, sc, 27.0f, 13.0f, 26, 0, 54, 13, 9729);
    }

    public void drawObjectOnMap(double x, double z, float angle, double sc, float offX, float offY, int textureX, int textureY, int w, int h, int filter) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)this.colourBuffer[0], (float)this.colourBuffer[1], (float)this.colourBuffer[2], (float)this.colourBuffer[3]);
        GlStateManager.func_179137_b((double)x, (double)z, (double)0.0);
        GlStateManager.func_179139_a((double)sc, (double)sc, (double)1.0);
        if (angle != 0.0f) {
            GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        this.field_146297_k.func_110434_K().func_110577_a(WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10240, (int)filter);
        GL11.glTexParameteri((int)3553, (int)10241, (int)filter);
        this.func_175174_a(-offX, -offY, textureX, textureY, w, h);
        if (filter != 9728) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    @Deprecated
    public static void renderTexturedModalRectWithLighting(float x, float y, int textureX, int textureY, float width, float height) {
        GL14.glBlendFuncSeparate((int)1, (int)0, (int)0, (int)1);
        GuiMap.renderTexturedModalRectWithLighting(x, y, width, height);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
    }

    @Deprecated
    public static void renderTexturedModalRectWithLighting(float x, float y, float width, float height) {
        GuiMap.renderTexturedModalRectWithLighting2(x, y, width, height, true);
    }

    public static void renderTexturedModalRectWithLighting2(float x, float y, float width, float height, boolean hasLight) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        if (hasLight) {
            vertexBuffer.func_181668_a(7, POSITION_TEX_TEX_TEX);
            vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + height), 0.0).func_187315_a(0.0, 1.0).func_187315_a(0.0, 1.0).func_187315_a(0.0, 1.0).func_187315_a(0.0, 1.0).func_181675_d();
            vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(1.0, 1.0).func_187315_a(1.0, 1.0).func_187315_a(1.0, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
            vertexBuffer.func_181662_b((double)(x + width), (double)(y + 0.0f), 0.0).func_187315_a(1.0, 0.0).func_187315_a(1.0, 0.0).func_187315_a(1.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), 0.0).func_187315_a(0.0, 0.0).func_187315_a(0.0, 0.0).func_187315_a(0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        } else {
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + height), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            vertexBuffer.func_181662_b((double)(x + width), (double)(y + 0.0f), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    public static void renderTexturedModalSubRectWithLighting(float x, float y, float textureX1, float textureY1, float textureX2, float textureY2, float width, float height, boolean hasLight) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        if (hasLight) {
            vertexBuffer.func_181668_a(7, POSITION_TEX_TEX_TEX);
            vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + height), 0.0).func_187315_a((double)textureX1, (double)textureY2).func_187315_a((double)textureX1, (double)textureY2).func_187315_a((double)textureX1, (double)textureY2).func_187315_a((double)textureX1, (double)textureY2).func_181675_d();
            vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)textureX2, (double)textureY2).func_187315_a((double)textureX2, (double)textureY2).func_187315_a((double)textureX2, (double)textureY2).func_187315_a((double)textureX2, (double)textureY2).func_181675_d();
            vertexBuffer.func_181662_b((double)(x + width), (double)(y + 0.0f), 0.0).func_187315_a((double)textureX2, (double)textureY1).func_187315_a((double)textureX2, (double)textureY1).func_187315_a((double)textureX2, (double)textureY1).func_187315_a((double)textureX2, (double)textureY1).func_181675_d();
            vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), 0.0).func_187315_a((double)textureX1, (double)textureY1).func_187315_a((double)textureX1, (double)textureY1).func_187315_a((double)textureX1, (double)textureY1).func_187315_a((double)textureX1, (double)textureY1).func_181675_d();
        } else {
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + height), 0.0).func_187315_a((double)textureX1, (double)textureY2).func_181675_d();
            vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)textureX2, (double)textureY2).func_181675_d();
            vertexBuffer.func_181662_b((double)(x + width), (double)(y + 0.0f), 0.0).func_187315_a((double)textureX2, (double)textureY1).func_181675_d();
            vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), 0.0).func_187315_a((double)textureX1, (double)textureY1).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    public static void renderTexturedModalRect(float x, float y, float width, float height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + height), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + 0.0f), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public void mapClicked(int button, int x, int y) {
        if (button == 1) {
            if (this.viewedOnMousePress != null && this.viewedOnMousePress.isRightClickValid() && (!(this.viewedOnMousePress.getElement() instanceof Waypoint) || SupportMods.xaeroMinimap.waypointExists((Waypoint)this.viewedOnMousePress.getElement()))) {
                this.handleRightClick(this.viewedOnMousePress, x / this.screenScale, y / this.screenScale);
                this.mouseDownPosX = -1;
                this.mouseDownPosY = -1;
                this.mapTileSelection = null;
            } else {
                this.handleRightClick(this, x / this.screenScale, y / this.screenScale);
            }
        }
    }

    private void handleRightClick(IRightClickableElement target, int x, int y) {
        if (this.rightClickMenu != null) {
            this.rightClickMenu.setClosed(true);
        }
        this.rightClickMenu = GuiRightClickMenu.getMenu(target, this, x, y, 150);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        this.mapSwitchingGui.actionPerformed(this, this.field_146297_k, this.field_146294_l, this.field_146295_m, button);
    }

    public void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        boolean result = false;
        if (this.getFocused() != null) {
            this.getFocused().func_146201_a(par1, par2);
            result = true;
        }
        if (this.isUsingTextField()) {
            if (this.waypointMenu && SupportMods.xaeroMinimap.getWaypointMenuRenderer().keyPressed(this, par2)) {
                return;
            }
            if (this.playersMenu && WorldMap.trackedPlayerMenuRenderer.keyPressed(this, par2)) {
                return;
            }
            result = true;
        }
        if (this.waypointMenu && SupportMods.xaeroMinimap.getWaypointMenuRenderer().charTyped()) {
            result = true;
            return;
        }
        if (this.playersMenu && WorldMap.trackedPlayerMenuRenderer.charTyped()) {
            result = true;
            return;
        }
        if (!result) {
            this.onInputPress(false, Keyboard.getEventKey());
        }
    }

    public void func_146282_l() throws IOException {
        if (!Keyboard.getEventKeyState()) {
            this.onInputRelease(false, Keyboard.getEventKey());
        }
        super.func_146282_l();
    }

    public static void bindMapTextureWithLighting(float brightness, MapTileChunk chunk, int magFilter, int lod) {
        GuiMap.setupTextureMatricesAndTextures(brightness);
        GuiMap.bindMapTextureWithLighting3(brightness, chunk, magFilter, lod);
    }

    @Deprecated
    public static void bindMapTextureWithLighting2(float brightness, MapTileChunk chunk, int magFilter, int lod) {
    }

    @Deprecated
    public static void bindMapTextureWithLighting3(float brightness, MapTileChunk chunk, int magFilter, int lod) {
        GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        boolean hasLight = chunk.getLeafTexture().getTextureHasLight();
        GuiMap.bindMapTextureWithLighting3(chunk.getLeafTexture(), magFilter, true, lod, hasLight);
    }

    public static void bindMapTextureWithLighting3(MapTileChunk chunk, int magFilter, int lod) {
        boolean hasLight = chunk.getLeafTexture().getTextureHasLight();
        GuiMap.bindMapTextureWithLighting3(chunk.getLeafTexture(), magFilter, true, lod, hasLight);
    }

    public static void bindMapTextureWithLighting4(MapTileChunk chunk, int lod) {
        boolean hasLight = chunk.getLeafTexture().getTextureHasLight();
        GuiMap.bindMapTextureWithLighting3(chunk.getLeafTexture(), 0, false, lod, hasLight);
    }

    public static void bindMapTextureWithLighting3(RegionTexture<?> regionTexture, int magFilter, boolean changeFilter, int lod, boolean hasLight) {
        int glTexture;
        GlStateManager.func_179138_g((int)33984);
        int n = glTexture = changeFilter ? regionTexture.bindColorTexture(false, magFilter) : regionTexture.bindColorTexture(false);
        if (hasLight) {
            GlStateManager.func_187399_a((int)8960, (int)8704, (int)34160);
        } else {
            GlStateManager.func_187399_a((int)8960, (int)8704, (int)8448);
        }
        GlStateManager.func_179138_g((int)33985);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)33986);
        if (hasLight) {
            GlStateManager.func_179098_w();
            GlStateManager.func_179144_i((int)glTexture);
        } else {
            GlStateManager.func_179090_x();
        }
        GlStateManager.func_179138_g((int)33987);
        if (hasLight) {
            GlStateManager.func_179098_w();
            GlStateManager.func_179144_i((int)glTexture);
        } else {
            GlStateManager.func_179090_x();
        }
    }

    @Deprecated
    public static void setupTextureMatrices() {
    }

    private static void setupTexture0() {
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)34160);
        GlStateManager.func_187399_a((int)8960, (int)34161, (int)34023);
        GlStateManager.func_187399_a((int)8960, (int)34176, (int)34167);
        GlStateManager.func_187399_a((int)8960, (int)34192, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)34177, (int)5890);
        GlStateManager.func_187399_a((int)8960, (int)34193, (int)770);
        GlStateManager.func_187399_a((int)8960, (int)34162, (int)7681);
        GlStateManager.func_187399_a((int)8960, (int)34184, (int)34167);
        GlStateManager.func_187399_a((int)8960, (int)34200, (int)770);
    }

    private static void setupTexture2() {
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)34160);
        GlStateManager.func_187399_a((int)8960, (int)34161, (int)260);
        GlStateManager.func_187399_a((int)8960, (int)34176, (int)34168);
        GlStateManager.func_187399_a((int)8960, (int)34192, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)34177, (int)5890);
        GlStateManager.func_187399_a((int)8960, (int)34193, (int)770);
        GlStateManager.func_187399_a((int)8960, (int)34162, (int)7681);
        GlStateManager.func_187399_a((int)8960, (int)34184, (int)34167);
        GlStateManager.func_187399_a((int)8960, (int)34200, (int)770);
    }

    private static void setupTexture3() {
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)8448);
    }

    public static void setupTextures(float brightness) {
        GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179138_g((int)33984);
        GlStateManager.func_179098_w();
        GuiMap.setupTexture0();
        GlStateManager.func_179138_g((int)33985);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)33986);
        GuiMap.setupTexture2();
        GlStateManager.func_179138_g((int)33987);
        GuiMap.setupTexture3();
        GlStateManager.func_179138_g((int)33984);
    }

    public static void setupTextureMatricesAndTextures(float brightness) {
        GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179138_g((int)33984);
        GlStateManager.func_179098_w();
        GuiMap.setupTexture0();
        GlStateManager.func_179138_g((int)33985);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)33986);
        GuiMap.setupTexture2();
        GlStateManager.func_179138_g((int)33987);
        GuiMap.setupTexture3();
        GlStateManager.func_179138_g((int)33984);
    }

    public static void restoreTextureStates() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179138_g((int)33987);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)33986);
        GlStateManager.func_187399_a((int)8960, (int)34161, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)34193, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)34162, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)34184, (int)5890);
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)8448);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)33985);
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)8448);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)33984);
        GlStateManager.func_187399_a((int)8960, (int)34161, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)34176, (int)5890);
        GlStateManager.func_187399_a((int)8960, (int)34192, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)34177, (int)34168);
        GlStateManager.func_187399_a((int)8960, (int)34193, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)34162, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)34184, (int)5890);
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)8448);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)OpenGlHelper.lastBrightnessX, (float)OpenGlHelper.lastBrightnessY);
    }

    private static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    private void setColourBuffer(float r, float g, float b, float a) {
        this.colourBuffer[0] = r;
        this.colourBuffer[1] = g;
        this.colourBuffer[2] = b;
        this.colourBuffer[3] = a;
    }

    private boolean isUsingTextField() {
        GuiTextField currentFocused = this.getFocused();
        return currentFocused != null && currentFocused.func_146206_l();
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.waypointMenu) {
            SupportMods.xaeroMinimap.getWaypointMenuRenderer().tick();
        }
        if (this.playersMenu) {
            WorldMap.trackedPlayerMenuRenderer.tick();
        }
        this.caveModeOptions.tick(this);
    }

    public KeyBinding getTrackedPlayerKeyBinding() {
        if (SupportMods.minimap() && SupportMods.xaeroMinimap.hasTrackedPlayerSystemSupport()) {
            return SupportMods.xaeroMinimap.getToggleAllyPlayersKey();
        }
        return ControlsRegister.keyToggleTrackedPlayers;
    }

    private boolean onInputPress(boolean mouse, int code) {
        IRightClickableElement hoverTarget;
        if (KeyMappingUtils.inputMatches((boolean)mouse, (int)code, (KeyBinding)ControlsRegister.keyOpenSettings, (int)0)) {
            this.onSettingsButton(this.settingsButton);
            return true;
        }
        boolean result = false;
        if (KeyMappingUtils.inputMatches((boolean)mouse, (int)code, (KeyBinding)this.field_146297_k.field_71474_y.field_74321_H, (int)0)) {
            ReflectionUtils.setReflectFieldValue((Object)this.field_146297_k.field_71474_y.field_74321_H, (Field)KEY_BINDING_PRESSED_FIELD, (Object)true);
            result = true;
        }
        if (KeyMappingUtils.inputMatches((boolean)mouse, (int)code, (KeyBinding)ControlsRegister.keyOpenMap, (int)0)) {
            this.goBack();
            result = true;
        }
        if (KeyMappingUtils.inputMatches((boolean)mouse, (int)code, (KeyBinding)this.getTrackedPlayerKeyBinding(), (int)0)) {
            WorldMap.trackedPlayerMenuRenderer.onShowPlayersButton(this, this.field_146294_l, this.field_146295_m);
            return true;
        }
        if ((!mouse && code == 13 || KeyMappingUtils.inputMatches((boolean)mouse, (int)code, (KeyBinding)ControlsRegister.keyQuickConfirm, (int)0)) && this.mapSwitchingGui.active) {
            this.mapSwitchingGui.confirm(this, this.field_146297_k, this.field_146294_l, this.field_146295_m);
            result = true;
        }
        if (KeyMappingUtils.inputMatches((boolean)mouse, (int)code, (KeyBinding)ControlsRegister.keyToggleDimension, (int)1)) {
            this.onDimensionToggleButton(this.dimensionToggleButton);
            result = true;
        }
        if (SupportMods.minimap()) {
            SupportMods.xaeroMinimap.onMapKeyPressed(mouse, code, this);
            result = true;
        }
        if ((hoverTarget = this.getHoverTarget()) != null && !mouse) {
            boolean isValid = hoverTarget.isRightClickValid();
            if (isValid) {
                if (hoverTarget instanceof HoveredMapElementHolder && ((HoveredMapElementHolder)hoverTarget).getElement() instanceof Waypoint) {
                    switch (code) {
                        case 35: {
                            SupportMods.xaeroMinimap.disableWaypoint((Waypoint)((HoveredMapElementHolder)hoverTarget).getElement());
                            this.closeRightClick();
                            result = true;
                            break;
                        }
                        case 211: {
                            SupportMods.xaeroMinimap.deleteWaypoint((Waypoint)((HoveredMapElementHolder)hoverTarget).getElement());
                            this.closeRightClick();
                            result = true;
                        }
                    }
                }
            } else {
                this.closeRightClick();
            }
        }
        return result;
    }

    private double getCurrentMapCoordinateScale() {
        return this.mapProcessor.getMapWorld().getCurrentDimension().calculateDimScale();
    }

    private boolean onInputRelease(boolean mouse, int code) {
        boolean result = false;
        if (KeyMappingUtils.inputMatches((boolean)mouse, (int)code, (KeyBinding)this.field_146297_k.field_71474_y.field_74321_H, (int)0)) {
            ReflectionUtils.setReflectFieldValue((Object)this.field_146297_k.field_71474_y.field_74321_H, (Field)KEY_BINDING_PRESSED_FIELD, (Object)false);
            result = true;
        }
        if (SupportMods.minimap() && SupportMods.xaeroMinimap.onMapKeyReleased(mouse, code, this)) {
            result = true;
        }
        if (SupportMods.minimap() && this.lastViewedDimensionId != null && !this.isUsingTextField()) {
            boolean isValid;
            IRightClickableElement hoverTarget;
            ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
            boolean waypointsConfig = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.WAYPOINTS);
            int waypointDestinationX = this.mouseBlockPosX;
            int waypointDestinationY = this.mouseBlockPosY;
            int waypointDestinationZ = this.mouseBlockPosZ;
            double waypointDestinationCoordinateScale = this.mouseBlockCoordinateScale;
            boolean waypointDestinationRightClick = false;
            if (this.rightClickMenu != null && this.rightClickMenu.getTarget() == this) {
                waypointDestinationX = this.rightClickX;
                waypointDestinationY = this.rightClickY;
                waypointDestinationZ = this.rightClickZ;
                waypointDestinationCoordinateScale = this.rightClickCoordinateScale;
                waypointDestinationRightClick = true;
            }
            if (SupportMods.xaeroMinimap.canCreateWaypoint(waypointDestinationY, waypointDestinationRightClick)) {
                if (KeyMappingUtils.inputMatches((boolean)mouse, (int)code, (KeyBinding)SupportMods.xaeroMinimap.getWaypointKeyBinding(), (int)0) && waypointsConfig) {
                    SupportMods.xaeroMinimap.createWaypoint(this, waypointDestinationX, waypointDestinationY == -1 ? -1 : waypointDestinationY + 1, waypointDestinationZ, waypointDestinationCoordinateScale, waypointDestinationRightClick);
                    this.closeRightClick();
                    result = true;
                }
                if (KeyMappingUtils.inputMatches((boolean)mouse, (int)code, (KeyBinding)SupportMods.xaeroMinimap.getTempWaypointKeyBinding(), (int)0) && waypointsConfig) {
                    this.closeRightClick();
                    SupportMods.xaeroMinimap.createTempWaypoint(waypointDestinationX, waypointDestinationY == -1 ? -1 : waypointDestinationY + 1, waypointDestinationZ, waypointDestinationCoordinateScale, waypointDestinationRightClick);
                    result = true;
                }
            }
            if ((hoverTarget = this.getHoverTarget()) != null && !mouse && !KeyMappingUtils.inputMatches((boolean)mouse, (int)code, (KeyBinding)ControlsRegister.keyOpenMap, (int)0) && (isValid = hoverTarget.isRightClickValid())) {
                if (hoverTarget instanceof HoveredMapElementHolder && ((HoveredMapElementHolder)hoverTarget).getElement() instanceof Waypoint) {
                    switch (code) {
                        case 20: {
                            SupportMods.xaeroMinimap.teleportToWaypoint((GuiScreen)this, (Waypoint)((HoveredMapElementHolder)hoverTarget).getElement());
                            this.closeRightClick();
                            result = true;
                            break;
                        }
                        case 18: {
                            SupportMods.xaeroMinimap.openWaypoint(this, (Waypoint)((HoveredMapElementHolder)hoverTarget).getElement());
                            this.closeRightClick();
                            result = true;
                        }
                    }
                } else if (hoverTarget instanceof HoveredMapElementHolder && ((HoveredMapElementHolder)hoverTarget).getElement() instanceof PlayerTrackerMapElement) {
                    switch (code) {
                        case 20: {
                            new PlayerTeleporter().teleportToPlayer((GuiScreen)this, this.mapProcessor.getMapWorld(), (PlayerTrackerMapElement)((HoveredMapElementHolder)hoverTarget).getElement());
                            this.closeRightClick();
                            result = true;
                        }
                    }
                } else {
                    this.closeRightClick();
                }
            }
        }
        return result;
    }

    private IRightClickableElement getHoverTarget() {
        return this.rightClickMenu != null ? this.rightClickMenu.getTarget() : this.viewed;
    }

    private void unfocusAll() {
        if (SupportMods.minimap()) {
            SupportMods.xaeroMinimap.getWaypointMenuRenderer().unfocusAll();
        }
        WorldMap.trackedPlayerMenuRenderer.unfocusAll();
        this.caveModeOptions.unfocusAll();
        this.setFocused(null);
    }

    public void closeRightClick() {
        if (this.rightClickMenu != null) {
            this.rightClickMenu.setClosed(true);
        }
    }

    public void onRightClickClosed() {
        this.rightClickMenu = null;
        this.mapTileSelection = null;
    }

    private void closeDropdowns() {
        if (this.openDropdown != null) {
            this.openDropdown.setClosed(true);
        }
    }

    @Override
    public ArrayList<RightClickOption> getRightClickOptions() {
        ArrayList<RightClickOption> options = new ArrayList<RightClickOption>();
        options.add(new RightClickOption("gui.xaero_right_click_map_title", options.size(), this){

            @Override
            public void onAction(GuiScreen screen) {
            }
        });
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        boolean coordinatesConfig = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.COORDINATES);
        boolean waypointsConfig = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.WAYPOINTS);
        if (!(!coordinatesConfig || SupportMods.minimap() && SupportMods.xaeroMinimap.hidingWaypointCoordinates())) {
            if (this.mapTileSelection != null) {
                String chunkOption = this.mapTileSelection.getStartX() != this.mapTileSelection.getEndX() || this.mapTileSelection.getStartZ() != this.mapTileSelection.getEndZ() ? String.format("C: (%d;%d):(%d;%d)", this.mapTileSelection.getLeft(), this.mapTileSelection.getTop(), this.mapTileSelection.getRight(), this.mapTileSelection.getBottom()) : String.format("C: (%d;%d)", this.mapTileSelection.getLeft(), this.mapTileSelection.getTop());
                options.add(new RightClickOption(chunkOption, options.size(), this){

                    @Override
                    public void onAction(GuiScreen screen) {
                    }
                });
            }
            options.add(new RightClickOption(String.format(this.rightClickY != -1 ? "X: %1$d, Y: %2$d, Z: %3$d" : "X: %1$d, Z: %3$d", this.rightClickX, this.rightClickY, this.rightClickZ), options.size(), this){

                @Override
                public void onAction(GuiScreen screen) {
                }
            });
        }
        if (SupportMods.minimap() && waypointsConfig) {
            options.add(new RightClickOption("gui.xaero_right_click_map_create_waypoint", options.size(), this){

                @Override
                public void onAction(GuiScreen screen) {
                    SupportMods.xaeroMinimap.createWaypoint(GuiMap.this, GuiMap.this.rightClickX, GuiMap.this.rightClickY == -1 ? -1 : GuiMap.this.rightClickY + 1, GuiMap.this.rightClickZ, GuiMap.this.rightClickCoordinateScale, true);
                }
            }.setNameFormatArgs(KeyMappingUtils.getKeyName((KeyBinding)SupportMods.xaeroMinimap.getWaypointKeyBinding())));
            options.add(new RightClickOption("gui.xaero_right_click_map_create_temporary_waypoint", options.size(), this){

                @Override
                public void onAction(GuiScreen screen) {
                    SupportMods.xaeroMinimap.createTempWaypoint(GuiMap.this.rightClickX, GuiMap.this.rightClickY == -1 ? -1 : GuiMap.this.rightClickY + 1, GuiMap.this.rightClickZ, GuiMap.this.rightClickCoordinateScale, true);
                }
            }.setNameFormatArgs(KeyMappingUtils.getKeyName((KeyBinding)SupportMods.xaeroMinimap.getTempWaypointKeyBinding())));
        }
        MapDimension currentDimension = this.mapProcessor.getMapWorld().getCurrentDimension();
        if (!this.field_146297_k.field_71442_b.func_78763_f() || currentDimension != null) {
            boolean teleportAllowed = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.MAP_TELEPORT_ALLOWED);
            if (teleportAllowed && (this.rightClickY != -1 || !this.field_146297_k.field_71442_b.func_78763_f())) {
                options.add(new RightClickOption("gui.xaero_right_click_map_teleport", options.size(), this){

                    @Override
                    public void onAction(GuiScreen screen) {
                        MapDimension currentDimension = GuiMap.this.mapProcessor.getMapWorld().getCurrentDimension();
                        if (!(GuiMap.this.field_146297_k.field_71442_b.func_78763_f() && currentDimension == null || GuiMap.this.rightClickY == -1 && GuiMap.this.field_146297_k.field_71442_b.func_78763_f())) {
                            Integer tpDim = GuiMap.this.rightClickDim.intValue() != GuiMap.this.field_146297_k.field_71441_e.field_73011_w.getDimension() ? GuiMap.this.rightClickDim : null;
                            new MapTeleporter().teleport((GuiScreen)GuiMap.this, GuiMap.this.mapProcessor.getMapWorld(), GuiMap.this.rightClickX, GuiMap.this.rightClickY == -1 ? -1 : GuiMap.this.rightClickY + 1, GuiMap.this.rightClickZ, tpDim);
                        }
                    }
                });
            } else if (!teleportAllowed) {
                options.add(new RightClickOption("gui.xaero_wm_right_click_map_teleport_not_allowed", options.size(), this){

                    @Override
                    public void onAction(GuiScreen screen) {
                    }
                });
            } else {
                options.add(new RightClickOption("gui.xaero_right_click_map_cant_teleport", options.size(), this){

                    @Override
                    public void onAction(GuiScreen screen) {
                    }
                });
            }
        } else {
            options.add(new RightClickOption("gui.xaero_right_click_map_cant_teleport_world", options.size(), this){

                @Override
                public void onAction(GuiScreen screen) {
                }
            });
        }
        if (SupportMods.minimap()) {
            if (SupportMods.xaeroMinimap.canShareLocation(this.rightClickY)) {
                options.add(new RightClickOption("gui.xaero_right_click_map_share_location", options.size(), this){

                    @Override
                    public void onAction(GuiScreen screen) {
                        SupportMods.xaeroMinimap.shareLocation(GuiMap.this, GuiMap.this.rightClickX, GuiMap.this.rightClickY == -1 ? -1 : GuiMap.this.rightClickY + 1, GuiMap.this.rightClickZ);
                    }
                });
            } else {
                options.add(new RightClickOption("gui.xaero_right_click_map_cant_share_location", options.size(), this){

                    @Override
                    public void onAction(GuiScreen screen) {
                    }
                });
            }
            if (waypointsConfig) {
                options.add(new RightClickOption("gui.xaero_right_click_map_waypoints_menu", options.size(), this){

                    @Override
                    public void onAction(GuiScreen screen) {
                        SupportMods.xaeroMinimap.openWaypointsMenu(GuiMap.this.field_146297_k, GuiMap.this);
                    }
                }.setNameFormatArgs(KeyMappingUtils.getKeyName((KeyBinding)SupportMods.xaeroMinimap.getTempWaypointsMenuKeyBinding())));
            }
        }
        options.add(new RightClickOption("gui.xaero_right_click_box_map_export", options.size(), this){

            @Override
            public void onAction(GuiScreen screen) {
                GuiMap.this.onExportButton(GuiMap.this.exportButton);
            }
        });
        options.add(new RightClickOption("gui.xaero_right_click_box_map_settings", options.size(), this){

            @Override
            public void onAction(GuiScreen screen) {
                GuiMap.this.onSettingsButton(GuiMap.this.settingsButton);
            }
        }.setNameFormatArgs(KeyMappingUtils.getKeyName((KeyBinding)ControlsRegister.keyOpenSettings)));
        return options;
    }

    @Override
    public boolean isRightClickValid() {
        return true;
    }

    @Override
    public int getRightClickTitleBackgroundColor() {
        return -10461088;
    }

    public GuiTextField getFocused() {
        return this.focusedField;
    }

    public void setFocused(GuiTextField field) {
        this.focusedField = field;
    }

    public boolean shouldSkipWorldRender() {
        return true;
    }

    public double getUserScale() {
        return this.userScale;
    }

    public GuiButton getRadarButton() {
        return this.radarButton;
    }

    public void onDropdownOpen(DropDownWidget menu) {
        super.onDropdownOpen(menu);
        this.unfocusAll();
    }

    public void onDropdownClosed(DropDownWidget menu) {
        super.onDropdownClosed(menu);
        if (menu == this.rightClickMenu) {
            this.onRightClickClosed();
        }
    }

    public void onCaveModeStartSet() {
        this.caveModeOptions.onCaveModeStartSet(this);
    }

    public MapDimension getFutureDimension() {
        return this.futureDimension;
    }

    public MapProcessor getMapProcessor() {
        return this.mapProcessor;
    }

    public void enableCaveModeOptions() {
        if (!this.caveModeOptions.isEnabled()) {
            this.caveModeOptions.toggle(this);
        }
    }

    public void removeWidget(GuiButton current) {
        super.removeWidget(current);
    }

    public void addWidget(DropDownWidget current) {
        super.addWidget(current);
    }

    static {
        POSITION_TEX_TEX_TEX.func_181721_a(DefaultVertexFormats.field_181713_m).func_181721_a(DefaultVertexFormats.field_181715_o).func_181721_a(TEX_2F_1).func_181721_a(TEX_2F_2).func_181721_a(TEX_2F_3);
        KEY_BINDING_PRESSED_FIELD = ReflectionUtils.getFieldReflection(KeyBinding.class, (String)"pressed", (String)"", (String)"", (String)"field_74513_e");
        FULL_RELOAD_IN_PROGRESS = new TextComponentTranslation("gui.xaero_full_reload_in_progress", new Object[0]);
        UNKNOWN_DIMENSION_TYPE1 = new TextComponentTranslation("gui.xaero_unknown_dimension_type1", new Object[0]);
        UNKNOWN_DIMENSION_TYPE2 = new TextComponentTranslation("gui.xaero_unknown_dimension_type2", new Object[0]);
        lastAmountOfRegionsViewed = 1;
        destScale = 3.0;
        primaryScaleFBO = null;
    }
}

