/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.message.basic;

import java.io.IOException;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import xaero.lib.common.packet.XaeroPacket;
import xaero.map.mcworld.WorldMapClientWorldDataHelper;

public class ClientboundRulesPacket
extends XaeroPacket {
    public boolean allowCaveModeOnServer;
    public boolean allowNetherCaveModeOnServer;

    public ClientboundRulesPacket(boolean allowCaveModeOnServer, boolean allowNetherCaveModeOnServer) {
        this.allowCaveModeOnServer = allowCaveModeOnServer;
        this.allowNetherCaveModeOnServer = allowNetherCaveModeOnServer;
    }

    public ClientboundRulesPacket() {
    }

    protected void read(PacketBuffer buf) {
        NBTTagCompound nbt;
        try {
            nbt = buf.func_150793_b();
        }
        catch (IOException e) {
            return;
        }
        this.allowCaveModeOnServer = nbt.func_74767_n("cm");
        this.allowNetherCaveModeOnServer = nbt.func_74767_n("ncm");
    }

    protected void write(PacketBuffer buf) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("cm", this.allowCaveModeOnServer);
        nbt.func_74757_a("ncm", this.allowNetherCaveModeOnServer);
        buf.func_150786_a(nbt);
    }

    public static class ClientHandler
    implements Consumer<ClientboundRulesPacket> {
        @Override
        public void accept(ClientboundRulesPacket message) {
            WorldMapClientWorldDataHelper.getCurrentWorldData().setSyncedRules(message);
        }
    }
}

