/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math;

import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class VectorUtils {
    public static void set(Tuple3d vec, double value, EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                vec.x = value;
                break;
            }
            case Y: {
                vec.y = value;
                break;
            }
            case Z: {
                vec.z = value;
            }
        }
    }

    public static void set(Tuple3f vec, float value, EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                vec.x = value;
                break;
            }
            case Y: {
                vec.y = value;
                break;
            }
            case Z: {
                vec.z = value;
            }
        }
    }

    public static Vec3d set(Vec3d vec, double value, EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return new Vec3d(value, vec.field_72448_b, vec.field_72449_c);
            }
            case Y: {
                return new Vec3d(vec.field_72450_a, value, vec.field_72449_c);
            }
            case Z: {
                return new Vec3d(vec.field_72450_a, vec.field_72448_b, value);
            }
        }
        return null;
    }

    public static BlockPos set(BlockPos vec, int value, EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return new BlockPos(value, vec.func_177956_o(), vec.func_177952_p());
            }
            case Y: {
                return new BlockPos(vec.func_177958_n(), value, vec.func_177952_p());
            }
            case Z: {
                return new BlockPos(vec.func_177958_n(), vec.func_177956_o(), value);
            }
        }
        return null;
    }

    public static double get(EnumFacing.Axis axis, Tuple3d vec) {
        return VectorUtils.get(axis, vec.x, vec.y, vec.z);
    }

    public static float get(EnumFacing.Axis axis, Tuple3f vec) {
        return VectorUtils.get(axis, vec.x, vec.y, vec.z);
    }

    public static double get(EnumFacing.Axis axis, Vec3d vec) {
        return VectorUtils.get(axis, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public static int get(EnumFacing.Axis axis, Vec3i vec) {
        return VectorUtils.get(axis, vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }

    public static float get(EnumFacing.Axis axis, float x, float y, float z) {
        switch (axis) {
            case X: {
                return x;
            }
            case Y: {
                return y;
            }
            case Z: {
                return z;
            }
        }
        return 0.0f;
    }

    public static double get(EnumFacing.Axis axis, double x, double y, double z) {
        switch (axis) {
            case X: {
                return x;
            }
            case Y: {
                return y;
            }
            case Z: {
                return z;
            }
        }
        return 0.0;
    }

    public static int get(EnumFacing.Axis axis, int x, int y, int z) {
        switch (axis) {
            case X: {
                return x;
            }
            case Y: {
                return y;
            }
            case Z: {
                return z;
            }
        }
        return 0;
    }

    public static boolean isZero(double number) {
        return number > (double)-1.0E-4f && number < (double)1.0E-4f;
    }

    public static boolean isZero(float number) {
        return number > -1.0E-4f && number < 1.0E-4f;
    }

    public static boolean equals(double number, double number2) {
        return number - number2 > (double)-1.0E-4f && number - number2 < (double)1.0E-4f;
    }

    public static boolean equals(float number, float number2) {
        return number - number2 > -1.0E-4f && number - number2 < 1.0E-4f;
    }
}

