/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.packet;

import com.phylogeny.extrabitmanipulation.helper.BitIOHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.packet.PacketBitMapIO;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import mod.chiselsandbits.api.IBitBrush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketOverwriteStackBitMappings
extends PacketBitMapIO {
    private Map<IBlockState, IBitBrush> bitMap;

    public PacketOverwriteStackBitMappings() {
    }

    public PacketOverwriteStackBitMappings(Map<IBlockState, IBitBrush> bitMap, String nbtKey, boolean saveStatesById) {
        super(nbtKey, saveStatesById);
        this.bitMap = bitMap;
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        BitIOHelper.stateToBitMapToBytes(buffer, this.bitMap);
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.bitMap = BitIOHelper.stateToBitMapFromBytes(buffer);
    }

    public static class Handler
    implements IMessageHandler<PacketOverwriteStackBitMappings, IMessage> {
        public IMessage onMessage(final PacketOverwriteStackBitMappings message, final MessageContext ctx) {
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    ItemStack stack = player.func_184614_ca();
                    if (ItemStackHelper.isModelingToolStack(stack)) {
                        BitIOHelper.writeStateToBitMapToNBT(stack, message.nbtKey, message.bitMap, message.saveStatesById);
                        player.field_71069_bz.func_75142_b();
                    }
                }
            });
            return null;
        }
    }
}

