/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.util.FluidQuantity;
import cam72cam.immersiverailroading.util.Speed;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.Player;
import cam72cam.mod.fluid.Fluid;
import java.util.ArrayList;
import java.util.List;

public class HandCar
extends Locomotive {
    @Override
    public double getAppliedTractiveEffort(Speed speed) {
        int passengers = 0;
        for (Entity passenger : this.getPassengers()) {
            if (!passenger.isPlayer()) continue;
            Player player = passenger.asPlayer();
            if (!player.isCreative()) {
                if (player.getFoodLevel() <= 0) continue;
                ++passengers;
                continue;
            }
            ++passengers;
        }
        double maxPower_W = (double)this.getDefinition().getHorsePower(this.gauge) * 745.7 * (double)passengers;
        double efficiency = 0.82;
        double speed_M_S = Math.abs(speed.metric()) / 3.6;
        double maxPowerAtSpeed = maxPower_W * efficiency / Math.max(0.001, speed_M_S);
        return maxPowerAtSpeed * (double)this.getThrottle() * (double)this.getReverser();
    }

    @Override
    public boolean providesElectricalPower() {
        return false;
    }

    @Override
    protected boolean forceLinkThrottleReverser() {
        return true;
    }

    @Override
    public void onTick() {
        super.onTick();
        if (this.getWorld().isClient) {
            return;
        }
        if (this.getTrainBrake() > 0.0f) {
            this.setTrainBrake(0.0f);
        }
        if (this.getThrottle() != 0.0f && this.getTickCount() % (int)(600.0 * (1.1 - (double)this.getThrottle())) == 0) {
            for (Entity passenger : this.getPassengers()) {
                Player player;
                if (!passenger.isPlayer() || (player = passenger.asPlayer()).isCreative() || player.getFoodLevel() <= 0) continue;
                player.useFood(1);
            }
        }
    }

    @Override
    public FluidQuantity getTankCapacity() {
        return FluidQuantity.ZERO;
    }

    @Override
    public List<Fluid> getFluidFilter() {
        return new ArrayList<Fluid>();
    }

    @Override
    public int getInventoryWidth() {
        return 2;
    }
}

