/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model;

import cam72cam.immersiverailroading.ConfigGraphics;
import cam72cam.immersiverailroading.ConfigSound;
import cam72cam.immersiverailroading.entity.CarPassenger;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.gui.overlay.Readouts;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.model.ModelState;
import cam72cam.immersiverailroading.model.animation.StockAnimation;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.model.part.Bogey;
import cam72cam.immersiverailroading.model.part.Control;
import cam72cam.immersiverailroading.model.part.Door;
import cam72cam.immersiverailroading.model.part.DrivingAssembly;
import cam72cam.immersiverailroading.model.part.FlangeSound;
import cam72cam.immersiverailroading.model.part.Frame;
import cam72cam.immersiverailroading.model.part.Interactable;
import cam72cam.immersiverailroading.model.part.LightFlare;
import cam72cam.immersiverailroading.model.part.PartSound;
import cam72cam.immersiverailroading.model.part.Readout;
import cam72cam.immersiverailroading.model.part.Seat;
import cam72cam.immersiverailroading.model.part.SwaySimulator;
import cam72cam.immersiverailroading.model.part.TrackFollower;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.mod.Config;
import cam72cam.mod.MinecraftClient;
import cam72cam.mod.model.obj.OBJModel;
import cam72cam.mod.render.OptiFine;
import cam72cam.mod.render.obj.OBJRender;
import cam72cam.mod.render.opengl.RenderState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import util.Matrix4;

public class StockModel<ENTITY extends EntityMoveableRollingStock, DEFINITION extends EntityRollingStockDefinition>
extends OBJModel {
    private final DEFINITION def;
    public final List<ModelComponent> allComponents;
    protected ModelState base;
    protected ModelState rocking;
    protected ModelState front;
    protected ModelState frontRocking;
    protected ModelState rear;
    protected ModelState rearRocking;
    protected Frame frame;
    protected Bogey bogeyFront;
    protected Bogey bogeyRear;
    protected DrivingAssembly drivingWheels;
    private ModelComponent shell;
    private ModelComponent remaining;
    protected final List<Door<ENTITY>> doors;
    protected final List<Control<ENTITY>> controls;
    protected final List<Readout<ENTITY>> gauges;
    protected final List<Seat<ENTITY>> seats;
    protected List<LightFlare<ENTITY>> headlights;
    private final TrackFollower.TrackFollowers frontTrackers;
    private final TrackFollower.TrackFollowers rearTrackers;
    public static final int LOD_LARGE = 1024;
    public static final int LOD_SMALL = 512;
    private final List<StockAnimation> animations;
    private final float sndRand;
    private final PartSound wheel_sound;
    private final PartSound slidingSound;
    private final FlangeSound flangeSound;
    private final SwaySimulator sway;
    private int lod_level = 1024;
    private int lod_tick = 0;

    public StockModel(DEFINITION def) throws Exception {
        super(((EntityRollingStockDefinition)def).modelLoc, ((EntityRollingStockDefinition)def).darken, ((EntityRollingStockDefinition)def).internal_model_scale, ((EntityRollingStockDefinition)def).textureNames.keySet(), ConfigGraphics.textureCacheSeconds, i -> {
            ArrayList<Integer> lodSizes = new ArrayList<Integer>();
            lodSizes.add(1024);
            lodSizes.add(512);
            return lodSizes;
        });
        this.def = def;
        boolean hasInterior = this.groups().stream().anyMatch(x -> x.contains("INTERIOR"));
        this.doors = new ArrayList<Door<ENTITY>>();
        this.seats = new ArrayList<Seat<ENTITY>>();
        this.controls = new ArrayList<Control<ENTITY>>();
        this.gauges = new ArrayList<Readout<ENTITY>>();
        this.headlights = new ArrayList<LightFlare<ENTITY>>();
        ModelState.LightState base = new ModelState.LightState(null, null, null, hasInterior);
        float interiorLight = ((EntityRollingStockDefinition)def).interiorLightLevel();
        ModelState.Lighter interiorLit = stock -> {
            if (!stock.hasElectricalPower()) {
                return base;
            }
            boolean hasInteriorOverride = hasInterior;
            if (!hasInteriorOverride) {
                hasInteriorOverride = (stock instanceof Locomotive || stock instanceof CarPassenger) && ConfigGraphics.FakeInteriorLighting ? MinecraftClient.getPlayer().getRiding() != stock : true;
            }
            float blockLight = stock.getWorld().getBlockLightLevel(stock.getBlockPosition());
            float skyLight = stock.getWorld().getSkyLightLevel(stock.getBlockPosition());
            boolean brighter = blockLight < interiorLight;
            return base.merge(new ModelState.LightState(brighter ? Float.valueOf(interiorLight) : null, brighter ? Float.valueOf(skyLight) : null, true, hasInteriorOverride));
        };
        this.animations = new ArrayList<StockAnimation>();
        for (EntityRollingStockDefinition.AnimationDefinition animDef : ((EntityRollingStockDefinition)def).animations) {
            if (!animDef.valid()) continue;
            this.animations.add(new StockAnimation(animDef, ((EntityRollingStockDefinition)def).internal_model_scale));
        }
        ModelState.GroupAnimator animators = (stock, group, partialTicks) -> {
            Matrix4 m = null;
            for (StockAnimation animation : this.animations) {
                Matrix4 found = animation.getMatrix(stock, group, partialTicks);
                if (found == null) continue;
                if (m == null) {
                    m = found;
                    continue;
                }
                m.multiply(found);
            }
            return m;
        };
        this.base = ModelState.construct(settings -> settings.add(animators).add(interiorLit));
        ComponentProvider provider = new ComponentProvider(this, ((EntityRollingStockDefinition)def).internal_model_scale, ((EntityRollingStockDefinition)def).widgetConfig);
        this.initStates();
        this.parseControllable(provider, def);
        this.bogeyFront = Bogey.get(provider, this.front, this.unifiedBogies(), ModelComponentType.ModelPosition.FRONT);
        this.bogeyRear = Bogey.get(provider, this.rear, this.unifiedBogies(), ModelComponentType.ModelPosition.REAR);
        this.parseComponents(provider, def);
        provider.parse(ModelComponentType.IMMERSIVERAILROADING_BASE_COMPONENT);
        this.remaining = provider.parse(ModelComponentType.REMAINING);
        this.rocking.include(this.remaining);
        this.allComponents = provider.components();
        this.frontTrackers = new TrackFollower.TrackFollowers(s -> new TrackFollower((EntityMoveableRollingStock)((Object)s), this.bogeyFront != null ? this.bogeyFront.bogey : null, this.bogeyFront != null ? this.bogeyFront.wheels : null, true));
        this.rearTrackers = new TrackFollower.TrackFollowers(s -> new TrackFollower((EntityMoveableRollingStock)((Object)s), this.bogeyRear != null ? this.bogeyRear.bogey : null, this.bogeyRear != null ? this.bogeyRear.wheels : null, false));
        this.sndRand = (float)Math.random() / 10.0f;
        this.wheel_sound = new PartSound(new EntityRollingStockDefinition.SoundDefinition(((EntityRollingStockDefinition)def).wheel_sound), true, 40.0f, ConfigSound.SoundCategories.RollingStock::wheel);
        this.slidingSound = new PartSound(new EntityRollingStockDefinition.SoundDefinition(((EntityRollingStockDefinition)def).sliding_sound), true, 40.0f, ConfigSound.SoundCategories.RollingStock::sliding);
        this.flangeSound = new FlangeSound(((EntityRollingStockDefinition)def).flange_sound, true, 40.0f);
        this.sway = new SwaySimulator();
    }

    public ModelState addRoll(ModelState state) {
        return state.push(builder -> builder.add((stock, partialTicks) -> new Matrix4().rotate(Math.toRadians(this.sway.getRollDegrees(stock, partialTicks)), 1.0, 0.0, 0.0)));
    }

    protected void initStates() {
        this.rocking = this.addRoll(this.base);
        this.front = this.base.push(settings -> settings.add((stock, partialTicks) -> this.getFrontBogeyMatrix(stock)));
        this.frontRocking = this.addRoll(this.front);
        this.rear = this.base.push(settings -> settings.add((stock, partialTicks) -> this.getRearBogeyMatrix(stock)));
        this.rearRocking = this.addRoll(this.rear);
    }

    protected void addGauge(ComponentProvider provider, ModelComponentType type, Readouts value) {
        this.gauges.addAll(Readout.getReadouts(provider, this.frontRocking, type, ModelComponentType.ModelPosition.BOGEY_FRONT, value));
        this.gauges.addAll(Readout.getReadouts(provider, this.rearRocking, type, ModelComponentType.ModelPosition.BOGEY_REAR, value));
        this.gauges.addAll(Readout.getReadouts(provider, this.rocking, type, ModelComponentType.ModelPosition.FRONT, value));
        this.gauges.addAll(Readout.getReadouts(provider, this.rocking, type, ModelComponentType.ModelPosition.REAR, value));
        this.gauges.addAll(Readout.getReadouts(provider, this.rocking, type, value));
    }

    protected void addControl(ComponentProvider provider, ModelComponentType type) {
        this.controls.addAll(Control.get(provider, this.frontRocking, type, ModelComponentType.ModelPosition.BOGEY_FRONT));
        this.controls.addAll(Control.get(provider, this.rearRocking, type, ModelComponentType.ModelPosition.BOGEY_REAR));
        this.controls.addAll(Control.get(provider, this.rocking, type, ModelComponentType.ModelPosition.FRONT));
        this.controls.addAll(Control.get(provider, this.rocking, type, ModelComponentType.ModelPosition.REAR));
        this.controls.addAll(Control.get(provider, this.rocking, type));
    }

    protected void addDoor(ComponentProvider provider) {
        this.doors.addAll(Door.get(provider, this.frontRocking, ModelComponentType.ModelPosition.BOGEY_FRONT));
        this.doors.addAll(Door.get(provider, this.rearRocking, ModelComponentType.ModelPosition.BOGEY_REAR));
        this.doors.addAll(Door.get(provider, this.rocking));
    }

    protected void addHeadlight(DEFINITION def, ComponentProvider provider, ModelComponentType type) {
        this.headlights.addAll(LightFlare.get(def, provider, this.frontRocking, type, ModelComponentType.ModelPosition.BOGEY_FRONT));
        this.headlights.addAll(LightFlare.get(def, provider, this.rearRocking, type, ModelComponentType.ModelPosition.BOGEY_REAR));
        this.headlights.addAll(LightFlare.get(def, provider, this.rocking, type));
    }

    protected void parseControllable(ComponentProvider provider, DEFINITION def) {
        this.gauges.addAll(Readout.getReadouts(provider, this.frontRocking, ModelComponentType.COUPLED_X, ModelComponentType.ModelPosition.BOGEY_FRONT, Readouts.COUPLED_FRONT));
        this.gauges.addAll(Readout.getReadouts(provider, this.rearRocking, ModelComponentType.COUPLED_X, ModelComponentType.ModelPosition.BOGEY_REAR, Readouts.COUPLED_REAR));
        this.gauges.addAll(Readout.getReadouts(provider, this.rocking, ModelComponentType.COUPLED_X, ModelComponentType.ModelPosition.FRONT, Readouts.COUPLED_FRONT));
        this.gauges.addAll(Readout.getReadouts(provider, this.rocking, ModelComponentType.COUPLED_X, ModelComponentType.ModelPosition.REAR, Readouts.COUPLED_REAR));
        this.addControl(provider, ModelComponentType.COUPLER_ENGAGED_X);
        if (((EntityRollingStockDefinition)def).hasIndependentBrake()) {
            this.addGauge(provider, ModelComponentType.GAUGE_INDEPENDENT_BRAKE_X, Readouts.INDEPENDENT_BRAKE);
        }
        this.addGauge(provider, ModelComponentType.BRAKE_PRESSURE_X, Readouts.BRAKE_PRESSURE);
        this.addControl(provider, ModelComponentType.WINDOW_X);
        this.addControl(provider, ModelComponentType.WIDGET_X);
        if (((EntityRollingStockDefinition)def).hasIndependentBrake()) {
            this.addControl(provider, ModelComponentType.INDEPENDENT_BRAKE_X);
        }
        this.addDoor(provider);
        this.seats.addAll(Seat.get(provider, this.rocking));
        this.addHeadlight(def, provider, ModelComponentType.HEADLIGHT_X);
    }

    protected void parseComponents(ComponentProvider provider, DEFINITION def) {
        this.frame = new Frame(provider, this.base, this.rocking, ((EntityRollingStockDefinition)def).defID);
        this.drivingWheels = DrivingAssembly.get(((EntityRollingStockDefinition)def).getValveGear(), provider, this.base, 0.0f, this.frame != null ? this.frame.wheels : null, this.bogeyFront != null ? this.bogeyFront.wheels : null, this.bogeyRear != null ? this.bogeyRear.wheels : null);
        this.shell = provider.parse(ModelComponentType.SHELL);
        this.rocking.include(this.shell);
    }

    protected boolean unifiedBogies() {
        return true;
    }

    public final void onClientTick(EntityMoveableRollingStock stock) {
        this.effects(stock);
    }

    protected void effects(ENTITY stock) {
        this.headlights.forEach(x -> x.effects(stock));
        this.controls.forEach(c -> c.effects(stock));
        this.doors.forEach(c -> c.effects(stock));
        this.gauges.forEach(c -> c.effects(stock));
        this.animations.forEach(c -> c.effects(stock));
        float adjust = (float)Math.abs(((EntityMoveableRollingStock)((Object)stock)).getCurrentSpeed().metric()) / 300.0f;
        float pitch = adjust + 0.7f;
        if (((EntityRollingStock)((Object)stock)).getDefinition().shouldScalePitch()) {
            pitch = (float)((double)pitch / ((EntityMoveableRollingStock)((Object)stock)).gauge.scale());
        }
        float volume = 0.01f + adjust;
        this.wheel_sound.effects((EntityMoveableRollingStock)((Object)stock), Math.abs(((EntityMoveableRollingStock)((Object)stock)).getCurrentSpeed().metric()) > 1.0 ? volume : 0.0f, pitch + this.sndRand);
        this.slidingSound.effects((EntityMoveableRollingStock)((Object)stock), ((EntityMoveableRollingStock)((Object)stock)).sliding ? Math.min(1.0f, adjust * 4.0f) : 0.0f);
        this.flangeSound.effects((EntityMoveableRollingStock)((Object)stock));
        this.sway.effects((EntityMoveableRollingStock)((Object)stock));
    }

    public final void onClientRemoved(EntityMoveableRollingStock stock) {
        this.removed(stock);
    }

    protected void removed(ENTITY stock) {
        this.headlights.forEach(x -> x.removed(stock));
        this.controls.forEach(c -> c.removed(stock));
        this.doors.forEach(c -> c.removed(stock));
        this.gauges.forEach(c -> c.removed(stock));
        this.animations.forEach(c -> c.removed(stock));
        this.wheel_sound.removed((EntityMoveableRollingStock)((Object)stock));
        this.slidingSound.removed((EntityMoveableRollingStock)((Object)stock));
        this.flangeSound.removed((EntityMoveableRollingStock)((Object)stock));
        this.sway.removed((EntityMoveableRollingStock)((Object)stock));
    }

    public final void renderEntity(EntityMoveableRollingStock stock, RenderState state, float partialTicks) {
        List<ModelComponentType> available = stock.isBuilt() ? null : stock.getItemComponents().stream().flatMap(x -> x.render.stream()).collect(Collectors.toList());
        state.lighting(true).cull_face(false).rescale_normal(true).scale(stock.gauge.scale(), stock.gauge.scale(), stock.gauge.scale());
        if (!(!ConfigGraphics.OptifineEntityShaderOverrideAll && this.normals.isEmpty() && this.speculars.isEmpty() || ConfigGraphics.OptiFineEntityShader == OptiFine.Shaders.Entities)) {
            state = state.shader(ConfigGraphics.OptiFineEntityShader);
        }
        if (this.lod_tick + 10 < stock.getTickCount() || this.lod_tick > stock.getTickCount()) {
            this.lod_tick = stock.getTickCount();
            double playerDistanceSq = stock.getWorld().getEntities(((Object)((Object)stock)).getClass()).stream().filter(x -> Objects.equals(x.getDefinitionID(), stock.getDefinitionID()) && Objects.equals(x.getTexture(), stock.getTexture())).mapToDouble(x -> x.getPosition().distanceToSquared(MinecraftClient.getPlayer().getPosition())).min().orElse(0.0);
            this.lod_level = playerDistanceSq > ConfigGraphics.StockLODDistance * 2.0 * ConfigGraphics.StockLODDistance * 2.0 ? 512 : (playerDistanceSq > ConfigGraphics.StockLODDistance * ConfigGraphics.StockLODDistance ? 1024 : Config.MaxTextureSize);
        }
        OBJModel.Binder binder = this.binder().texture(stock.getTexture()).lod(this.lod_level);
        try (OBJRender.Binding bound = binder.bind(state);){
            double backup = stock.distanceTraveled;
            if (!stock.isSliding()) {
                stock.distanceTraveled += stock.getCurrentSpeed().minecraft() * (double)stock.getTickSkew() * (double)partialTicks * 1.1;
            }
            stock.distanceTraveled /= stock.gauge.scale();
            this.base.render(bound, stock, available, partialTicks);
            stock.distanceTraveled = backup;
        }
    }

    public void postRenderEntity(EntityMoveableRollingStock stock, RenderState state, float partialTicks) {
        this.postRender(stock, state, partialTicks);
    }

    private Matrix4 getFrontBogeyMatrix(EntityMoveableRollingStock stock) {
        return this.frontTrackers.get(stock).getMatrix();
    }

    public float getFrontYaw(EntityMoveableRollingStock stock) {
        return this.frontTrackers.get(stock).getYawReadout();
    }

    private Matrix4 getRearBogeyMatrix(EntityMoveableRollingStock stock) {
        return this.rearTrackers.get(stock).getMatrix();
    }

    public float getRearYaw(EntityMoveableRollingStock stock) {
        return this.rearTrackers.get(stock).getYawReadout();
    }

    protected void postRender(ENTITY stock, RenderState state, float partialTicks) {
        state.scale(((EntityMoveableRollingStock)((Object)stock)).gauge.scale(), ((EntityMoveableRollingStock)((Object)stock)).gauge.scale(), ((EntityMoveableRollingStock)((Object)stock)).gauge.scale());
        state.rotate(this.sway.getRollDegrees((EntityMoveableRollingStock)((Object)stock), partialTicks), 1.0, 0.0, 0.0);
        this.controls.forEach(c -> c.postRender(stock, state, partialTicks));
        this.doors.forEach(c -> c.postRender(stock, state, partialTicks));
        this.gauges.forEach(c -> c.postRender(stock, state, partialTicks));
        this.headlights.forEach(x -> x.postRender(stock, state));
    }

    public List<Control<ENTITY>> getControls() {
        return this.controls;
    }

    public List<Door<ENTITY>> getDoors() {
        return this.doors;
    }

    public List<Control<ENTITY>> getDraggable() {
        ArrayList<Control<ENTITY>> draggable = new ArrayList<Control<ENTITY>>();
        draggable.addAll(this.controls);
        draggable.addAll(this.doors);
        return draggable;
    }

    public List<Interactable<ENTITY>> getInteractable() {
        ArrayList<Interactable<ENTITY>> interactable = new ArrayList<Interactable<ENTITY>>(this.getDraggable());
        interactable.addAll(this.seats);
        return interactable;
    }

    public List<Seat<ENTITY>> getSeats() {
        return this.seats;
    }
}

