/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.part;

import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.entity.Freight;
import cam72cam.immersiverailroading.items.ItemRollingStock;
import cam72cam.immersiverailroading.items.ItemRollingStockComponent;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.Fuzzy;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.render.StandardModel;
import cam72cam.mod.render.obj.OBJRender;
import cam72cam.mod.render.opengl.RenderState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import util.Matrix4;

public class CargoItems {
    private final Map<UUID, StandardModel> cache = new HashMap<UUID, StandardModel>();
    private Map<UUID, Long> lastUpdate = new HashMap<UUID, Long>();
    private final List<ModelComponent> components;

    public static CargoItems get(ComponentProvider provider) {
        List<ModelComponent> found = provider.parseAll(ModelComponentType.CARGO_ITEMS_X);
        return found.isEmpty() ? null : new CargoItems(found);
    }

    public CargoItems(List<ModelComponent> components) {
        this.components = components;
    }

    public <T extends Freight> void postRender(T stock, RenderState state) {
        StandardModel model;
        if (stock.getWorld().getTicks() > this.lastUpdate.getOrDefault(stock.getUUID(), 0L) + 40L) {
            this.cache.clear();
            this.lastUpdate.put(stock.getUUID(), stock.getWorld().getTicks());
        }
        if ((model = this.cache.get(stock.getUUID())) == null) {
            model = new StandardModel();
            double totalVolume = this.components.stream().mapToDouble(a -> a.length() * a.width() * a.height()).sum();
            int slotOffset = 0;
            Double minY = null;
            for (int i = 0; i < stock.cargoItems.getSlotCount(); ++i) {
                ItemStack stack = stock.cargoItems.get(i);
                if (!stack.is((CustomItem)IRItems.ITEM_ROLLING_STOCK_COMPONENT)) continue;
                ItemRollingStockComponent.Data data = new ItemRollingStockComponent.Data(stack);
                for (ModelComponentType r : data.componentType.render) {
                    List<ModelComponent> mc = data.def.getComponents(r);
                    if (mc == null) continue;
                    for (int j = 0; j < Math.min(mc.size(), stack.getCount()); ++j) {
                        if (minY != null && !(minY > mc.get((int)j).min.y)) continue;
                        minY = mc.get((int)j).min.y;
                    }
                }
            }
            double componentOffset = minY == null ? 0.0 : minY;
            for (ModelComponent comp : this.components) {
                double xSize = comp.length();
                double ySize = comp.height();
                double zSize = comp.width();
                double modelVolume = xSize * ySize * zSize;
                int cargoSlots = (int)Math.ceil((double)stock.cargoItems.getSlotCount() * modelVolume / totalVolume);
                double ratio = Math.pow((double)cargoSlots / modelVolume, 0.33333);
                double xItemsIdeal = ratio * xSize;
                double yItemsIdeal = ratio * ySize;
                double zItemsIdeal = ratio * zSize;
                double bestFit = Double.MAX_VALUE;
                int xItems = (int)Math.round(xItemsIdeal);
                int yItems = (int)Math.round(yItemsIdeal);
                int zItems = (int)Math.round(zItemsIdeal);
                for (int x = 1; x < cargoSlots; ++x) {
                    for (int y = 1; y < cargoSlots; ++y) {
                        for (int z = 1; z < cargoSlots; ++z) {
                            int currentSlots = x * y * z;
                            if (currentSlots < cargoSlots) continue;
                            double fitSize = Math.abs(1.0 - (double)x / xItemsIdeal) + Math.abs(1.0 - (double)y / yItemsIdeal) + Math.abs(1.0 - (double)z / zItemsIdeal);
                            double fitRatio = Math.max(xSize / (double)x, Math.max(ySize / (double)y, zSize / (double)z));
                            int fitItems = Math.abs(1 - currentSlots / cargoSlots);
                            double fit = fitSize + (double)fitItems + fitRatio;
                            if (!(fit < bestFit)) continue;
                            bestFit = fit;
                            xItems = x;
                            yItems = y;
                            zItems = z;
                        }
                    }
                }
                double xScale = xSize / (double)xItems;
                double yScale = ySize / (double)yItems;
                double zScale = zSize / (double)zItems;
                if (!comp.key.contains("STRETCHED")) {
                    yScale = zScale = Math.min(xScale, Math.min(yScale, zScale));
                    xScale = zScale;
                }
                Vec3d offset = comp.min.add((xSize - (double)xItems * xScale) / 2.0, 0.0, (zSize - (double)zItems * zScale) / 2.0);
                int renderSlot = 0;
                for (int i = slotOffset; i < Math.min(slotOffset + cargoSlots, stock.cargoItems.getSlotCount()); ++i) {
                    ItemStack stack = stock.cargoItems.get(i);
                    if (stack.isEmpty()) continue;
                    if (comp.key.contains("IRSIZE")) {
                        if (stack.is((CustomItem)IRItems.ITEM_ROLLING_STOCK)) {
                            ItemRollingStock.Data data = new ItemRollingStock.Data(stack);
                            Vec3d pos = new Vec3d(comp.center.x, comp.min.y, comp.center.z);
                            model.addCustom((s, pt) -> {
                                s.translate(pos);
                                s.scale(1.0 / stock.gauge.scale(), 1.0 / stock.gauge.scale(), 1.0 / stock.gauge.scale());
                                s.scale(data.gauge.scale(), data.gauge.scale(), data.gauge.scale());
                                try (OBJRender.Binding binder = data.def.getModel().binder().texture(data.texture).bind(s);){
                                    binder.draw(data.def.itemGroups);
                                }
                            });
                            ++renderSlot;
                            continue;
                        }
                        if (stack.is((CustomItem)IRItems.ITEM_ROLLING_STOCK_COMPONENT)) {
                            ItemRollingStockComponent.Data data = new ItemRollingStockComponent.Data(stack);
                            Vec3d pos = new Vec3d(comp.center.x, comp.min.y, comp.center.z);
                            ArrayList<String> groups = new ArrayList<String>();
                            for (ModelComponentType r : data.componentType.render) {
                                List<ModelComponent> mc = data.def.getComponents(r);
                                if (mc == null || r == ModelComponentType.CARGO_FILL_X || r == ModelComponentType.CARGO_FILL_POS_X) continue;
                                for (int j = 0; j < Math.min(mc.size(), stack.getCount()); ++j) {
                                    groups.addAll(mc.get((int)j).modelIDs);
                                }
                            }
                            model.addCustom((s, pt) -> {
                                s.translate(pos);
                                s.scale(1.0 / stock.gauge.scale(), 1.0 / stock.gauge.scale(), 1.0 / stock.gauge.scale());
                                s.scale(data.gauge.scale(), data.gauge.scale(), data.gauge.scale());
                                s.translate(0.0, -componentOffset, 0.0);
                                try (OBJRender.Binding binder = data.def.getModel().binder().texture(data.texture).bind(s);){
                                    binder.draw((Collection)groups);
                                }
                            });
                            ++renderSlot;
                            continue;
                        }
                    }
                    int z = renderSlot % zItems;
                    int x = renderSlot / zItems % xItems;
                    int y = renderSlot / zItems / xItems % yItems;
                    z = zItems / 2 + (z % 2 == 0 ? z / 2 : -(z + 1) / 2);
                    x = xItems / 2 + (x % 2 == 0 ? x / 2 : -(x + 1) / 2);
                    Matrix4 matrix = new Matrix4().translate(offset.x, offset.y, offset.z).scale(xScale, yScale, zScale).translate(0.5, 0.5, 0.5).translate((double)x, (double)y, (double)z);
                    if (stack.is((CustomItem)IRItems.ITEM_ROLLING_STOCK) || stack.is((CustomItem)IRItems.ITEM_ROLLING_STOCK_COMPONENT)) {
                        matrix.rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0);
                    }
                    if (stack.is(Fuzzy.LOG_WOOD)) {
                        matrix.rotate(Math.toRadians(90.0), 0.0, 0.0, 1.0);
                    }
                    model.addItem(stack, matrix);
                    ++renderSlot;
                }
                slotOffset += cargoSlots;
            }
            this.cache.put(stock.getUUID(), model);
        }
        model.render(state);
    }
}

