/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.world.WorldAnimationHandler;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LittleNeighborUpdatePacket
extends CreativeCorePacket {
    public UUID uuid;
    public List<BlockPos> positions;

    public LittleNeighborUpdatePacket(World world, List<BlockPos> positions) {
        this.positions = positions;
        if (world instanceof CreativeWorld) {
            this.uuid = ((CreativeWorld)world).parent.func_110124_au();
        }
    }

    public LittleNeighborUpdatePacket() {
    }

    public void writeBytes(ByteBuf buf) {
        buf.writeInt(this.positions.size());
        for (int i = 0; i < this.positions.size(); ++i) {
            LittleNeighborUpdatePacket.writePos((ByteBuf)buf, (BlockPos)this.positions.get(i));
        }
        if (this.uuid != null) {
            buf.writeBoolean(true);
            LittleNeighborUpdatePacket.writeString((ByteBuf)buf, (String)this.uuid.toString());
        } else {
            buf.writeBoolean(false);
        }
    }

    public void readBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.positions = new ArrayList<BlockPos>(size);
        for (int i = 0; i < size; ++i) {
            this.positions.add(LittleNeighborUpdatePacket.readPos((ByteBuf)buf));
        }
        this.uuid = buf.readBoolean() ? UUID.fromString(LittleNeighborUpdatePacket.readString((ByteBuf)buf)) : null;
    }

    public void executeClient(EntityPlayer player) {
        World world = player.field_70170_p;
        if (this.uuid != null) {
            EntityAnimation animation = WorldAnimationHandler.findAnimation(true, this.uuid);
            if (animation == null) {
                return;
            }
            world = animation.fakeWorld;
        }
        for (int i = 0; i < this.positions.size(); ++i) {
            BlockPos pos = this.positions.get(i);
            IBlockState state = world.func_180495_p(pos);
            if (!(state.func_177230_c() instanceof BlockTile)) continue;
            state.func_177230_c().func_189540_a(state, world, pos, state.func_177230_c(), null);
        }
    }

    public void executeServer(EntityPlayer player) {
    }
}

