/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.signal.input;

import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.signal.input.SignalInputVariable;
import com.creativemd.littletiles.common.structure.signal.logic.SignalLogicOperator;
import com.creativemd.littletiles.common.structure.signal.logic.SignalPatternParser;
import java.text.ParseException;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;

public abstract class SignalInputCondition {
    public static final float AND_DURATION = 0.1f;
    public static final float OR_DURATION = 0.01f;
    public static final float XOR_DURATION = 0.2f;
    public static final float BAND_DURATION = 0.2f;
    public static final float BOR_DURATION = 0.02f;
    public static final float BXOR_DURATION = 0.4f;
    public static final float NOT_DURATION = 0.01f;
    public static final float BNOT_DURATION = 0.02f;
    public static final float VARIABLE_DURATION = 0.01f;
    public static final float ADD_DURATION = 0.5f;
    public static final float SUB_DURATION = 0.5f;
    public static final float MUL_DURATION = 0.5f;
    public static final float DIV_DURATION = 5.0f;

    public static SignalInputCondition parseInput(String pattern) throws ParseException {
        SignalPatternParser parser = new SignalPatternParser(pattern);
        SignalInputCondition input = SignalInputCondition.tryParseNextCondition(parser, true, false, true);
        if (input != null && !parser.hasNext()) {
            return input;
        }
        return SignalInputCondition.parseExpression(new SignalPatternParser(pattern), new char[0], true, false);
    }

    public static SignalInputCondition parseNextCondition(SignalPatternParser parser, boolean includeBitwise, boolean insideVariable) throws ParseException {
        return SignalInputCondition.parseNextCondition(parser, includeBitwise, insideVariable, false);
    }

    public static SignalInputCondition parseNextCondition(SignalPatternParser parser, boolean includeBitwise, boolean insideVariable, boolean forceBitwise) throws ParseException {
        SignalInputCondition condition = SignalInputCondition.tryParseNextCondition(parser, includeBitwise, insideVariable, forceBitwise);
        if (condition == null) {
            throw parser.exception("Invalid signal pattern");
        }
        return condition;
    }

    public static SignalInputCondition tryParseNextCondition(SignalPatternParser parser, boolean includeBitwise, boolean insideVariable, boolean forceBitwise) throws ParseException {
        if (parser.hasNext()) {
            char next = parser.lookForNext(true);
            int type = Character.getType(next);
            if (next == '(') {
                parser.next(true);
                SignalInputCondition condition = SignalInputCondition.parseExpression(parser, new char[]{')'}, SignalLogicOperator.getHighest(includeBitwise), includeBitwise, insideVariable);
                parser.next(true);
                return condition;
            }
            if (next == '!') {
                parser.next(true);
                return new SignalInputConditionNot(SignalInputCondition.parseNextCondition(parser, includeBitwise, insideVariable, forceBitwise));
            }
            if (next == '~') {
                parser.next(true);
                return new SignalInputConditionNotBitwise(SignalInputCondition.parseNextCondition(parser, includeBitwise, insideVariable, forceBitwise));
            }
            if (next == 'v') {
                char current;
                parser.next(true);
                next = parser.next(true);
                if (next != '[') {
                    throw parser.invalidChar(next);
                }
                ArrayList<SignalInputCondition> array = new ArrayList<SignalInputCondition>();
                do {
                    if (parser.lookForNext(true) == ']') continue;
                    array.add(SignalInputCondition.parseExpression(parser, new char[]{',', ']'}, includeBitwise, insideVariable));
                } while ((current = parser.next(true)) == ',');
                if (current != ']') {
                    throw parser.exception("Invalid signal pattern");
                }
                return new SignalInputVirtualVariable(array.toArray(new SignalInputCondition[array.size()]));
            }
            if (next == 'n') {
                parser.next(true);
                return new SignalInputVirtualNumber(parser.parseNumber());
            }
            if (type == 2) {
                return SignalInputVariable.parseInput(parser, insideVariable, forceBitwise);
            }
            if (type == 1) {
                return SignalInputVariable.parseInput(parser, insideVariable, forceBitwise);
            }
            return null;
        }
        return null;
    }

    private static SignalInputCondition parseLowerExpression(SignalPatternParser parser, char[] until, SignalLogicOperator operator, boolean includeBitwise, boolean insideVariable) throws ParseException {
        if (operator.lower() != null) {
            return SignalInputCondition.parseExpression(parser, until, operator.lower(), includeBitwise, insideVariable);
        }
        return SignalInputCondition.parseNextCondition(parser, includeBitwise, insideVariable);
    }

    public static SignalInputCondition parseExpression(SignalPatternParser parser, char[] until, boolean includeBitwise, boolean insideVariable) throws ParseException {
        return SignalInputCondition.parseExpression(parser, until, SignalLogicOperator.getHighest(includeBitwise), includeBitwise, insideVariable);
    }

    public static SignalInputCondition parseExpression(SignalPatternParser parser, char[] until, SignalLogicOperator operator, boolean includeBitwise, boolean insideVariable) throws ParseException {
        SignalInputCondition first = SignalInputCondition.parseLowerExpression(parser, until, operator, includeBitwise, insideVariable);
        if (!parser.hasNext() || ArrayUtils.contains((char[])until, (char)parser.lookForNext(true))) {
            return first;
        }
        if (operator.goOn(parser)) {
            ArrayList<SignalInputCondition> conditions = new ArrayList<SignalInputCondition>();
            conditions.add(first);
            conditions.add(SignalInputCondition.parseLowerExpression(parser, until, operator, includeBitwise, insideVariable));
            while (operator.goOn(parser)) {
                conditions.add(SignalInputCondition.parseLowerExpression(parser, until, operator, includeBitwise, insideVariable));
            }
            return operator.create(conditions.toArray(new SignalInputCondition[conditions.size()]));
        }
        return first;
    }

    public abstract boolean[] test(LittleStructure var1, boolean var2);

    public abstract boolean testIndex(boolean[] var1);

    public abstract String write();

    public abstract float calculateDelay();

    public String toString() {
        return this.write();
    }

    public static class SignalInputVirtualVariable
    extends SignalInputCondition {
        public SignalInputCondition[] conditions;

        public SignalInputVirtualVariable(SignalInputCondition[] conditions) {
            this.conditions = conditions;
        }

        @Override
        public boolean[] test(LittleStructure structure, boolean forceBitwise) {
            boolean[] state = new boolean[this.conditions.length];
            for (int i = 0; i < state.length; ++i) {
                state[i] = BooleanUtils.any((boolean[])this.conditions[i].test(structure, false));
            }
            return state;
        }

        @Override
        public boolean testIndex(boolean[] state) {
            return false;
        }

        @Override
        public String write() {
            String result = "v[";
            for (int i = 0; i < this.conditions.length; ++i) {
                if (i > 0) {
                    result = result + ",";
                }
                result = result + this.conditions[i].write();
            }
            return result + "]";
        }

        @Override
        public float calculateDelay() {
            float delay = 0.1f * (float)this.conditions.length;
            for (int i = 0; i < this.conditions.length; ++i) {
                delay += this.conditions[i].calculateDelay();
            }
            return delay;
        }
    }

    public static class SignalInputVirtualNumber
    extends SignalInputCondition {
        public int number;

        public SignalInputVirtualNumber(int number) {
            this.number = number;
        }

        @Override
        public boolean[] test(LittleStructure structure, boolean forceBitwise) {
            return BooleanUtils.toBits((int)this.number, (int)Math.max(32, BooleanUtils.getRequiredBandwidth((int)this.number)));
        }

        @Override
        public boolean testIndex(boolean[] state) {
            return false;
        }

        @Override
        public String write() {
            return "n" + this.number;
        }

        @Override
        public float calculateDelay() {
            return 0.0f;
        }
    }

    public static class SignalInputConditionNot
    extends SignalInputConditionOperator {
        public SignalInputCondition condition;

        public SignalInputConditionNot(SignalInputCondition condition) {
            this.condition = condition;
        }

        @Override
        public boolean[] test(LittleStructure structure) {
            boolean[] state = BooleanUtils.copy((boolean[])this.condition.test(structure, false));
            for (int i = 0; i < state.length; ++i) {
                state[i] = !state[i];
            }
            return state;
        }

        @Override
        public boolean testIndex(boolean[] state) {
            return !this.condition.testIndex(state);
        }

        @Override
        public String write() {
            return "!(" + this.condition.write() + ")";
        }

        @Override
        public float calculateDelay() {
            return 0.01f + this.condition.calculateDelay();
        }
    }

    public static class SignalInputConditionNotBitwise
    extends SignalInputConditionOperator {
        public SignalInputCondition condition;

        public SignalInputConditionNotBitwise(SignalInputCondition condition) {
            this.condition = condition;
        }

        @Override
        public boolean[] test(LittleStructure structure) {
            boolean[] state = BooleanUtils.copy((boolean[])this.condition.test(structure, true));
            for (int i = 0; i < state.length; ++i) {
                state[i] = !state[i];
            }
            return state;
        }

        @Override
        public boolean testIndex(boolean[] state) {
            return !this.condition.testIndex(state);
        }

        @Override
        public String write() {
            return "~(" + this.condition.write() + ")";
        }

        @Override
        public float calculateDelay() {
            return 0.02f + this.condition.calculateDelay();
        }
    }

    public static abstract class SignalInputConditionOperator
    extends SignalInputCondition {
        @Override
        public boolean[] test(LittleStructure structure, boolean forceBitwise) {
            return this.test(structure);
        }

        public abstract boolean[] test(LittleStructure var1);
    }
}

