/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.signal.logic;

import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.signal.SignalUtils;
import com.creativemd.littletiles.common.structure.signal.component.ISignalComponent;
import com.creativemd.littletiles.common.structure.signal.logic.SignalPatternParser;
import java.text.ParseException;
import java.util.ArrayList;

public abstract class SignalTarget {
    public final int child;

    public static SignalTarget parseTarget(SignalPatternParser parser, boolean onlyOutputs, boolean insideVariable) throws ParseException {
        char begin = parser.next(true);
        if (begin == 'a' || begin == 'b' || begin == 'i' || begin == 'o') {
            boolean input;
            if (insideVariable) {
                throw parser.exception("Invalid usuage of variables in sub equation, only d<index> are allowed");
            }
            boolean external = begin == 'i' || begin == 'o';
            boolean bl = input = begin == 'a' || begin == 'i';
            if (onlyOutputs && input) {
                throw parser.exception("Input cannot be defined in output condition");
            }
            int child = parser.parseNumber();
            if (parser.hasNext() && parser.lookForNext(false) == '[') {
                parser.next(false);
                if (parser.lookForNext(true) == ']') {
                    return new SignalTargetChild(input, child, external);
                }
                SignalCustomIndex first = SignalTarget.parseIndex(parser);
                char next = parser.lookForNext(true);
                if (next == ']') {
                    parser.next(true);
                    if (first instanceof SignalCustomIndexSingle) {
                        return new SignalTargetChildIndex(input, child, external, ((SignalCustomIndexSingle)first).index);
                    }
                    return new SignalTargetChildIndexRange(input, child, external, ((SignalCustomIndexRange)first).index, ((SignalCustomIndexRange)first).length);
                }
                if (next == ',') {
                    ArrayList<SignalCustomIndex> indexes = new ArrayList<SignalCustomIndex>();
                    indexes.add(first);
                    while ((next = parser.next(true)) == ',') {
                        indexes.add(SignalTarget.parseIndex(parser));
                    }
                    if (next == ']') {
                        return new SignalTargetChildCustomIndex(input, child, external, indexes.toArray(new SignalCustomIndex[indexes.size()]));
                    }
                    throw parser.invalidChar(next);
                }
                throw parser.invalidChar(next);
            }
            return new SignalTargetChild(input, child, external);
        }
        if (begin == 'c') {
            int child = parser.parseNumber();
            if (parser.next(false) == '.') {
                return new SignalTargetNested(child, SignalTarget.parseTarget(parser, onlyOutputs, insideVariable));
            }
            throw parser.exception("Missing dot after child input");
        }
        if (begin == 'p') {
            if (parser.next(false) == '.') {
                return new SignalTargetParent(SignalTarget.parseTarget(parser, onlyOutputs, insideVariable));
            }
            throw parser.exception("Missing dot after child input");
        }
        if (begin == 'd') {
            if (!insideVariable) {
                throw parser.exception("Invalid usage of index variable");
            }
            return new SignalTargetIndex(parser.parseNumber());
        }
        throw parser.invalidChar(begin);
    }

    public static SignalCustomIndex parseIndex(SignalPatternParser parser) throws ParseException {
        int start = parser.parseNumber();
        if (parser.lookForNext(true) != '-') {
            return new SignalCustomIndexSingle(start);
        }
        parser.next(true);
        int end = parser.parseNumber();
        if (end <= start) {
            throw parser.exception("Invalid second index " + start + " < " + end);
        }
        return new SignalCustomIndexRange(start, end);
    }

    public SignalTarget(int child) {
        this.child = child;
    }

    public final boolean[] getState(LittleStructure structure) {
        try {
            return this.getState(this.getTarget(structure));
        }
        catch (CorruptedConnectionException | NotYetConnectedException e) {
            return BooleanUtils.asArray((boolean)false);
        }
    }

    protected boolean[] getState(ISignalComponent component) throws CorruptedConnectionException, NotYetConnectedException {
        if (component == null) {
            throw new NotYetConnectedException();
        }
        return component.getState();
    }

    public abstract ISignalComponent getTarget(LittleStructure var1);

    public abstract String writeBase();

    public abstract String write();

    public abstract boolean isIndexVariable();

    public int getBandwidth(LittleStructure structure) throws CorruptedConnectionException, NotYetConnectedException {
        ISignalComponent component = this.getTarget(structure);
        if (component != null) {
            return component.getBandwidth();
        }
        return 1;
    }

    public SignalTarget getNestedTarget() {
        return this;
    }

    public static class SignalCustomIndexRange
    extends SignalCustomIndex {
        public final int index;
        public final int length;

        public SignalCustomIndexRange(int index, int length) {
            this.index = index;
            this.length = length - index + 1;
        }

        @Override
        public int set(boolean[] toModify, int index, boolean[] value) {
            int added = 0;
            for (int i = 0; i < this.length && toModify.length > index + i; ++i) {
                toModify[index + i] = value[this.index + i];
                ++added;
            }
            return added;
        }

        @Override
        public String write() {
            return this.index + "-" + (this.index + this.length - 1);
        }

        @Override
        public int length() {
            return this.length;
        }
    }

    public static class SignalCustomIndexSingle
    extends SignalCustomIndex {
        public final int index;

        public SignalCustomIndexSingle(int index) {
            this.index = index;
        }

        @Override
        public int set(boolean[] toModify, int index, boolean[] value) {
            if (toModify.length <= index) {
                return 0;
            }
            toModify[index] = value[index];
            return 1;
        }

        @Override
        public String write() {
            return this.index + "";
        }

        @Override
        public int length() {
            return 1;
        }
    }

    public static abstract class SignalCustomIndex {
        public abstract String write();

        public abstract int length();

        public abstract int set(boolean[] var1, int var2, boolean[] var3);
    }

    public static class SignalTargetChildCustomIndex
    extends SignalTargetChild {
        public final SignalCustomIndex[] indexes;

        public SignalTargetChildCustomIndex(boolean input, int child, boolean external, SignalCustomIndex[] indexes) {
            super(input, child, external);
            this.indexes = indexes;
        }

        @Override
        protected boolean[] getState(ISignalComponent component) throws CorruptedConnectionException, NotYetConnectedException {
            boolean[] state = component.getState();
            boolean[] newState = new boolean[component.getBandwidth()];
            int index = 0;
            for (int i = 0; i < this.indexes.length; ++i) {
                index += this.indexes[i].set(newState, index, state);
            }
            return newState;
        }

        @Override
        public String write() {
            String result = super.write() + "[";
            for (int i = 0; i < this.indexes.length; ++i) {
                if (i > 0) {
                    result = result + ",";
                }
                result = result + this.indexes[i].write();
            }
            return result + "]";
        }

        @Override
        public int getBandwidth(LittleStructure structure) {
            int length = 0;
            for (int i = 0; i < this.indexes.length; ++i) {
                length += this.indexes[i].length();
            }
            return length;
        }
    }

    public static class SignalTargetChildIndexRange
    extends SignalTargetChild {
        public final int index;
        public final int length;

        public SignalTargetChildIndexRange(boolean input, int output, boolean external, int index, int length) {
            super(input, output, external);
            this.index = index;
            this.length = length;
        }

        @Override
        protected boolean[] getState(ISignalComponent component) throws CorruptedConnectionException, NotYetConnectedException {
            boolean[] state = component.getState();
            boolean[] newState = new boolean[this.length];
            for (int i = 0; i < newState.length; ++i) {
                if (state.length <= i + this.index) continue;
                newState[i] = state[this.index + 1];
            }
            return newState;
        }

        @Override
        public String write() {
            return super.write() + "[" + this.index + "-" + this.index + this.length + "]";
        }

        @Override
        public int getBandwidth(LittleStructure structure) {
            return this.length;
        }
    }

    public static class SignalTargetChildIndex
    extends SignalTargetChild {
        public final int index;

        public SignalTargetChildIndex(boolean input, int child, boolean external, int index) {
            super(input, child, external);
            this.index = index;
        }

        @Override
        protected boolean[] getState(ISignalComponent component) throws CorruptedConnectionException, NotYetConnectedException {
            boolean[] state = component.getState();
            if (state.length > this.index) {
                return BooleanUtils.asArray((boolean)state[this.index]);
            }
            return BooleanUtils.asArray((boolean)false);
        }

        @Override
        public String write() {
            return super.write() + "[" + this.index + "]";
        }

        @Override
        public int getBandwidth(LittleStructure structure) {
            return 1;
        }
    }

    public static class SignalTargetChild
    extends SignalTarget {
        public final boolean input;
        public final boolean external;

        public SignalTargetChild(boolean input, int child, boolean external) {
            super(child);
            this.input = input;
            this.external = external;
        }

        @Override
        public ISignalComponent getTarget(LittleStructure structure) {
            return this.input ? SignalUtils.getInput(structure, this.child, this.external) : SignalUtils.getOutput(structure, this.child, this.external);
        }

        @Override
        public String writeBase() {
            if (this.external) {
                return (this.input ? "i" : "o") + this.child;
            }
            return (this.input ? "a" : "b") + this.child;
        }

        @Override
        public String write() {
            if (this.external) {
                return (this.input ? "i" : "o") + this.child;
            }
            return (this.input ? "a" : "b") + this.child;
        }

        @Override
        public boolean isIndexVariable() {
            return false;
        }
    }

    public static class SignalTargetIndex
    extends SignalTarget {
        public SignalTargetIndex(int index) {
            super(index);
        }

        @Override
        public ISignalComponent getTarget(LittleStructure structure) {
            return null;
        }

        @Override
        public String writeBase() {
            return "d" + this.child;
        }

        @Override
        public String write() {
            return "d" + this.child;
        }

        @Override
        public boolean isIndexVariable() {
            return true;
        }
    }

    public static class SignalTargetParent
    extends SignalTarget {
        public final SignalTarget subTarget;

        public SignalTargetParent(SignalTarget subTarget) {
            super(-1);
            this.subTarget = subTarget;
        }

        @Override
        public ISignalComponent getTarget(LittleStructure structure) {
            if (structure.getParent() != null) {
                try {
                    return this.subTarget.getTarget(structure.getParent().getStructure());
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        protected boolean[] getState(ISignalComponent component) throws CorruptedConnectionException, NotYetConnectedException {
            return this.subTarget.getState(component);
        }

        @Override
        public String writeBase() {
            return "p." + this.subTarget.writeBase();
        }

        @Override
        public String write() {
            return "p." + this.subTarget.write();
        }

        @Override
        public boolean isIndexVariable() {
            return this.subTarget.isIndexVariable();
        }

        @Override
        public SignalTarget getNestedTarget() {
            return this.subTarget;
        }
    }

    public static class SignalTargetNested
    extends SignalTarget {
        public final SignalTarget subTarget;

        public SignalTargetNested(int child, SignalTarget subTarget) {
            super(child);
            this.subTarget = subTarget;
        }

        @Override
        protected boolean[] getState(ISignalComponent component) throws CorruptedConnectionException, NotYetConnectedException {
            return this.subTarget.getState(component);
        }

        @Override
        public ISignalComponent getTarget(LittleStructure structure) {
            if (this.child < structure.countChildren()) {
                try {
                    return this.subTarget.getTarget(structure.getChild(this.child).getStructure());
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public String writeBase() {
            return "c" + this.child + "." + this.subTarget.writeBase();
        }

        @Override
        public String write() {
            return "c" + this.child + "." + this.subTarget.write();
        }

        @Override
        public boolean isIndexVariable() {
            return this.subTarget.isIndexVariable();
        }

        @Override
        public SignalTarget getNestedTarget() {
            return this.subTarget;
        }
    }
}

