/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type.premade.signal;

import com.creativemd.creativecore.common.utils.math.VectorUtils;
import com.creativemd.creativecore.common.utils.math.box.AlignedBox;
import com.creativemd.creativecore.common.utils.math.box.BoxCorner;
import com.creativemd.creativecore.common.utils.math.box.BoxFace;
import com.creativemd.littletiles.common.structure.directional.StructureDirectional;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.relative.StructureRelative;
import com.creativemd.littletiles.common.structure.signal.output.InternalSignalOutput;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import java.nio.ByteBuffer;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class LittleSignalDisplay
extends LittleStructurePremade {
    public static final int renderDistance = 64;
    @StructureDirectional(color=0xFF0001)
    public StructureRelative frame;
    @StructureDirectional
    public EnumFacing facing;
    @StructureDirectional
    public Vector3f topRight;
    private int textureId = -1;

    public LittleSignalDisplay(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
    }

    @Override
    public void receiveInternalOutputChange(InternalSignalOutput output) {
        if (((LittleStructureType.InternalComponentOutput)output.component).is("pixels") && this.isClient()) {
            this.updateTexture();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateTexture() {
        if (this.textureId == -1) {
            this.textureId = GlStateManager.func_179146_y();
        }
        GlStateManager.func_179144_i((int)this.textureId);
        boolean[] state = this.getOutput(0).getState();
        ByteBuffer buffer = ByteBuffer.allocateDirect(state.length * 3);
        for (int i = 0; i < state.length; ++i) {
            if (state[i]) {
                buffer.put((byte)-1);
                buffer.put((byte)-1);
                buffer.put((byte)-1);
                continue;
            }
            buffer.put((byte)0);
            buffer.put((byte)0);
            buffer.put((byte)0);
        }
        buffer.rewind();
        GL11.glTexImage2D((int)3553, (int)0, (int)32853, (int)4, (int)4, (int)0, (int)6407, (int)5121, (ByteBuffer)buffer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderTick(BlockPos pos, double x, double y, double z, float partialTickTime) {
        if (this.textureId == -1) {
            this.updateTexture();
        }
        GlStateManager.func_179147_l();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179140_f();
        GlStateManager.func_179144_i((int)this.textureId);
        GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
        GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        AlignedBox box = this.frame.getBox().getCube(this.frame.getContext());
        BoxFace face = BoxFace.get((EnumFacing)this.facing);
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            box.setMax(this.facing.func_176740_k(), box.getMin(this.facing.func_176740_k()) + 0.01f);
        } else {
            box.setMin(this.facing.func_176740_k(), box.getMax(this.facing.func_176740_k()) - 0.01f);
        }
        EnumFacing.Axis uAxis = face.getTexUAxis();
        EnumFacing.Axis vAxis = face.getTexVAxis();
        GlStateManager.func_179091_B();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(9, DefaultVertexFormats.field_181707_g);
        for (BoxCorner corner : face.corners) {
            builder.func_181662_b((double)box.getValueOfFacing(corner.x), (double)box.getValueOfFacing(corner.y), (double)box.getValueOfFacing(corner.z)).func_187315_a(corner.isFacingPositive(uAxis) != VectorUtils.get((EnumFacing.Axis)uAxis, (Tuple3f)this.topRight) > 0.0f ? 1.0 : 0.0, corner.isFacingPositive(vAxis) != VectorUtils.get((EnumFacing.Axis)vAxis, (Tuple3f)this.topRight) > 0.0f ? 1.0 : 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return Math.pow(64.0, 2.0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return this.frame.getBox().getBox(this.frame.getContext());
    }

    @Override
    public void unload() {
        super.unload();
        if (this.getWorld().field_72995_K && this.textureId != -1) {
            GlStateManager.func_179150_h((int)this.textureId);
        }
    }
}

