/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.math.box;

import com.creativemd.creativecore.common.utils.math.RangedBitSet;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.AlignedBox;
import com.creativemd.creativecore.common.utils.math.box.BoxCorner;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.common.tile.combine.BasicCombiner;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxReturnedVolume;
import com.creativemd.littletiles.common.tile.math.box.LittleTransformableBox;
import com.creativemd.littletiles.common.tile.math.box.face.LittleBoxFace;
import com.creativemd.littletiles.common.tile.math.box.slice.LittleSlice;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.vec.SplitRangeBoxes;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleBox {
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;

    public LittleBox(LittleVec center, int sizeX, int sizeY, int sizeZ) {
        LittleVec offset = new LittleVec(sizeX, sizeY, sizeZ).calculateCenter();
        this.minX = center.x - offset.x;
        this.minY = center.y - offset.y;
        this.minZ = center.z - offset.z;
        this.maxX = this.minX + sizeX;
        this.maxY = this.minY + sizeY;
        this.maxZ = this.minZ + sizeZ;
    }

    public LittleBox(LittleGridContext context, AlignedBox cube) {
        this(context.toGrid(cube.minX), context.toGrid(cube.minY), context.toGrid(cube.minZ), context.toGrid(cube.maxX), context.toGrid(cube.maxY), context.toGrid(cube.maxZ));
    }

    public LittleBox(LittleGridContext context, AxisAlignedBB box) {
        this(context.toGrid(box.field_72340_a), context.toGrid(box.field_72338_b), context.toGrid(box.field_72339_c), context.toGrid(box.field_72336_d), context.toGrid(box.field_72337_e), context.toGrid(box.field_72334_f));
    }

    public LittleBox(LittleBox ... boxes) {
        this(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        for (int i = 0; i < boxes.length; ++i) {
            this.minX = Math.min(boxes[i].minX, this.minX);
            this.minY = Math.min(boxes[i].minY, this.minY);
            this.minZ = Math.min(boxes[i].minZ, this.minZ);
            this.maxX = Math.max(boxes[i].maxX, this.maxX);
            this.maxY = Math.max(boxes[i].maxY, this.maxY);
            this.maxZ = Math.max(boxes[i].maxZ, this.maxZ);
        }
    }

    public LittleBox(LittleVec min, LittleVec max) {
        this(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public LittleBox(LittleVec min) {
        this(min.x, min.y, min.z, min.x + 1, min.y + 1, min.z + 1);
    }

    public LittleBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.set(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void addCollisionBoxes(LittleGridContext context, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, BlockPos offset) {
        AxisAlignedBB axisalignedbb = this.getBox(context, offset);
        if (entityBox.func_72326_a(axisalignedbb)) {
            collidingBoxes.add(axisalignedbb);
        }
    }

    public AxisAlignedBB getSelectionBox(LittleGridContext context, BlockPos pos) {
        return this.getBox(context, pos);
    }

    public AxisAlignedBB getBox(LittleGridContext context, BlockPos offset) {
        return new AxisAlignedBB(context.toVanillaGrid(this.minX) + (double)offset.func_177958_n(), context.toVanillaGrid(this.minY) + (double)offset.func_177956_o(), context.toVanillaGrid(this.minZ) + (double)offset.func_177952_p(), context.toVanillaGrid(this.maxX) + (double)offset.func_177958_n(), context.toVanillaGrid(this.maxY) + (double)offset.func_177956_o(), context.toVanillaGrid(this.maxZ) + (double)offset.func_177952_p());
    }

    public AxisAlignedBB getBox(LittleGridContext context) {
        return new AxisAlignedBB(context.toVanillaGrid(this.minX), context.toVanillaGrid(this.minY), context.toVanillaGrid(this.minZ), context.toVanillaGrid(this.maxX), context.toVanillaGrid(this.maxY), context.toVanillaGrid(this.maxZ));
    }

    public AlignedBox getCube(LittleGridContext context) {
        return new AlignedBox((float)context.toVanillaGrid(this.minX), (float)context.toVanillaGrid(this.minY), (float)context.toVanillaGrid(this.minZ), (float)context.toVanillaGrid(this.maxX), (float)context.toVanillaGrid(this.maxY), (float)context.toVanillaGrid(this.maxZ));
    }

    public void changed() {
    }

    public int[] getArray() {
        return new int[]{this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ};
    }

    public NBTTagIntArray getNBTIntArray() {
        return new NBTTagIntArray(this.getArray());
    }

    public int getSmallestContext(LittleGridContext context) {
        int size = LittleGridContext.minSize;
        size = Math.max(size, context.getMinGrid(this.minX));
        size = Math.max(size, context.getMinGrid(this.minY));
        size = Math.max(size, context.getMinGrid(this.minZ));
        size = Math.max(size, context.getMinGrid(this.maxX));
        size = Math.max(size, context.getMinGrid(this.maxY));
        size = Math.max(size, context.getMinGrid(this.maxZ));
        return size;
    }

    protected void scale(int ratio) {
        this.minX *= ratio;
        this.minY *= ratio;
        this.minZ *= ratio;
        this.maxX *= ratio;
        this.maxY *= ratio;
        this.maxZ *= ratio;
    }

    protected void divide(int ratio) {
        this.minX /= ratio;
        this.minY /= ratio;
        this.minZ /= ratio;
        this.maxX /= ratio;
        this.maxY /= ratio;
        this.maxZ /= ratio;
    }

    public void convertTo(LittleGridContext from, LittleGridContext to) {
        if (from.size > to.size) {
            this.divide(from.size / to.size);
        } else {
            this.scale(to.size / from.size);
        }
    }

    public void convertTo(int from, int to) {
        if (from > to) {
            this.divide(from / to);
        } else {
            this.scale(to / from);
        }
    }

    public int getLongestSide() {
        return Math.max(this.maxX - this.minX, Math.max(this.maxY - this.minY, this.maxZ - this.minZ));
    }

    public LittleVec getSize() {
        return new LittleVec(this.maxX - this.minX, this.maxY - this.minY, this.maxZ - this.minZ);
    }

    public double getVolume() {
        return (this.maxX - this.minX) * (this.maxY - this.minY) * (this.maxZ - this.minZ);
    }

    public double getPercentVolume(LittleGridContext context) {
        return this.getVolume() / (double)context.maxTilesPerBlock;
    }

    public int get(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return this.maxX;
            }
            case WEST: {
                return this.minX;
            }
            case UP: {
                return this.maxY;
            }
            case DOWN: {
                return this.minY;
            }
            case SOUTH: {
                return this.maxZ;
            }
            case NORTH: {
                return this.minZ;
            }
        }
        return 0;
    }

    public LittleVec get(BoxCorner corner) {
        return new LittleVec(this.getX(corner), this.getY(corner), this.getZ(corner));
    }

    public int get(BoxCorner corner, EnumFacing.Axis axis) {
        return this.get(corner.getFacing(axis));
    }

    public int getX(BoxCorner corner) {
        return this.get(corner.x);
    }

    public int getY(BoxCorner corner) {
        return this.get(corner.y);
    }

    public int getZ(BoxCorner corner) {
        return this.get(corner.z);
    }

    public int getSize(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.maxX - this.minX;
            }
            case Y: {
                return this.maxY - this.minY;
            }
            case Z: {
                return this.maxZ - this.minZ;
            }
        }
        return 0;
    }

    public void setMin(EnumFacing.Axis axis, int value) {
        switch (axis) {
            case X: {
                this.minX = value;
                break;
            }
            case Y: {
                this.minY = value;
                break;
            }
            case Z: {
                this.minZ = value;
            }
        }
        this.changed();
    }

    public int getMin(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.minX;
            }
            case Y: {
                return this.minY;
            }
            case Z: {
                return this.minZ;
            }
        }
        return 0;
    }

    public void setMax(EnumFacing.Axis axis, int value) {
        switch (axis) {
            case X: {
                this.maxX = value;
                break;
            }
            case Y: {
                this.maxY = value;
                break;
            }
            case Z: {
                this.maxZ = value;
            }
        }
        this.changed();
    }

    public int getMax(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.maxX;
            }
            case Y: {
                return this.maxY;
            }
            case Z: {
                return this.maxZ;
            }
        }
        return 0;
    }

    public LittleVec[] getCorners() {
        LittleVec[] corners = new LittleVec[BoxCorner.values().length];
        for (int i = 0; i < corners.length; ++i) {
            BoxCorner corner = BoxCorner.values()[i];
            corners[i] = new LittleVec(this.get(corner.x), this.get(corner.y), this.get(corner.z));
        }
        return corners;
    }

    public boolean isValidBox() {
        return this.maxX > this.minX && this.maxY > this.minY && this.maxZ > this.minZ;
    }

    public boolean needsMultipleBlocks(LittleGridContext context) {
        int x = this.minX / context.size;
        int y = this.minY / context.size;
        int z = this.minZ / context.size;
        return this.maxX - x * context.size <= context.maxPos && this.maxY - y * context.size <= context.maxPos && this.maxZ - z * context.size <= context.maxPos;
    }

    public boolean isBoxInsideBlock(LittleGridContext context) {
        return this.minX >= 0 && this.maxX <= context.maxPos && this.minY >= 0 && this.maxY <= context.maxPos && this.minZ >= 0 && this.maxZ <= context.maxPos;
    }

    public void split(LittleGridContext context, BlockPos offset, HashMapList<BlockPos, LittleBox> boxes, @Nullable LittleBoxReturnedVolume volume) {
        int minOffX = context.toBlockOffset(this.minX);
        int minOffY = context.toBlockOffset(this.minY);
        int minOffZ = context.toBlockOffset(this.minZ);
        int maxOffX = context.toBlockOffset(this.maxX);
        int maxOffY = context.toBlockOffset(this.maxY);
        int maxOffZ = context.toBlockOffset(this.maxZ);
        for (int x = minOffX; x <= maxOffX; ++x) {
            for (int y = minOffY; y <= maxOffY; ++y) {
                for (int z = minOffZ; z <= maxOffZ; ++z) {
                    int minX = Math.max(this.minX, x * context.size);
                    int minY = Math.max(this.minY, y * context.size);
                    int minZ = Math.max(this.minZ, z * context.size);
                    int maxX = Math.min(this.maxX, x * context.size + context.size);
                    int maxY = Math.min(this.maxY, y * context.size + context.size);
                    int maxZ = Math.min(this.maxZ, z * context.size + context.size);
                    if (maxX <= minX || maxY <= minY || maxZ <= minZ) continue;
                    BlockPos pos = new BlockPos(x + offset.func_177958_n(), y + offset.func_177956_o(), z + offset.func_177952_p());
                    int offsetX = x * context.size;
                    int offsetY = y * context.size;
                    int offsetZ = z * context.size;
                    LittleBox box = this.extractBox(minX, minY, minZ, maxX, maxY, maxZ, volume);
                    if (box == null) continue;
                    box.sub(offsetX, offsetY, offsetZ);
                    boxes.add((Object)pos, (Object)box);
                }
            }
        }
    }

    public boolean doesFillEntireBlock(LittleGridContext context) {
        return this.minX == 0 && this.minY == 0 && this.minZ == 0 && this.maxX == context.size && this.maxY == context.size && this.maxZ == context.size;
    }

    public LittleBox createOutsideBlockBox(LittleGridContext context, EnumFacing facing) {
        LittleBox box = this.copy();
        switch (facing) {
            case EAST: {
                box.minX = 0;
                box.maxX -= context.size;
                break;
            }
            case WEST: {
                box.minX += context.size;
                box.maxX = context.size;
                break;
            }
            case UP: {
                box.minY = 0;
                box.maxY -= context.size;
                break;
            }
            case DOWN: {
                box.minY += context.size;
                box.maxY = context.size;
                break;
            }
            case SOUTH: {
                box.minZ = 0;
                box.maxZ -= context.size;
                break;
            }
            case NORTH: {
                box.minZ += context.size;
                box.maxZ = context.size;
            }
        }
        return box;
    }

    protected LittleBox combine(LittleBox box) {
        boolean z;
        boolean x = this.minX == box.minX && this.maxX == box.maxX;
        boolean y = this.minY == box.minY && this.maxY == box.maxY;
        boolean bl = z = this.minZ == box.minZ && this.maxZ == box.maxZ;
        if (x && y && z) {
            return this;
        }
        if (x && y) {
            if (this.minZ == box.maxZ) {
                return new LittleBox(this.minX, this.minY, box.minZ, this.maxX, this.maxY, this.maxZ);
            }
            if (this.maxZ == box.minZ) {
                return new LittleBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, box.maxZ);
            }
        }
        if (x && z) {
            if (this.minY == box.maxY) {
                return new LittleBox(this.minX, box.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
            }
            if (this.maxY == box.minY) {
                return new LittleBox(this.minX, this.minY, this.minZ, this.maxX, box.maxY, this.maxZ);
            }
        }
        if (y && z) {
            if (this.minX == box.maxX) {
                return new LittleBox(box.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
            }
            if (this.maxX == box.minX) {
                return new LittleBox(this.minX, this.minY, this.minZ, box.maxX, this.maxY, this.maxZ);
            }
        }
        return null;
    }

    public LittleBox combineBoxes(LittleBox box) {
        if (box.getClass() != LittleBox.class) {
            return null;
        }
        return this.combine(box);
    }

    @Nullable
    public EnumFacing sharedBoxFaceWithoutBounds(LittleBox box) {
        boolean z;
        boolean x = box.maxX > this.minX && box.minX < this.maxX;
        boolean y = box.maxY > this.minY && box.minY < this.maxY;
        boolean bl = z = box.maxZ > this.minZ && box.minZ < this.maxZ;
        if (this.minZ == box.maxZ) {
            if (x && y) {
                return EnumFacing.SOUTH;
            }
            return null;
        }
        if (this.maxZ == box.minZ) {
            if (x && y) {
                return EnumFacing.NORTH;
            }
            return null;
        }
        if (this.minY == box.maxY) {
            if (x && z) {
                return EnumFacing.UP;
            }
            return null;
        }
        if (this.maxY == box.minY) {
            if (x && z) {
                return EnumFacing.DOWN;
            }
            return null;
        }
        if (this.minX == box.maxX) {
            if (y && z) {
                return EnumFacing.EAST;
            }
            return null;
        }
        if (this.maxX == box.minX) {
            if (y && z) {
                return EnumFacing.WEST;
            }
            return null;
        }
        return null;
    }

    @Nullable
    public EnumFacing sharedBoxFace(LittleBox box) {
        boolean z;
        boolean x = this.minX == box.minX && this.maxX == box.maxX;
        boolean y = this.minY == box.minY && this.maxY == box.maxY;
        boolean bl = z = this.minZ == box.minZ && this.maxZ == box.maxZ;
        if (x && y && z) {
            return null;
        }
        if (x && y) {
            if (this.minZ == box.maxZ) {
                return EnumFacing.SOUTH;
            }
            if (this.maxZ == box.minZ) {
                return EnumFacing.NORTH;
            }
        }
        if (x && z) {
            if (this.minY == box.maxY) {
                return EnumFacing.UP;
            }
            if (this.maxY == box.minY) {
                return EnumFacing.DOWN;
            }
        }
        if (y && z) {
            if (this.minX == box.maxX) {
                return EnumFacing.EAST;
            }
            if (this.maxX == box.minX) {
                return EnumFacing.WEST;
            }
        }
        return null;
    }

    public SplitRangeBoxes split(List<LittleBox> boxes) {
        RangedBitSet x = this.split(EnumFacing.Axis.X, boxes);
        RangedBitSet y = this.split(EnumFacing.Axis.Y, boxes);
        RangedBitSet z = this.split(EnumFacing.Axis.Z, boxes);
        if (x != null && y != null && z != null) {
            return new SplitRangeBoxes(x, y, z);
        }
        return null;
    }

    protected RangedBitSet split(EnumFacing.Axis axis, List<LittleBox> boxes) {
        int min = this.getMin(axis);
        int max = this.getMax(axis);
        RangedBitSet set = new RangedBitSet(min, max);
        for (LittleBox box : boxes) {
            if (!box.isSolid()) {
                return null;
            }
            if (!box.intersectsWith(this)) continue;
            set.add(box.getMin(axis));
            set.add(box.getMax(axis));
        }
        return set;
    }

    public List<LittleBox> cutOut(List<LittleBox> boxes, List<LittleBox> cutout, @Nullable LittleBoxReturnedVolume volume) {
        ArrayList<LittleBox> newBoxes = new ArrayList<LittleBox>();
        if (boxes.isEmpty()) {
            newBoxes.add(this.copy());
            return newBoxes;
        }
        SplitRangeBoxes ranges = this.split(boxes);
        if (ranges != null) {
            for (SplitRangeBoxes.SplitRangeBox range : ranges) {
                LittleBox box = this.extractBox(range.x.min, range.y.min, range.z.min, range.x.max, range.y.max, range.z.max, volume);
                if (box == null) continue;
                boolean cutted = false;
                for (LittleBox cutBox : boxes) {
                    if (!cutBox.intersectsWith(box)) continue;
                    cutted = true;
                    break;
                }
                if (cutted) {
                    cutout.add(box);
                    continue;
                }
                newBoxes.add(box);
            }
        } else {
            int z;
            int y;
            int x;
            boolean[][][] filled = new boolean[this.getSize(EnumFacing.Axis.X)][this.getSize(EnumFacing.Axis.Y)][this.getSize(EnumFacing.Axis.Z)];
            for (LittleBox box : boxes) {
                box.fillInSpace(this, filled);
            }
            boolean expected = filled[0][0][0];
            boolean continuous = true;
            block3: for (x = 0; x < filled.length; ++x) {
                for (y = 0; y < filled[x].length; ++y) {
                    for (z = 0; z < filled[x][y].length; ++z) {
                        if (filled[x][y][z] == expected) continue;
                        continuous = false;
                        break block3;
                    }
                }
            }
            if (continuous) {
                if (expected) {
                    cutout.add(this.copy());
                    return new ArrayList<LittleBox>();
                }
                newBoxes.add(this.copy());
                return newBoxes;
            }
            for (x = 0; x < filled.length; ++x) {
                for (y = 0; y < filled[x].length; ++y) {
                    for (z = 0; z < filled[x][y].length; ++z) {
                        LittleBox box = this.extractBox(x + this.minX, y + this.minY, z + this.minZ, volume);
                        if (box == null) continue;
                        if (filled[x][y][z]) {
                            cutout.add(box);
                            continue;
                        }
                        newBoxes.add(box);
                    }
                }
            }
        }
        BasicCombiner.combineBoxes(newBoxes);
        BasicCombiner.combineBoxes(cutout);
        return newBoxes;
    }

    public List<LittleBox> cutOut(LittleBox box, LittleBoxReturnedVolume volume) {
        if (this.intersectsWith(box)) {
            ArrayList<LittleBox> boxes = new ArrayList<LittleBox>();
            if (box.isSolid()) {
                ArrayList<LittleBox> splitting = new ArrayList<LittleBox>();
                splitting.add(box);
                for (SplitRangeBoxes.SplitRangeBox range : this.split(splitting)) {
                    LittleBox tempBox = this.extractBox(range.x.min, range.y.min, range.z.min, range.x.max, range.y.max, range.z.max, volume);
                    boolean cutted = false;
                    if (tempBox == null) continue;
                    if (box.intersectsWith(tempBox)) {
                        cutted = true;
                        continue;
                    }
                    if (cutted) continue;
                    boxes.add(tempBox);
                }
                return boxes;
            }
            LittleBox testBox = new LittleBox(0, 0, 0, 0, 0, 0);
            LittleVec vec = new LittleVec(0, 0, 0);
            for (int x = this.minX; x < this.maxX; ++x) {
                for (int y = this.minY; y < this.maxY; ++y) {
                    for (int z = this.minZ; z < this.maxZ; ++z) {
                        testBox.set(x, y, z, x + 1, y + 1, z + 1);
                        if (this.intersectsWith(testBox)) continue;
                        boxes.add(this.extractBox(x, y, z, volume));
                    }
                }
            }
            BasicCombiner.combineBoxes(boxes);
            return boxes;
        }
        return null;
    }

    protected boolean intersectsWith(LittleBox box) {
        return box.maxX > this.minX && box.minX < this.maxX && box.maxY > this.minY && box.minY < this.maxY && box.maxZ > this.minZ && box.minZ < this.maxZ;
    }

    public boolean containsBox(LittleBox box) {
        return this.minX <= box.minX && this.maxX >= box.maxX && this.minY <= box.minY && this.maxY >= box.maxY && this.minZ <= box.minZ && this.maxZ >= box.maxZ;
    }

    public boolean fillInSpaceInaccurate(LittleBox otherBox, boolean[][][] filled) {
        boolean changed = false;
        if (this.isSolid()) {
            int minX = Math.max(this.minX, otherBox.minX);
            int maxX = Math.min(this.maxX, otherBox.maxX);
            int minY = Math.max(this.minY, otherBox.minY);
            int maxY = Math.min(this.maxY, otherBox.maxY);
            int minZ = Math.max(this.minZ, otherBox.minZ);
            int maxZ = Math.min(this.maxZ, otherBox.maxZ);
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        filled[x - otherBox.minX][y - otherBox.minY][z - otherBox.minZ] = true;
                        changed = true;
                    }
                }
            }
        }
        return changed;
    }

    public boolean fillInSpace(LittleBox otherBox, boolean[][][] filled) {
        boolean changed = false;
        int minX = Math.max(this.minX, otherBox.minX);
        int maxX = Math.min(this.maxX, otherBox.maxX);
        int minY = Math.max(this.minY, otherBox.minY);
        int maxY = Math.min(this.maxY, otherBox.maxY);
        int minZ = Math.max(this.minZ, otherBox.minZ);
        int maxZ = Math.min(this.maxZ, otherBox.maxZ);
        if (this.isSolid()) {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        filled[x - otherBox.minX][y - otherBox.minY][z - otherBox.minZ] = true;
                        changed = true;
                    }
                }
            }
        } else {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        LittleBox box = otherBox.extractBox(x, y, z, null);
                        if (box == null || !this.intersectsWith(box)) continue;
                        filled[x - otherBox.minX][y - otherBox.minY][z - otherBox.minZ] = true;
                        changed = true;
                    }
                }
            }
        }
        return changed;
    }

    public boolean isSolid() {
        return true;
    }

    public void add(int x, int y, int z) {
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
        this.changed();
    }

    public void add(LittleVec vec) {
        this.add(vec.x, vec.y, vec.z);
    }

    public void sub(int x, int y, int z) {
        this.minX -= x;
        this.minY -= y;
        this.minZ -= z;
        this.maxX -= x;
        this.maxY -= y;
        this.maxZ -= z;
        this.changed();
    }

    public void sub(LittleVec vec) {
        this.sub(vec.x, vec.y, vec.z);
    }

    public LittleVec getMinVec() {
        return new LittleVec(this.minX, this.minY, this.minZ);
    }

    public LittleVec getMaxVec() {
        return new LittleVec(this.maxX, this.maxY, this.maxZ);
    }

    public LittleVec getNearstedPointTo(LittleVec vec) {
        int x = this.minX;
        if (vec.x >= this.minX || vec.x <= this.maxX) {
            x = vec.x;
        }
        if (Math.abs(this.minX - x) > Math.abs(this.maxX - x)) {
            x = this.maxX;
        }
        int y = this.minY;
        if (vec.y >= this.minY || vec.y <= this.maxY) {
            y = vec.y;
        }
        if (Math.abs(this.minY - y) > Math.abs(this.maxY - y)) {
            y = this.maxY;
        }
        int z = this.minZ;
        if (vec.z >= this.minZ || vec.z <= this.maxZ) {
            z = vec.z;
        }
        if (Math.abs(this.minZ - z) > Math.abs(this.maxZ - z)) {
            z = this.maxZ;
        }
        return new LittleVec(x, y, z);
    }

    public LittleVec getNearstedPointTo(LittleBox box) {
        int x = 0;
        x = this.minX >= box.minX && this.minX <= box.maxX ? this.minX : (box.minX >= this.minX && box.minX <= box.maxX ? box.minX : (Math.abs(this.minX - box.maxX) > Math.abs(this.maxX - box.minX) ? this.maxX : this.minX));
        int y = 0;
        y = this.minY >= box.minY && this.minY <= box.maxY ? this.minY : (box.minY >= this.minY && box.minY <= box.maxY ? box.minY : (Math.abs(this.minY - box.maxY) > Math.abs(this.maxY - box.minY) ? this.maxY : this.minY));
        int z = 0;
        z = this.minZ >= box.minZ && this.minZ <= box.maxZ ? this.minZ : (box.minZ >= this.minZ && box.minZ <= box.maxZ ? box.minZ : (Math.abs(this.minZ - box.maxZ) > Math.abs(this.maxZ - box.minZ) ? this.maxZ : this.minZ));
        return new LittleVec(x, y, z);
    }

    public double distanceTo(LittleBox box) {
        return this.distanceTo(box.getNearstedPointTo(this));
    }

    public double distanceTo(LittleVec vec) {
        return this.getNearstedPointTo(vec).distanceTo(vec);
    }

    public boolean intersectsWithFace(EnumFacing facing, LittleVec vec) {
        EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)facing.func_176740_k());
        EnumFacing.Axis two = RotationUtils.getOne((EnumFacing.Axis)facing.func_176740_k());
        return vec.get(one) >= this.getMin(one) && vec.get(one) <= this.getMax(one) && vec.get(two) >= this.getMin(two) && vec.get(two) <= this.getMax(two);
    }

    public boolean intersectsWithAxis(LittleGridContext context, EnumFacing.Axis axis, Vec3d vec) {
        switch (axis) {
            case X: {
                return this.intersectsWithYZ(context, vec);
            }
            case Y: {
                return this.intersectsWithXZ(context, vec);
            }
            case Z: {
                return this.intersectsWithXY(context, vec);
            }
        }
        return false;
    }

    public boolean intersectsWithYZ(LittleGridContext context, Vec3d vec) {
        return vec.field_72448_b >= context.toVanillaGrid(this.minY) && vec.field_72448_b < context.toVanillaGrid(this.maxY) && vec.field_72449_c >= context.toVanillaGrid(this.minZ) && vec.field_72449_c < context.toVanillaGrid(this.maxZ);
    }

    public boolean intersectsWithXZ(LittleGridContext context, Vec3d vec) {
        return vec.field_72450_a >= context.toVanillaGrid(this.minX) && vec.field_72450_a < context.toVanillaGrid(this.maxX) && vec.field_72449_c >= context.toVanillaGrid(this.minZ) && vec.field_72449_c < context.toVanillaGrid(this.maxZ);
    }

    public boolean intersectsWithXY(LittleGridContext context, Vec3d vec) {
        return vec.field_72450_a >= context.toVanillaGrid(this.minX) && vec.field_72450_a < context.toVanillaGrid(this.maxX) && vec.field_72448_b >= context.toVanillaGrid(this.minY) && vec.field_72448_b < context.toVanillaGrid(this.maxY);
    }

    public boolean isVecInside(Vector3f vec) {
        return vec.x > (float)this.minX && vec.x < (float)this.maxX && vec.y > (float)this.minY && vec.y < (float)this.maxY && vec.z > (float)this.minZ && vec.z < (float)this.maxZ;
    }

    public LittleVec getCenter() {
        return new LittleVec((this.maxX + this.minX) / 2, (this.maxY + this.minY) / 2, (this.maxZ + this.minZ) / 2);
    }

    @Nullable
    protected Vec3d collideWithPlane(LittleGridContext context, EnumFacing.Axis axis, double value, Vec3d vecA, Vec3d vecB) {
        Vec3d vec3d = axis != EnumFacing.Axis.X ? (axis != EnumFacing.Axis.Y ? vecA.func_72434_d(vecB, value) : vecA.func_72435_c(vecB, value)) : vecA.func_72429_b(vecB, value);
        return vec3d != null && this.intersectsWithAxis(context, axis, vec3d) ? vec3d : null;
    }

    @Nullable
    public RayTraceResult calculateIntercept(LittleGridContext context, BlockPos pos, Vec3d vecA, Vec3d vecB) {
        vecA = vecA.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        vecB = vecB.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        Vec3d collision = null;
        EnumFacing collided = null;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            Vec3d temp = this.collideWithPlane(context, facing.func_176740_k(), (double)this.get(facing) / (double)context.size, vecA, vecB);
            if (temp == null || !LittleBox.isClosest(vecA, collision, temp)) continue;
            collided = facing;
            collision = temp;
        }
        if (collision == null) {
            return null;
        }
        return new RayTraceResult(collision.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), collided, pos);
    }

    public Vector3f[] getVecArray(BoxCorner[] corners) {
        Vector3f[] result = new Vector3f[corners.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new Vector3f((float)this.get(corners[i].x), (float)this.get(corners[i].y), (float)this.get(corners[i].z));
        }
        return result;
    }

    public boolean doesTouch(LittleGridContext own, LittleGridContext other, LittleBox box) {
        boolean z;
        LittleGridContext context = LittleGridContext.max(own, other);
        LittleBox thisBox = this;
        if (own != context) {
            thisBox = this.copy();
            thisBox.convertTo(own, context);
        }
        if (other != context) {
            box = box.copy();
            box.convertTo(other, context);
        }
        boolean x = box.maxX > thisBox.minX && box.minX < thisBox.maxX;
        boolean y = box.maxY > thisBox.minY && box.minY < thisBox.maxY;
        boolean bl = z = box.maxZ > thisBox.minZ && box.minZ < thisBox.maxZ;
        if (x && y && (thisBox.minZ == box.maxZ || box.minZ == thisBox.maxZ)) {
            return true;
        }
        if (x && z && (thisBox.minY == box.maxY || box.minY == thisBox.maxY)) {
            return true;
        }
        return y && z && (thisBox.minX == box.maxX || box.minX == thisBox.maxX);
    }

    public boolean doesTouch(LittleBox box) {
        boolean z;
        boolean x = box.maxX > this.minX && box.minX < this.maxX;
        boolean y = box.maxY > this.minY && box.minY < this.maxY;
        boolean bl = z = box.maxZ > this.minZ && box.minZ < this.maxZ;
        if (x && y && (this.minZ == box.maxZ || box.minZ == this.maxZ)) {
            return true;
        }
        if (x && z && (this.minY == box.maxY || box.minY == this.maxY)) {
            return true;
        }
        return y && z && (this.minX == box.maxX || box.minX == this.maxX);
    }

    public void rotateBox(Rotation rotation, LittleVec doubledCenter) {
        long tempMinX = this.minX * 2 - doubledCenter.x;
        long tempMinY = this.minY * 2 - doubledCenter.y;
        long tempMinZ = this.minZ * 2 - doubledCenter.z;
        long tempMaxX = this.maxX * 2 - doubledCenter.x;
        long tempMaxY = this.maxY * 2 - doubledCenter.y;
        long tempMaxZ = this.maxZ * 2 - doubledCenter.z;
        this.resort((int)((rotation.getMatrix().getX(tempMinX, tempMinY, tempMinZ) + (long)doubledCenter.x) / 2L), (int)((rotation.getMatrix().getY(tempMinX, tempMinY, tempMinZ) + (long)doubledCenter.y) / 2L), (int)((rotation.getMatrix().getZ(tempMinX, tempMinY, tempMinZ) + (long)doubledCenter.z) / 2L), (int)((rotation.getMatrix().getX(tempMaxX, tempMaxY, tempMaxZ) + (long)doubledCenter.x) / 2L), (int)((rotation.getMatrix().getY(tempMaxX, tempMaxY, tempMaxZ) + (long)doubledCenter.y) / 2L), (int)((rotation.getMatrix().getZ(tempMaxX, tempMaxY, tempMaxZ) + (long)doubledCenter.z) / 2L));
        this.changed();
    }

    public void flipBox(EnumFacing.Axis axis, LittleVec doubledCenter) {
        long tempMin = this.getMin(axis) * 2 - doubledCenter.get(axis);
        long tempMax = this.getMax(axis) * 2 - doubledCenter.get(axis);
        int min = (int)(((long)doubledCenter.get(axis) - tempMin) / 2L);
        int max = (int)(((long)doubledCenter.get(axis) - tempMax) / 2L);
        this.setMin(axis, Math.min(min, max));
        this.setMax(axis, Math.max(min, max));
        this.changed();
    }

    public int hashCode() {
        return this.minX + this.minY + this.minZ + this.maxX + this.maxY + this.maxZ;
    }

    public boolean equals(Object object) {
        if (object instanceof LittleBox) {
            return object.getClass() == this.getClass() && this.minX == ((LittleBox)object).minX && this.minY == ((LittleBox)object).minY && this.minZ == ((LittleBox)object).minZ && this.maxX == ((LittleBox)object).maxX && this.maxY == ((LittleBox)object).maxY && this.maxZ == ((LittleBox)object).maxZ;
        }
        return super.equals(object);
    }

    public String toString() {
        return "[" + this.minX + "," + this.minY + "," + this.minZ + " -> " + this.maxX + "," + this.maxY + "," + this.maxZ + "]";
    }

    public LittleBox extractBox(int x, int y, int z, @Nullable LittleBoxReturnedVolume volume) {
        return new LittleBox(x, y, z, x + 1, y + 1, z + 1);
    }

    public LittleBox extractBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, @Nullable LittleBoxReturnedVolume volume) {
        return new LittleBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public LittleBox copy() {
        return new LittleBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public boolean isFaceAtEdge(LittleGridContext context, EnumFacing facing) {
        if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            return this.getMax(facing.func_176740_k()) == context.size;
        }
        return this.getMin(facing.func_176740_k()) == 0;
    }

    public void growCentered(int size) {
        int invSize = size / 2;
        this.minX -= invSize;
        this.minY -= invSize;
        this.minZ -= invSize;
        this.maxX += (size -= invSize);
        this.maxY += size;
        this.maxZ += size;
    }

    public void growToInclude(LittleBox box) {
        this.minX = Math.min(this.minX, box.minX);
        this.minY = Math.min(this.minY, box.minY);
        this.minZ = Math.min(this.minZ, box.minZ);
        this.maxX = Math.max(this.maxX, box.maxX);
        this.maxY = Math.max(this.maxY, box.maxY);
        this.maxZ = Math.max(this.maxZ, box.maxZ);
    }

    public LittleBox grow(EnumFacing facing) {
        EnumFacing.Axis axis = facing.func_176740_k();
        LittleBox result = this.copy();
        if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            result.setMax(axis, this.getMax(axis) + 1);
        } else {
            result.setMin(axis, this.getMin(axis) - 1);
        }
        return result;
    }

    public LittleBox shrink(EnumFacing facing, boolean toLimit) {
        EnumFacing.Axis axis = facing.func_176740_k();
        if (this.getSize(axis) > 1) {
            LittleBox result = this.copy();
            if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
                result.setMax(axis, toLimit ? this.getMin(axis) + 1 : this.getMax(axis) - 1);
            } else {
                result.setMin(axis, toLimit ? this.getMax(axis) - 1 : this.getMin(axis) + 1);
            }
            return result;
        }
        return null;
    }

    public void resort() {
        this.set(Math.min(this.minX, this.maxX), Math.min(this.minY, this.maxY), Math.min(this.minZ, this.maxZ), Math.max(this.minX, this.maxX), Math.max(this.minY, this.maxY), Math.max(this.minZ, this.maxZ));
    }

    public void resort(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.set(Math.min(minX, maxX), Math.min(minY, maxY), Math.min(minZ, maxZ), Math.max(minX, maxX), Math.max(minY, maxY), Math.max(minZ, maxZ));
    }

    public void set(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    @SideOnly(value=Side.CLIENT)
    public LittleRenderBox getRenderingCube(LittleGridContext context, Block block, int meta) {
        return this.getRenderingCube(context, this.getCube(context), block, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public LittleRenderBox getRenderingCube(LittleGridContext context, AlignedBox cube, Block block, int meta) {
        return new LittleRenderBox(cube, this, block, meta);
    }

    @Nullable
    public LittleBoxFace generateFace(LittleGridContext context, EnumFacing facing) {
        EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)facing.func_176740_k());
        EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)facing.func_176740_k());
        return new LittleBoxFace(this, null, null, context, facing, this.getMin(one), this.getMin(two), this.getMax(one), this.getMax(two), facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? this.getMax(facing.func_176740_k()) : this.getMin(facing.func_176740_k()));
    }

    public boolean intersectsWith(LittleBoxFace face) {
        return (face.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? this.getMin(face.facing.func_176740_k()) : this.getMax(face.facing.func_176740_k())) == face.origin && face.maxOne > this.getMin(face.one) && face.minOne < this.getMax(face.one) && face.maxTwo > this.getMin(face.two) && face.minTwo < this.getMax(face.two);
    }

    public boolean isFaceSolid(EnumFacing facing) {
        return true;
    }

    public boolean canFaceBeCombined(LittleBox other) {
        return true;
    }

    public void fill(LittleBoxFace face) {
        if (this.intersectsWith(face)) {
            int minOne = Math.max(this.getMin(face.one), face.minOne);
            int maxOne = Math.min(this.getMax(face.one), face.maxOne);
            int minTwo = Math.max(this.getMin(face.two), face.minTwo);
            int maxTwo = Math.min(this.getMax(face.two), face.maxTwo);
            if (this.isFaceSolid(face.facing.func_176734_d())) {
                for (int one = minOne; one < maxOne; ++one) {
                    for (int two = minTwo; two < maxTwo; ++two) {
                        face.filled[one - face.minOne][two - face.minTwo] = true;
                    }
                }
            } else {
                this.fillAdvanced(face);
            }
        }
    }

    protected void fillAdvanced(LittleBoxFace face) {
    }

    public static LittleBox loadBox(String name, NBTTagCompound nbt) {
        if (nbt.func_74781_a(name + "minX") instanceof NBTTagByte) {
            LittleBox box = new LittleBox(nbt.func_74771_c(name + "minX"), nbt.func_74771_c(name + "minY"), nbt.func_74771_c(name + "minZ"), nbt.func_74771_c(name + "maxX"), nbt.func_74771_c(name + "maxY"), nbt.func_74771_c(name + "maxZ"));
            nbt.func_82580_o(name + "minX");
            nbt.func_82580_o(name + "minY");
            nbt.func_82580_o(name + "minZ");
            nbt.func_82580_o(name + "maxX");
            nbt.func_82580_o(name + "maxY");
            nbt.func_82580_o(name + "maxZ");
            nbt.func_74782_a(name, (NBTBase)box.getNBTIntArray());
            return box;
        }
        if (nbt.func_74781_a(name + "minX") instanceof NBTTagInt) {
            LittleBox box = new LittleBox(nbt.func_74762_e(name + "minX"), nbt.func_74762_e(name + "minY"), nbt.func_74762_e(name + "minZ"), nbt.func_74762_e(name + "maxX"), nbt.func_74762_e(name + "maxY"), nbt.func_74762_e(name + "maxZ"));
            nbt.func_82580_o(name + "minX");
            nbt.func_82580_o(name + "minY");
            nbt.func_82580_o(name + "minZ");
            nbt.func_82580_o(name + "maxX");
            nbt.func_82580_o(name + "maxY");
            nbt.func_82580_o(name + "maxZ");
            nbt.func_74782_a(name, (NBTBase)box.getNBTIntArray());
            return box;
        }
        if (nbt.func_74781_a(name) instanceof NBTTagIntArray) {
            return LittleBox.createBox(nbt.func_74759_k(name));
        }
        if (nbt.func_74781_a(name) instanceof NBTTagString) {
            String[] coords = nbt.func_74779_i(name).split("\\.");
            try {
                return new LittleBox(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]), Integer.parseInt(coords[3]), Integer.parseInt(coords[4]), Integer.parseInt(coords[5]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new LittleBox(0, 0, 0, 0, 0, 0);
    }

    public static LittleBox createBox(int[] array) {
        if (array.length == 6) {
            return new LittleBox(array[0], array[1], array[2], array[3], array[4], array[5]);
        }
        if (array.length < 6) {
            throw new InvalidParameterException("No valid box given " + Arrays.toString(array));
        }
        int identifier = array[6];
        if (identifier < 0) {
            return new LittleTransformableBox(array);
        }
        LittleSlice slice = LittleSlice.getSliceByID(array[6]);
        if (array.length == 7) {
            return new LittleTransformableBox(array[0], array[1], array[2], array[3], array[4], array[5], slice);
        }
        if (array.length == 11) {
            return new LittleTransformableBox(array[0], array[1], array[2], array[3], array[4], array[5], LittleSlice.getSliceByID(array[6]), Float.intBitsToFloat(array[7]), Float.intBitsToFloat(array[8]), Float.intBitsToFloat(array[9]), Float.intBitsToFloat(array[10]));
        }
        throw new InvalidParameterException("No valid box given " + Arrays.toString(array));
    }

    public static boolean isClosest(Vec3d from, @Nullable Vec3d optional, Vec3d toCheck) {
        return optional == null || from.func_72436_e(toCheck) < from.func_72436_e(optional);
    }

    public static boolean intersectsWith(LittleBox box, LittleBox box2) {
        if (box.getClass() == LittleBox.class) {
            return box2.intersectsWith(box);
        }
        return box.intersectsWith(box2);
    }
}

