/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte;

import jp.ngt.mcte.CommonProxy;
import jp.ngt.mcte.MCTE;
import jp.ngt.mcte.MCTEKeyHandlerClient;
import jp.ngt.mcte.block.BlockMinesweeper;
import jp.ngt.mcte.block.RenderMiniature;
import jp.ngt.mcte.block.TileEntityMiniature;
import jp.ngt.mcte.editor.EntityEditor;
import jp.ngt.mcte.editor.RenderEditor;
import jp.ngt.mcte.editor.filter.FilterManager;
import jp.ngt.mcte.item.RenderItemMiniature;
import jp.ngt.ngtlib.item.IItemRendererCustom;
import jp.ngt.ngtlib.item.ItemRenderHandler;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.ngtlib.util.PackInfo;
import jp.ngt.ngtlib.util.VersionChecker;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        VersionChecker.addToCheckList((PackInfo)new PackInfo(MCTE.metadata.name, MCTE.metadata.url, MCTE.metadata.updateUrl, MCTE.metadata.version));
        NGTUtilClient.registerEntityRender(EntityEditor.class, RenderEditor.class);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMiniature.class, (TileEntitySpecialRenderer)RenderMiniature.INSTANCE);
        String domain = "mcte";
        for (BlockMinesweeper.MinesweeperType type : BlockMinesweeper.MinesweeperType.values()) {
            String typeNameLC = type.toString().toLowerCase();
            NGTUtilClient.registerItemModel((Block)MCTE.minesweeper, (int)type.id, (String)domain, (String)("minesweeper_" + typeNameLC));
        }
        this.registerModel(Item.func_150898_a((Block)MCTE.portIn), 0, "port_in");
        this.registerModel(Item.func_150898_a((Block)MCTE.portOut), 0, "port_out");
        this.registerModel(MCTE.editor, 0, "editor");
        this.registerModel(MCTE.generator, 0, "generator");
        this.registerModel(MCTE.painter, 0, "painter");
        this.registerModel(MCTE.itemMiniature, 0, "item_miniature");
        NGTUtilClient.registerBuildinModel((Block)MCTE.miniature, (boolean)true);
        MCTEKeyHandlerClient.init();
    }

    @Override
    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)new MCTEKeyHandlerClient());
        MinecraftForge.EVENT_BUS.register((Object)RenderItemMiniature.INSTANCE);
        ItemRenderHandler.INSTANCE.register(MCTE.itemMiniature, (IItemRendererCustom)RenderItemMiniature.INSTANCE);
        FilterManager.INSTANCE.loadFilters();
    }

    private void registerModel(Item item, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("mcte:" + name, "inventory"));
    }
}

