/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte;

import jp.ngt.mcte.MCTE;
import jp.ngt.mcte.block.RenderMiniature;
import jp.ngt.mcte.editor.Editor;
import jp.ngt.mcte.editor.EditorManager;
import jp.ngt.mcte.world.MCTETeleporter;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.util.NGTUtil;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Teleporter;

public class CommandMCTE
extends CommandBase {
    public int func_82362_a() {
        return 0;
    }

    public String func_71517_b() {
        return "mcte";
    }

    public String func_71518_a(ICommandSender par1) {
        return "commands.mcte.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] strings) throws CommandException {
        if (strings.length >= 1) {
            if (strings[0].equals("clear")) {
                EditorManager.INSTANCE.removeAll();
                return;
            }
            if (strings[0].equals("minesweeper")) {
                this.createMinesweeper(sender, strings);
                return;
            }
            if (strings[0].equals("tp")) {
                this.teleport(sender, strings);
                return;
            }
            if (strings[0].equals("clr_m") && !NGTUtil.isSMP()) {
                RenderMiniature.INSTANCE.clear();
            }
        }
        this.help(sender);
    }

    private void help(ICommandSender sender) {
        NGTLog.sendChatMessage((ICommandSender)sender, (String)"/mcte clear : Clear all editors", (Object[])new Object[0]);
        NGTLog.sendChatMessage((ICommandSender)sender, (String)"/mcte minesweeper [difficulty(1~9)]", (Object[])new Object[0]);
        NGTLog.sendChatMessage((ICommandSender)sender, (String)"/mcte tp", (Object[])new Object[0]);
    }

    private void createMinesweeper(ICommandSender sender, String[] strings) {
        EntityPlayerMP player;
        try {
            player = CommandMCTE.func_71521_c((ICommandSender)sender);
        }
        catch (PlayerNotFoundException e1) {
            e1.printStackTrace();
            return;
        }
        Editor editor = EditorManager.INSTANCE.getEditor((EntityPlayer)player);
        if (editor == null) {
            NGTLog.sendChatMessage((ICommandSender)player, (String)"Please Select Range", (Object[])new Object[0]);
            return;
        }
        int difficulty = 1;
        if (strings.length == 2) {
            try {
                difficulty = Integer.parseInt(strings[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (difficulty <= 0) {
                NGTLog.sendChatMessage((ICommandSender)player, (String)"Illegal number", (Object[])new Object[0]);
                difficulty = 1;
            }
        } else {
            switch (player.func_130014_f_().func_175659_aa()) {
                case PEACEFUL: {
                    difficulty = 9;
                }
                case EASY: {
                    difficulty = 8;
                }
                case NORMAL: {
                    difficulty = 7;
                }
                case HARD: {
                    difficulty = 6;
                }
            }
        }
        editor.editBlocks((byte)9, difficulty);
    }

    private void teleport(ICommandSender sender, String[] strings) {
        try {
            EntityPlayerMP player = CommandMCTE.func_71521_c((ICommandSender)sender);
            player.field_71088_bW = 5;
            int dimId = MCTE.MEGA_CITY.func_186068_a();
            if (player.field_70170_p.field_73011_w.func_186058_p().func_186068_a() == dimId) {
                dimId = 0;
            }
            player.field_71133_b.func_184103_al().transferPlayerToDimension(player, dimId, (Teleporter)new MCTETeleporter(player.field_71133_b.func_71218_a(dimId)));
        }
        catch (PlayerNotFoundException e1) {
            e1.printStackTrace();
            return;
        }
    }
}

