/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.block;

import jp.ngt.mcte.block.TileEntityMinesweeper;
import jp.ngt.ngtlib.block.BlockArgHolder;
import jp.ngt.ngtlib.block.BlockContainerCustom;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class BlockMinesweeper
extends BlockContainerCustom {
    public static final PropertyEnum<MinesweeperType> TYPE = PropertyEnum.func_177706_a((String)"type", MinesweeperType.class, (Enum[])MinesweeperType.values());

    public BlockMinesweeper() {
        super(Material.field_151576_e);
        this.func_149711_c(0.0f);
    }

    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)MinesweeperType.getType(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((MinesweeperType)((Object)state.func_177229_b(BlockMinesweeper.TYPE))).id;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public float func_176195_g(IBlockState blockState, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return ((MinesweeperType)((Object)state.func_177229_b(BlockMinesweeper.TYPE))).isBreakable ? 0.1f : 10.0f;
    }

    public TileEntity func_149915_a(World world, int par2) {
        return new TileEntityMinesweeper();
    }

    public boolean onBlockActivated(BlockArgHolder holder, float hitX, float hitY, float hitZ) {
        World world = holder.getWorld();
        BlockPos pos = holder.getBlockPos();
        MinesweeperType type = (MinesweeperType)((Object)holder.getBlockState().func_177229_b(TYPE));
        if (!world.field_72995_K) {
            if (type == MinesweeperType.NONE) {
                this.setMinesweeper(world, pos, MinesweeperType.NONE_FLAG);
            } else if (type == MinesweeperType.MINE) {
                this.setMinesweeper(world, pos, MinesweeperType.MINE_FLAG);
            } else if (type == MinesweeperType.NONE_FLAG) {
                this.setMinesweeper(world, pos, MinesweeperType.NONE);
            } else if (type == MinesweeperType.MINE_FLAG) {
                this.setMinesweeper(world, pos, MinesweeperType.MINE);
            }
            TileEntityMinesweeper tile2 = (TileEntityMinesweeper)world.func_175625_s(pos);
            tile2.check();
        }
        return true;
    }

    public boolean removedByPlayer(BlockArgHolder holder, boolean willHarvest) {
        World world = holder.getWorld();
        BlockPos pos = holder.getBlockPos();
        if (!world.field_72995_K) {
            MinesweeperType type = (MinesweeperType)((Object)world.func_180495_p(pos).func_177229_b(TYPE));
            if (type == MinesweeperType.NONE) {
                this.open(world, pos, true);
            } else if (type == MinesweeperType.MINE) {
                world.func_72885_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 4.0f, true, world.func_82736_K().func_82766_b("mobGriefing"));
            } else {
                this.setMinesweeper(world, pos, type);
            }
        }
        return true;
    }

    private void open(World world, BlockPos pos, boolean byPlayer) {
        MinesweeperType type;
        int j;
        int i;
        int bombCount = 0;
        for (i = -1; i < 2; ++i) {
            for (j = -1; j < 2; ++j) {
                type = (MinesweeperType)((Object)world.func_180495_p(pos.func_177982_a(i, 0, j)).func_177229_b(TYPE));
                if (world.func_180495_p(pos.func_177982_a(i, 0, j)).func_177230_c() != this || type != MinesweeperType.MINE && type != MinesweeperType.MINE_FLAG) continue;
                ++bombCount;
            }
        }
        if (bombCount > 0) {
            this.setMinesweeper(world, pos, MinesweeperType.getType(bombCount));
        } else {
            this.setMinesweeper(world, pos, MinesweeperType.NUM0);
            for (i = -1; i < 2; ++i) {
                for (j = -1; j < 2; ++j) {
                    type = (MinesweeperType)((Object)world.func_180495_p(pos.func_177982_a(i, 0, j)).func_177229_b(TYPE));
                    if (world.func_180495_p(pos.func_177982_a(i, 0, j)).func_177230_c() != this || type != MinesweeperType.NONE) continue;
                    this.open(world, pos.func_177982_a(i, 0, j), false);
                }
            }
        }
    }

    private void setMinesweeper(World world, BlockPos pos, MinesweeperType type) {
        TileEntityMinesweeper tile = (TileEntityMinesweeper)world.func_175625_s(pos);
        NBTTagCompound nbt = new NBTTagCompound();
        tile.func_189515_b(nbt);
        world.func_180501_a(pos, this.func_176203_a(type.id), 3);
        TileEntityMinesweeper tile2 = (TileEntityMinesweeper)world.func_175625_s(pos);
        tile2.func_145839_a(nbt);
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        MinesweeperType type;
        boolean flag = false;
        if (!(world.field_72995_K || (type = (MinesweeperType)((Object)world.func_180495_p(pos).func_177229_b(TYPE))) != MinesweeperType.MINE && type != MinesweeperType.MINE_FLAG)) {
            flag = true;
        }
        super.onBlockExploded(world, pos, explosion);
        if (flag) {
            world.func_72885_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 4.0f, true, world.func_82736_K().func_82766_b("mobGriefing"));
        }
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public static enum MinesweeperType implements IStringSerializable
    {
        NUM0(0, false),
        NUM1(1, false),
        NUM2(2, false),
        NUM3(3, false),
        NUM4(4, false),
        NUM5(5, false),
        NUM6(6, false),
        NUM7(7, false),
        NUM8(8, false),
        N(9, false),
        NONE(10, true),
        MINE(11, true),
        NONE_FLAG(12, false),
        MINE_FLAG(13, false);

        public final byte id;
        public final boolean isBreakable;

        private MinesweeperType(int p1, boolean p2) {
            this.id = (byte)p1;
            this.isBreakable = p2;
        }

        public static MinesweeperType getType(int meta) {
            return MinesweeperType.values()[meta];
        }

        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }
}

