/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.block;

import java.util.ArrayList;
import java.util.List;
import jp.ngt.mcte.MCTE;
import jp.ngt.mcte.block.BlockMiniature;
import jp.ngt.mcte.block.BlockPort;
import jp.ngt.mcte.block.TileEntityMiniature;
import jp.ngt.mcte.world.MCTEWorld;
import jp.ngt.ngtlib.block.BlockSet;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.block.NGTObject;
import jp.ngt.ngtlib.math.NGTMath;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RSPortSet {
    private List<PortObj>[] ports;

    private void initPort(MCTEWorld world) {
        this.ports = new List[4];
        for (int i = 0; i < this.ports.length; ++i) {
            this.ports[i] = new ArrayList<PortObj>();
        }
        NGTObject ngto = world.blockObject;
        for (int x = 0; x < ngto.xSize; ++x) {
            for (int y = 0; y < ngto.ySize; ++y) {
                for (int z = 0; z < ngto.zSize; ++z) {
                    BlockSet set = world.getBlockSet(x, y, z);
                    if (!(set.block instanceof BlockPort)) continue;
                    PortType type = ((BlockPort)set.block).type;
                    if (z == 0) {
                        this.ports[2].add(new PortObj(type, x, y, z, ngto.xSize - 1 - x, y));
                        continue;
                    }
                    if (z == ngto.zSize - 1) {
                        this.ports[0].add(new PortObj(type, x, y, z, x, y));
                        continue;
                    }
                    if (x == 0) {
                        this.ports[1].add(new PortObj(type, x, y, z, z, y));
                        continue;
                    }
                    if (x != ngto.xSize - 1) continue;
                    this.ports[3].add(new PortObj(type, x, y, z, ngto.zSize - 1 - z, y));
                }
            }
        }
    }

    public List<PortObj> getPort(MCTEWorld world, int index) {
        if (this.ports == null) {
            this.initPort(world);
        }
        return this.ports[index];
    }

    public int getPower(MCTEWorld world, int index) {
        List<PortObj> list = this.getPort(world, index);
        int power = 0;
        for (PortObj port : list) {
            if (power >= port.getPower((World)world)) continue;
            power = port.getPower((World)world);
        }
        return power;
    }

    public void onNeighborBlockChange(TileEntityMiniature miniature) {
        if (EnumFacing.func_82600_a((int)miniature.attachSide) != EnumFacing.UP) {
            return;
        }
        int dir = this.getMiniatureDir(miniature);
        for (int i = 0; i < 4; ++i) {
            this.checkInput(miniature, i, dir);
        }
    }

    private void checkInput(TileEntityMiniature miniature, int portIndex, int miniatureDir) {
        MCTEWorld mw = miniature.getDummyWorld();
        int fixDir = portIndex + miniatureDir & 3;
        EnumFacing side = EnumFacing.func_176731_b((int)fixDir);
        BlockPos pos = miniature.func_174877_v();
        int blockX = pos.func_177958_n() + side.func_176730_m().func_177958_n();
        int blockZ = pos.func_177952_p() + side.func_176730_m().func_177952_p();
        BlockPos targetPos = new BlockPos(blockX, pos.func_177956_o(), blockZ);
        List<PortObj> list = this.getPort(mw, portIndex);
        for (PortObj port : list) {
            int power;
            if (port.type != PortType.IN) continue;
            int meta = BlockUtil.getMetadata((IBlockAccess)mw, (int)port.x, (int)port.y, (int)port.z);
            if (miniature.func_145831_w().func_180495_p(targetPos).func_177230_c() instanceof BlockMiniature) {
                TileEntityMiniature target = (TileEntityMiniature)miniature.func_145831_w().func_175625_s(targetPos);
                if (target.blocksObject.xSize == miniature.blocksObject.xSize && target.blocksObject.zSize == miniature.blocksObject.zSize) {
                    int targetDir = this.getMiniatureDir(target);
                    int targetFixDir = portIndex + targetDir & 3;
                    List<PortObj> targetPorts = target.port.getPort(target.getDummyWorld(), targetFixDir);
                    PortObj tPort = this.matchPort(port, targetPorts, target.blocksObject.xSize);
                    if (tPort != null) {
                        int power2 = tPort.getPower((World)target.getDummyWorld());
                        if (power2 == meta) continue;
                        BlockUtil.setBlock((World)mw, (int)port.x, (int)port.y, (int)port.z, (Block)MCTE.portIn, (int)power2, (int)3);
                        continue;
                    }
                }
            }
            if ((power = miniature.func_145831_w().func_175651_c(targetPos, side)) == meta) continue;
            BlockUtil.setBlock((World)mw, (int)port.x, (int)port.y, (int)port.z, (Block)MCTE.portIn, (int)power, (int)3);
        }
    }

    private PortObj matchPort(PortObj port, List<PortObj> targetPorts, int size) {
        for (PortObj tPort : targetPorts) {
            if (port.v != tPort.v || port.u != size - tPort.u - 1) continue;
            return tPort;
        }
        return null;
    }

    public int isProvidingPower(TileEntityMiniature miniature, EnumFacing side) {
        MCTEWorld mw = miniature.getDummyWorld();
        if (mw != null) {
            if (side == null) {
                return 0;
            }
            int dirOutput = side.func_176736_b();
            if (dirOutput >= 0) {
                int dirM = this.getMiniatureDir(miniature);
                int portIndex = dirOutput - dirM + 2 & 3;
                return this.getPower(mw, portIndex);
            }
        }
        return 0;
    }

    private int getMiniatureDir(TileEntityMiniature miniature) {
        return (NGTMath.floor((float)(-(miniature.getRotation() + 45.0f) / 90.0f)) + 5) % 4;
    }

    public static enum PortType {
        IN,
        OUT;

    }

    private class PortObj {
        public final PortType type;
        public final int x;
        public final int y;
        public final int z;
        public final int u;
        public final int v;

        public PortObj(PortType p1, int p2, int p3, int p4, int p5, int p6) {
            this.type = p1;
            this.x = p2;
            this.y = p3;
            this.z = p4;
            this.u = p5;
            this.v = p6;
        }

        public int getPower(World world) {
            int meta = BlockUtil.getMetadata((IBlockAccess)world, (int)this.x, (int)this.y, (int)this.z);
            return this.type == PortType.OUT ? meta : 0;
        }
    }
}

