/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.editor;

import jp.ngt.mcte.editor.EntityEditor;
import jp.ngt.ngtlib.renderer.GLHelper;
import jp.ngt.ngtlib.renderer.GLObject;
import jp.ngt.ngtlib.renderer.NGTObjectRenderer;
import jp.ngt.ngtlib.renderer.NGTRenderer;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import jp.ngt.ngtlib.util.NGTUtilClient;
import jp.ngt.ngtlib.world.IBlockAccessNGT;
import jp.ngt.ngtlib.world.NGTWorld;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderEditor
extends Render<EntityEditor> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mcte", "textures/atc.png");
    private final int[] hitBoxBuf = new int[6];
    private final int[] selectBoxBuf = new int[6];

    public RenderEditor(RenderManager renderManager) {
        super(renderManager);
    }

    public void renderEditor(EntityEditor editor, double par2, double par4, double par6, float par8, float par9) {
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glTranslatef((float)((float)par2), (float)((float)par4), (float)((float)par6));
        this.initSelectBox(editor);
        this.renderText(editor);
        GL11.glDisable((int)3553);
        int startX = this.hitBoxBuf[0];
        int startY = this.hitBoxBuf[1];
        int startZ = this.hitBoxBuf[2];
        int endX = this.hitBoxBuf[3];
        int endY = this.hitBoxBuf[4];
        int endZ = this.hitBoxBuf[5];
        int minX = this.selectBoxBuf[0];
        int minY = this.selectBoxBuf[1];
        int minZ = this.selectBoxBuf[2];
        int maxX = this.selectBoxBuf[3];
        int maxY = this.selectBoxBuf[4];
        int maxZ = this.selectBoxBuf[5];
        double pX = editor.field_70169_q + (editor.field_70165_t - editor.field_70169_q) * (double)par9;
        double pY = editor.field_70167_r + (editor.field_70163_u - editor.field_70167_r) * (double)par9;
        double pZ = editor.field_70166_s + (editor.field_70161_v - editor.field_70166_s) * (double)par9;
        GL11.glTranslatef((float)((float)((double)minX - pX)), (float)((float)((double)minY - pY)), (float)((float)((double)minZ - pZ)));
        float difX = maxX - minX;
        float difY = maxY - minY;
        float difZ = maxZ - minZ;
        float minPos = -0.05f;
        float f1 = 0.06f;
        float size1 = 1.12f;
        this.renderBox(minPos, minPos, minPos, 1.1f + difX, 1.1f + difY, 1.1f + difZ, 0x204020, 32);
        NGTRenderer.renderFrame((float)minPos, (float)minPos, (float)minPos, (float)(1.1f + difX), (float)(1.1f + difY), (float)(1.1f + difZ), (int)0, (int)255);
        this.renderBox((float)(startX - minX) - f1, (float)(startY - minY) - f1, (float)(startZ - minZ) - f1, size1, size1, size1, 0xFF0000, 128);
        NGTRenderer.renderFrame((float)((float)(startX - minX) - f1), (float)((float)(startY - minY) - f1), (float)((float)(startZ - minZ) - f1), (float)size1, (float)size1, (float)size1, (int)0xFF0000, (int)255);
        this.renderBox((float)(endX - minX) - f1, (float)(endY - minY) - f1, (float)(endZ - minZ) - f1, size1, size1, size1, 255, 128);
        NGTRenderer.renderFrame((float)((float)(endX - minX) - f1), (float)((float)(endY - minY) - f1), (float)((float)(endZ - minZ) - f1), (float)size1, (float)size1, (float)size1, (int)255, (int)255);
        byte editMode = editor.getEditMode();
        boolean flag1 = editor.isSelectEnd() && (editMode == 2 || editMode == 3);
        RayTraceResult target = null;
        if (flag1 && (target = editor.getTarget(true)) != null && target.func_178782_a() != null) {
            int tgX = target.func_178782_a().func_177958_n();
            int tgY = target.func_178782_a().func_177956_o();
            int tgZ = target.func_178782_a().func_177952_p();
            if (editor.blocksForRenderer != null && target != null) {
                GL11.glEnable((int)3553);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(tgX - minX), (float)(tgY - minY), (float)(tgZ - minZ));
                this.renderBlocks(editor, tgX, tgY, tgZ);
                GL11.glPopMatrix();
                GL11.glDisable((int)3553);
            }
            int[] box = editor.getPos(EntityEditor.PASTE_BOX);
            if (target != null && box[0] * box[1] * box[2] > 0) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(tgX - minX), (float)(tgY - minY), (float)(tgZ - minZ));
                this.renderBox(minPos, minPos, minPos, 0.1f + (float)box[0], 0.1f + (float)box[1], 0.1f + (float)box[2], 0x808020, 64);
                NGTRenderer.renderFrame((float)minPos, (float)minPos, (float)minPos, (float)(0.1f + (float)box[0]), (float)(0.1f + (float)box[1]), (float)(0.1f + (float)box[2]), (int)0, (int)255);
                GL11.glPopMatrix();
            }
        }
        if (editor.hasCloneBox()) {
            GL11.glPushMatrix();
            int[] box = editor.getCloneBox();
            for (int i = 0; i < box[3]; ++i) {
                GL11.glTranslatef((float)box[0], (float)box[1], (float)box[2]);
                this.renderBox(minPos, minPos, minPos, 1.1f + difX, 1.1f + difY, 1.1f + difZ, 0x303000, 64);
                NGTRenderer.renderFrame((float)minPos, (float)minPos, (float)minPos, (float)(1.1f + difX), (float)(1.1f + difY), (float)(1.1f + difZ), (int)0, (int)255);
            }
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    private void initSelectBox(EntityEditor editor) {
        for (int i = 0; i < 6; ++i) {
            this.hitBoxBuf[i] = 0;
            this.selectBoxBuf[i] = 0;
        }
        int[] start = editor.getPos(EntityEditor.START_POS);
        int[] end = editor.getPos(EntityEditor.END_POS);
        if (!editor.isSelectEnd()) {
            RayTraceResult target = editor.getTarget(false);
            if (target != null) {
                end[0] = target.func_178782_a().func_177958_n();
                end[1] = target.func_178782_a().func_177956_o();
                end[2] = target.func_178782_a().func_177952_p();
            } else {
                end[0] = start[0];
                end[1] = start[1];
                end[2] = start[2];
            }
        }
        for (int i = 0; i < 3; ++i) {
            this.hitBoxBuf[i] = start[i];
            this.hitBoxBuf[i + 3] = end[i];
            if (start[i] < end[i]) {
                this.selectBoxBuf[i] = start[i];
                this.selectBoxBuf[i + 3] = end[i];
                continue;
            }
            this.selectBoxBuf[i] = end[i];
            this.selectBoxBuf[i + 3] = start[i];
        }
    }

    private void renderText(EntityEditor editor) {
        GLHelper.disableLighting();
        GL11.glPushMatrix();
        GL11.glRotatef((float)(-NGTUtilClient.getMinecraft().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)NGTUtilClient.getMinecraft().func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)4.0f, (float)4.0f, (float)3.0f);
        float scale = 0.03125f;
        GL11.glScalef((float)(-scale), (float)(-scale), (float)scale);
        FontRenderer fontRenderer = NGTUtilClient.getMinecraft().func_175598_ae().func_78716_a();
        fontRenderer.func_78276_b(String.format("Start : %d, %d, %d", this.hitBoxBuf[0], this.hitBoxBuf[1], this.hitBoxBuf[2]), 0, 0, 0xFF0000);
        fontRenderer.func_78276_b(String.format("End : %d, %d, %d", this.hitBoxBuf[3], this.hitBoxBuf[4], this.hitBoxBuf[5]), 0, 12, 255);
        String size = String.format("Size : %d, %d, %d", Math.abs(this.hitBoxBuf[3] - this.hitBoxBuf[0]) + 1, Math.abs(this.hitBoxBuf[4] - this.hitBoxBuf[1]) + 1, Math.abs(this.hitBoxBuf[5] - this.hitBoxBuf[2]) + 1);
        fontRenderer.func_78276_b(size, 0, 24, 43520);
        GL11.glPopMatrix();
        GLHelper.enableLighting();
    }

    private void renderBlocks(EntityEditor editor, int x, int y, int z) {
        GL11.glEnable((int)2884);
        this.func_110776_a(TextureMap.field_110575_b);
        if (editor.shouldUpdate() || !GLHelper.isValid((GLObject)editor.displayList)) {
            if (!GLHelper.isValid((GLObject)editor.displayList)) {
                editor.displayList = GLHelper.generateGLList((GLObject)editor.displayList);
            }
            GLHelper.startCompile((GLObject)editor.displayList);
            NGTObjectRenderer.INSTANCE.renderNGTObject((IBlockAccessNGT)((NGTWorld)editor.dummyWorld), editor.blocksForRenderer, true, 0, 0);
            GLHelper.endCompile();
            editor.setUpdate(false);
        } else {
            GLHelper.callList((GLObject)editor.displayList);
        }
        GL11.glDisable((int)2884);
    }

    public void doRender(EntityEditor entity, double par2, double par4, double par6, float par8, float par9) {
        this.renderEditor(entity, par2, par4, par6, par8, par9);
    }

    private final void renderBox(float minX, float minY, float minZ, float width, float height, float depth, int color, int alpha) {
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)true);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GLHelper.setLightmapMaxBrightness();
        float maxX = minX + width;
        float maxY = minY + height;
        float maxZ = minZ + depth;
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(color, alpha);
        tessellator.addVertex(maxX, minY, minZ);
        tessellator.addVertex(maxX, maxY, minZ);
        tessellator.addVertex(maxX, maxY, maxZ);
        tessellator.addVertex(maxX, minY, maxZ);
        tessellator.addVertex(minX, minY, maxZ);
        tessellator.addVertex(minX, maxY, maxZ);
        tessellator.addVertex(minX, maxY, minZ);
        tessellator.addVertex(minX, minY, minZ);
        tessellator.addVertex(maxX, maxY, maxZ);
        tessellator.addVertex(maxX, maxY, minZ);
        tessellator.addVertex(minX, maxY, minZ);
        tessellator.addVertex(minX, maxY, maxZ);
        tessellator.addVertex(maxX, minY, minZ);
        tessellator.addVertex(maxX, minY, maxZ);
        tessellator.addVertex(minX, minY, maxZ);
        tessellator.addVertex(minX, minY, minZ);
        tessellator.addVertex(maxX, minY, maxZ);
        tessellator.addVertex(maxX, maxY, maxZ);
        tessellator.addVertex(minX, maxY, maxZ);
        tessellator.addVertex(minX, minY, maxZ);
        tessellator.addVertex(minX, minY, minZ);
        tessellator.addVertex(minX, maxY, minZ);
        tessellator.addVertex(maxX, maxY, minZ);
        tessellator.addVertex(maxX, minY, minZ);
        tessellator.draw();
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glDepthMask((boolean)true);
    }

    protected ResourceLocation getEntityTexture(EntityEditor entity) {
        return TEXTURE;
    }
}

