/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.editor.filter;

import jp.ngt.mcte.editor.Editor;
import jp.ngt.mcte.editor.filter.Config;
import jp.ngt.mcte.editor.filter.EditFilterBase;
import jp.ngt.mcte.editor.filter.Repeatable;
import jp.ngt.ngtlib.math.AABBInt;
import jp.ngt.ngtlib.math.PerlinNoise;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class EditFilterPerlinNoise
extends EditFilterBase {
    private final String[] names = new String[]{"Perlin2D", "Perlin3D"};

    @Override
    public void init(Config par) {
        super.init(par);
        par.addString("Mode", this.names[0], this.names);
        par.addInt("Octaves", 1, 1, 256);
        par.addFloat("Persistence", 1.0f, 0.0f, 65535.0f);
        par.addFloat("ScaleX", 0.0625f, 0.0f, 255.0f);
        par.addFloat("ScaleY", 0.0625f, 0.0f, 255.0f);
        par.addFloat("ScaleZ", 0.0625f, 0.0f, 255.0f);
    }

    @Override
    public String getFilterName() {
        return "PerlinNoise";
    }

    @Override
    public boolean edit(Editor editor) {
        AABBInt box = editor.getSelectBox();
        if (box != null) {
            editor.record(box);
            String mode = this.getCfg().getString("Mode");
            Repeatable repeater = this.names[0].equals(mode) ? this.getRepeaterPerlin2D(editor, box) : this.getRepeaterPerlin3D(editor, box);
            editor.repeat(box, repeater, 1);
            return true;
        }
        return false;
    }

    private Repeatable getRepeaterPerlin2D(Editor editor, AABBInt box) {
        double[] r = new double[]{(double)(box.maxX - box.minX) / 2.0, (double)(box.maxY - box.minY) / 2.0, (double)(box.maxZ - box.minZ) / 2.0};
        int octaves = this.getCfg().getInt("Octaves");
        float persistence = this.getCfg().getFloat("Persistence");
        float scaleX = this.getCfg().getFloat("ScaleX");
        float scaleZ = this.getCfg().getFloat("ScaleZ");
        return (box2, index, rep, x, y, z) -> {
            World world = editor.getWorld();
            Block fillBlock = editor.getEntity().getSlotBlock(0);
            int meta = editor.getEntity().getSlotBlockMetadata(0);
            double dx = (double)x * (double)scaleX;
            double dz = (double)z * (double)scaleZ;
            double h = (PerlinNoise.octavePerlin((double)dx, (double)0.0, (double)dz, (int)octaves, (double)persistence) + 0.5) * r[1] * 2.0;
            if ((double)y <= h) {
                editor.setBlock(x, y, z, fillBlock, meta, true);
            }
        };
    }

    private Repeatable getRepeaterPerlin3D(Editor editor, AABBInt box) {
        double[] r = new double[]{(double)(box.maxX - box.minX) / 2.0, (double)(box.maxY - box.minY) / 2.0, (double)(box.maxZ - box.minZ) / 2.0};
        int octaves = this.getCfg().getInt("Octaves");
        float persistence = this.getCfg().getFloat("Persistence");
        float scaleX = this.getCfg().getFloat("ScaleX");
        float scaleY = this.getCfg().getFloat("ScaleY");
        float scaleZ = this.getCfg().getFloat("ScaleZ");
        return (box2, index, rep, x, y, z) -> {
            World world = editor.getWorld();
            Block fillBlock = editor.getEntity().getSlotBlock(0);
            int meta = editor.getEntity().getSlotBlockMetadata(0);
            double dx = (double)x * (double)scaleX;
            double dy = (double)y * (double)scaleY;
            double dz = (double)z * (double)scaleZ;
            if (PerlinNoise.octavePerlin((double)dx, (double)dy, (double)dz, (int)octaves, (double)persistence) >= 0.0) {
                editor.setBlock(x, y, z, fillBlock, meta, true);
            }
        };
    }
}

