/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.gui;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import jp.ngt.mcte.MCTEKeyHandlerClient;
import jp.ngt.mcte.world.WorldData;
import jp.ngt.ngtlib.gui.GuiScreenCustom;
import jp.ngt.ngtlib.gui.GuiSelect;
import jp.ngt.ngtlib.gui.GuiSlotCustom;
import jp.ngt.ngtlib.io.FileType;
import jp.ngt.ngtlib.io.NGTFileLoader;
import jp.ngt.ngtlib.io.NGTImage;
import jp.ngt.ngtlib.math.NGTMath;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiCreatePictorialWorld
extends GuiScreenCustom {
    protected static Map<String, ItemStack> biomeIconMap = new TreeMap<String, ItemStack>();
    private final GuiCreateWorld createWorldGui;
    private WorldData worldData;
    private NGTImage.Thumbnail[] thumbnail = new NGTImage.Thumbnail[2];
    private String[] imgName = new String[]{"", ""};
    private GuiButton[] selectButtons = new GuiButton[3];
    private GuiTextField minYTF;
    private GuiTextField yScaleTF;
    private GuiTextField seaLevelTF;
    private GuiSlotCustom slotCustom;
    private GuiSlotCustom.SlotElement[] slotElements = new GuiSlotCustom.SlotElement[0];
    private boolean canceled = false;

    public GuiCreatePictorialWorld(GuiCreateWorld par1) {
        this.createWorldGui = par1;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.worldData = new WorldData(this.createWorldGui.field_146334_a);
        int i0 = (this.field_146295_m - 30) / this.thumbnail.length + 80;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 155, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 5, this.field_146295_m - 28, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.selectButtons[0] = new GuiButton(10, i0, 0, 40, 20, I18n.func_135052_a((String)"gui.mcte.select", (Object[])new Object[0]));
        this.field_146292_n.add(this.selectButtons[0]);
        this.selectButtons[1] = new GuiButton(11, i0, 20, 40, 20, I18n.func_135052_a((String)"gui.mcte.select", (Object[])new Object[0]));
        this.field_146292_n.add(this.selectButtons[1]);
        this.selectButtons[2] = new GuiButton(12, i0, 40, 40, 20, I18n.func_135052_a((String)"gui.mcte.select", (Object[])new Object[0]));
        this.field_146292_n.add(this.selectButtons[2]);
        this.textFields.clear();
        this.minYTF = this.setTextField(i0, 60, 40, 20, String.valueOf(this.worldData.minY));
        this.yScaleTF = this.setTextField(i0, 80, 40, 20, String.valueOf(this.worldData.yScale));
        this.seaLevelTF = this.setTextField(i0, 100, 40, 20, String.valueOf(this.worldData.seaLevel));
        this.currentTextField = this.minYTF;
        this.slotList.clear();
        int i1 = this.field_146294_l - 55 - i0;
        this.slotCustom = new GuiSlotCustom((GuiScreenCustom)this, 0, this.field_146295_m - 30, i0 + 45, this.field_146294_l - 10, i1, 24, this.slotElements);
        this.slotList.add(this.slotCustom);
        if (this.worldData.terrainImagePath != null) {
            this.setImageFile(0, new File(this.worldData.terrainImagePath));
        }
        if (this.worldData.biomesImagePath != null) {
            this.setImageFile(1, new File(this.worldData.biomesImagePath));
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.canceled) {
            File file;
            if (this.createWorldGui.field_146334_a != null && (file = new File(this.createWorldGui.field_146334_a)).exists()) {
                file.delete();
            }
            this.createWorldGui.field_146334_a = "";
        } else {
            this.writeTextFieldsToWorldData();
            this.createWorldGui.field_146334_a = this.worldData.saveWorldData(this.createWorldGui.field_146334_a);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.field_146297_k.func_147108_a((GuiScreen)this.createWorldGui);
        } else if (button.field_146127_k == 1) {
            this.canceled = true;
            this.field_146297_k.func_147108_a((GuiScreen)this.createWorldGui);
        } else if (button.field_146127_k == 10) {
            this.selectImageFile(0);
        } else if (button.field_146127_k == 11) {
            this.selectImageFile(1);
        } else if (button.field_146127_k == 12) {
            this.selectBlock();
        }
        super.func_146284_a(button);
    }

    protected void func_73869_a(char par1, int par2) {
        if (par2 == 1 || par2 == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() || par2 == MCTEKeyHandlerClient.keyEditMenu.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        if (par2 >= 2 && par2 <= 11 || par2 >= 200 && par2 <= 205 || par2 == 12 || par2 == 14 || par2 == 211) {
            this.currentTextField.func_146201_a(par1, par2);
        }
        if (par2 == 28) {
            this.writeTextFieldsToWorldData();
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        int i0 = (this.field_146295_m - 30) / this.thumbnail.length;
        this.func_146276_q_();
        super.func_73863_a(par1, par2, par3);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"gui.mcte.terrainImage", (Object[])new Object[0]), i0 + 5, 5, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"gui.mcte.biomesImage", (Object[])new Object[0]), i0 + 5, 25, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"gui.mcte.baseBlock", (Object[])new Object[0]), i0 + 5, 45, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"gui.mcte.minY", (Object[])new Object[0]), i0 + 5, 65, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"gui.mcte.yScale", (Object[])new Object[0]), i0 + 5, 85, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"gui.mcte.seaLevel", (Object[])new Object[0]), i0 + 5, 105, 0xFFFFFF);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < this.thumbnail.length; ++i) {
            if (this.thumbnail[i] == null) continue;
            float d1 = i0 * i;
            this.thumbnail[i].bindTexture();
            NGTTessellator tessellator = NGTTessellator.instance;
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV((float)i0, (float)i0 + d1, this.field_73735_i, 1.0f, 1.0f);
            tessellator.addVertexWithUV((float)i0, 0.0f + d1, this.field_73735_i, 1.0f, 0.0f);
            tessellator.addVertexWithUV(0.0f, 0.0f + d1, this.field_73735_i, 0.0f, 0.0f);
            tessellator.addVertexWithUV(0.0f, (float)i0 + d1, this.field_73735_i, 0.0f, 1.0f);
            tessellator.draw();
        }
    }

    private void selectBlock() {
        Iterator iterator0 = Block.field_149771_c.iterator();
        NonNullList list0 = NonNullList.func_191196_a();
        while (iterator0.hasNext()) {
            Block block = (Block)iterator0.next();
            Item item = Item.func_150898_a((Block)block);
            if (item == null) continue;
            block.func_149666_a(CreativeTabs.field_78027_g, list0);
        }
        ArrayList<ItemStack> list1 = new ArrayList<ItemStack>();
        for (ItemStack stack : list0) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (stack.func_77952_i() != 0 || block == null || block.hasTileEntity(block.func_176203_a(stack.func_77952_i()))) continue;
            list1.add(stack);
        }
        GuiSelect.ISelector selector = new GuiSelect.ISelector(){

            public void select(Object par1) {
                ((GuiCreatePictorialWorld)GuiCreatePictorialWorld.this).worldData.baseBlock = (Block)par1;
            }
        };
        GuiSelect.SlotElementItem[] slots = new GuiSelect.SlotElementItem[list1.size()];
        for (int i = 0; i < slots.length; ++i) {
            ItemStack stack = (ItemStack)list1.get(i);
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            String s = stack.func_82833_r();
            slots[i] = new GuiSelect.SlotElementItem(selector, (Object)block, s, stack);
        }
        this.field_146297_k.func_147108_a((GuiScreen)new GuiSelect((GuiScreen)this, (GuiSlotCustom.SlotElement[])slots));
    }

    private void selectImageFile(int par1) {
        File file = NGTFileLoader.selectFile((FileType[])new FileType[]{FileType.PNG});
        if (file != null) {
            this.setImageFile(par1, file);
        }
    }

    private void setImageFile(int index, File file) {
        if (this.imgName[index].equals(file.getAbsolutePath())) {
            return;
        }
        try {
            BufferedImage image = ImageIO.read(file);
            if (this.thumbnail[index] != null) {
                this.thumbnail[index].deleteTexture();
            }
            this.thumbnail[index] = new NGTImage.Thumbnail(image, 256, 256);
            this.imgName[index] = file.getAbsolutePath();
            if (index == 1) {
                this.setBiomeButtons(image);
            }
            switch (index) {
                case 0: {
                    this.worldData.terrainImagePath = file.getAbsolutePath();
                    break;
                }
                case 1: {
                    this.worldData.biomesImagePath = file.getAbsolutePath();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setBiomeButtons(BufferedImage image) {
        if (image.getType() != 6) {
            if (this.slotCustom != null) {
                this.slotList.remove(this.slotCustom);
                this.slotElements = new GuiSlotCustom.SlotElement[0];
            }
            return;
        }
        TreeMap<Integer, Biome> map = new TreeMap<Integer, Biome>();
        int[] ia = new int[4];
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                image.getRaster().getPixel(i, j, ia);
                int color = NGTImage.getIntFromARGB((int)ia[3], (int)ia[0], (int)ia[1], (int)ia[2]) & 0xFFFFFF;
                if (map.containsKey(color)) continue;
                Biome b0 = Biomes.field_76772_c;
                if (this.worldData.biomeMap.containsKey(color)) {
                    b0 = this.worldData.biomeMap.get(color);
                }
                map.put(color, b0);
            }
        }
        int i0 = (this.field_146295_m - 30) / this.thumbnail.length + 10;
        int i = 0;
        GuiSlotCustom.SlotElement[] sb = new SlotBiomeColor[map.size()];
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            sb[i] = new SlotBiomeColor(this, (Integer)entry.getKey(), (Biome)entry.getValue());
            ++i;
        }
        this.slotCustom.setElements(sb);
        this.slotElements = sb;
    }

    private void writeTextFieldsToWorldData() {
        this.worldData.minY = NGTMath.getIntFromString((String)this.minYTF.func_146179_b(), (int)0, (int)255, (int)0);
        this.minYTF.func_146180_a(String.valueOf(this.worldData.minY));
        this.worldData.yScale = NGTMath.getFloatFromString((String)this.yScaleTF.func_146179_b(), (float)0.00390625f, (float)256.0f, (float)1.0f);
        this.yScaleTF.func_146180_a(String.valueOf(this.worldData.yScale));
        this.worldData.seaLevel = NGTMath.getIntFromString((String)this.seaLevelTF.func_146179_b(), (int)0, (int)255, (int)64);
        this.seaLevelTF.func_146180_a(String.valueOf(this.worldData.seaLevel));
    }

    static {
        biomeIconMap.put(Biomes.field_76771_b.func_185359_l(), new ItemStack((Block)Blocks.field_150355_j, 1, 0));
        biomeIconMap.put(Biomes.field_76770_e.func_185359_l(), new ItemStack(Blocks.field_150348_b, 1, 0));
        biomeIconMap.put(Biomes.field_76767_f.func_185359_l(), new ItemStack((Block)Blocks.field_150362_t, 1, 0));
        biomeIconMap.put(Biomes.field_76768_g.func_185359_l(), new ItemStack((Block)Blocks.field_150362_t, 1, 1));
        biomeIconMap.put(Biomes.field_76780_h.func_185359_l(), new ItemStack(Blocks.field_150392_bi, 1, 0));
        biomeIconMap.put(Biomes.field_76781_i.func_185359_l(), new ItemStack((Block)Blocks.field_150355_j, 1, 0));
        biomeIconMap.put(Biomes.field_76778_j.func_185359_l(), new ItemStack(Blocks.field_150424_aL, 1, 0));
        biomeIconMap.put(Biomes.field_76779_k.func_185359_l(), new ItemStack(Blocks.field_150377_bs, 1, 0));
        biomeIconMap.put(Biomes.field_76776_l.func_185359_l(), new ItemStack(Blocks.field_150432_aD, 1, 0));
        biomeIconMap.put(Biomes.field_76777_m.func_185359_l(), new ItemStack(Blocks.field_150432_aD, 1, 0));
        biomeIconMap.put(Biomes.field_76787_r.func_185359_l(), new ItemStack((Block)Blocks.field_150354_m, 1, 0));
        biomeIconMap.put(Biomes.field_76785_t.func_185359_l(), new ItemStack((Block)Blocks.field_150362_t, 1, 0));
        biomeIconMap.put(Biomes.field_76784_u.func_185359_l(), new ItemStack((Block)Blocks.field_150362_t, 1, 1));
        biomeIconMap.put(Biomes.field_76783_v.func_185359_l(), new ItemStack(Blocks.field_150348_b, 1, 0));
        biomeIconMap.put(Biomes.field_76782_w.func_185359_l(), new ItemStack((Block)Blocks.field_150362_t, 1, 3));
        biomeIconMap.put(Biomes.field_76792_x.func_185359_l(), new ItemStack((Block)Blocks.field_150362_t, 1, 3));
        biomeIconMap.put(Biomes.field_150574_L.func_185359_l(), new ItemStack((Block)Blocks.field_150362_t, 1, 3));
        biomeIconMap.put(Biomes.field_150575_M.func_185359_l(), new ItemStack((Block)Blocks.field_150355_j, 1, 0));
        biomeIconMap.put(Biomes.field_150576_N.func_185359_l(), new ItemStack(Blocks.field_150348_b, 1, 0));
        biomeIconMap.put(Biomes.field_150577_O.func_185359_l(), new ItemStack(Blocks.field_150432_aD, 1, 0));
        biomeIconMap.put(Biomes.field_150583_P.func_185359_l(), new ItemStack((Block)Blocks.field_150362_t, 1, 2));
        biomeIconMap.put(Biomes.field_150582_Q.func_185359_l(), new ItemStack((Block)Blocks.field_150362_t, 1, 2));
        biomeIconMap.put(Biomes.field_150585_R.func_185359_l(), new ItemStack((Block)Blocks.field_150362_t, 1, 0));
        biomeIconMap.put(Biomes.field_150584_S.func_185359_l(), new ItemStack(Blocks.field_150433_aE, 1, 0));
        biomeIconMap.put(Biomes.field_150579_T.func_185359_l(), new ItemStack(Blocks.field_150433_aE, 1, 0));
        biomeIconMap.put(Biomes.field_150590_f.func_185359_l(), new ItemStack((Block)Blocks.field_150362_t, 1, 1));
        biomeIconMap.put(Biomes.field_185431_ac.func_185359_l(), new ItemStack((Block)Blocks.field_150362_t, 1, 1));
        biomeIconMap.put(Biomes.field_76770_e.func_185359_l(), new ItemStack(Blocks.field_150348_b, 1, 0));
        biomeIconMap.put(Biomes.field_150589_Z.func_185359_l(), new ItemStack(Blocks.field_150405_ch, 1, 0));
        biomeIconMap.put(Biomes.field_150608_ab.func_185359_l(), new ItemStack(Blocks.field_150405_ch, 1, 0));
        biomeIconMap.put(Biomes.field_150607_aa.func_185359_l(), new ItemStack(Blocks.field_150405_ch, 1, 0));
    }

    @SideOnly(value=Side.CLIENT)
    public class SlotBiomeColor
    extends GuiSlotCustom.SlotElement
    implements GuiSelect.ISelector {
        public final int color;
        public Biome biome;

        public SlotBiomeColor(GuiCreatePictorialWorld par1, int par2, Biome par3) {
            this.color = par2;
            this.biome = par3;
        }

        public void draw(Minecraft par1, int par2, int par3, float par4) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3553);
            this.drawModalRect(par2 + 1, par3 + 1, 18, 18, par4, this.color);
            GL11.glEnable((int)3553);
            par1.field_71466_p.func_78276_b(this.biome.func_185359_l(), par2 + 23, par3 + 6, 0xFFFFFF);
        }

        protected void drawModalRect(int par1, int par2, int par3, int par4, float par5, int color) {
            NGTTessellator tessellator = NGTTessellator.instance;
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(color);
            tessellator.addVertex((float)(par1 + 0), (float)(par2 + par4), par5);
            tessellator.addVertex((float)(par1 + par3), (float)(par2 + par4), par5);
            tessellator.addVertex((float)(par1 + par3), (float)(par2 + 0), par5);
            tessellator.addVertex((float)(par1 + 0), (float)(par2 + 0), par5);
            tessellator.draw();
        }

        public void onClicked(int par1, boolean par2) {
            if (par2) {
                ArrayList<Biome> list = new ArrayList<Biome>();
                for (ResourceLocation res : Biome.field_185377_q.func_148742_b()) {
                    Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)res);
                    if (biome == null) continue;
                    list.add(biome);
                }
                GuiSelect.SlotElementItem[] slots = new GuiSelect.SlotElementItem[list.size()];
                for (int i = 0; i < slots.length; ++i) {
                    Biome b0 = (Biome)list.get(i);
                    String biomeName = b0.func_185359_l();
                    if (biomeIconMap.containsKey(biomeName)) {
                        ItemStack stack = biomeIconMap.get(biomeName);
                        slots[i] = new GuiSelect.SlotElementItem((GuiSelect.ISelector)this, (Object)b0, biomeName, stack);
                        continue;
                    }
                    slots[i] = new GuiSelect.SlotElementItem((GuiSelect.ISelector)this, (Object)b0, biomeName, new ItemStack(b0.field_76752_A.func_177230_c(), 1, 0));
                }
                GuiCreatePictorialWorld.this.field_146297_k.func_147108_a((GuiScreen)new GuiSelect((GuiScreen)GuiCreatePictorialWorld.this, (GuiSlotCustom.SlotElement[])slots));
            }
        }

        public void select(Object par1) {
            this.biome = (Biome)par1;
            ((GuiCreatePictorialWorld)GuiCreatePictorialWorld.this).worldData.biomeMap.put(this.color, this.biome);
        }
    }
}

