/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.ngt.mcte.editor.filter.CfgParameter;
import jp.ngt.mcte.editor.filter.Config;
import jp.ngt.mcte.editor.filter.EditFilterBase;
import jp.ngt.mcte.editor.filter.FilterManager;
import jp.ngt.mcte.gui.GuiEditor;
import jp.ngt.mcte.gui.GuiElementBoolean;
import jp.ngt.mcte.gui.GuiElementFloat;
import jp.ngt.mcte.gui.GuiElementInt;
import jp.ngt.mcte.gui.GuiElementString;
import jp.ngt.mcte.gui.GuiElementStringList;
import jp.ngt.mcte.gui.IGuiElement;
import jp.ngt.ngtlib.gui.GuiButtonCustom;
import jp.ngt.ngtlib.gui.GuiScreenCustom;
import jp.ngt.ngtlib.gui.GuiTextFieldCustom;
import jp.ngt.ngtlib.renderer.NGTRenderHelper;
import jp.ngt.ngtlib.renderer.NGTTessellator;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiFilterSetting
extends GuiScreenCustom {
    protected static final int FIRST_BUTTON_ID = 200;
    protected static final int BUTTON_GAP_Y = 4;
    protected static final int FILTER_BUTTON_W = 100;
    protected static final int SETTING_BUTTON_W = 20;
    protected static final int SEPARATION_POS = 140;
    private final GuiEditor parentGui;
    private final List<EditFilterBase> filters = new ArrayList<EditFilterBase>();
    private List<GuiButton> filterButtons;
    private List<GuiButton> filterSettingButtons;
    private int currentScrollL;
    private List<GuiTextField> guiElementNames;
    private List<IGuiElement> guiElements;
    private int currentScrollR;
    private int selectedFilterId;

    public GuiFilterSetting(GuiEditor gui, String selectedFilterName) {
        this.parentGui = gui;
        this.filters.addAll(FilterManager.INSTANCE.getFilters());
        this.filterButtons = new ArrayList<GuiButton>();
        this.filterSettingButtons = new ArrayList<GuiButton>();
        this.guiElementNames = new ArrayList<GuiTextField>();
        this.guiElements = new ArrayList<IGuiElement>();
        for (int i = 0; i < this.filters.size(); ++i) {
            if (!this.filters.get(i).getFilterName().equals(selectedFilterName)) continue;
            this.selectedFilterId = i;
            break;
        }
    }

    public void func_73866_w_() {
        this.initGuiElements(this.selectedFilterId);
    }

    private void initGuiElements(int index) {
        this.save();
        this.field_146292_n.clear();
        this.textFields.clear();
        this.initFiltersButton();
        this.selectSetting(index);
        this.updateElementsPos();
    }

    private void initFiltersButton() {
        this.filterButtons.clear();
        this.filterSettingButtons.clear();
        int buttonId = 199;
        int halfW = this.field_146294_l / 2;
        for (EditFilterBase filter : this.filters) {
            this.filterButtons.add((GuiButton)new GuiButtonCustom(++buttonId, 10, 0, 100, 20, filter.getFilterName(), (GuiScreen)this));
            this.filterSettingButtons.add((GuiButton)new GuiButtonCustom(++buttonId, 110, 0, 20, 20, "\u2699", (GuiScreen)this));
        }
        this.field_146292_n.addAll(this.filterButtons);
        this.field_146292_n.addAll(this.filterSettingButtons);
    }

    private void selectSetting(int index) {
        this.selectedFilterId = index;
        this.currentScrollR = 0;
        for (int i = 0; i < this.filterSettingButtons.size(); ++i) {
            GuiButton button1 = this.filterSettingButtons.get(i);
            button1.field_146124_l = true;
        }
        this.filterSettingButtons.get((int)index).field_146124_l = false;
        this.guiElementNames.clear();
        this.guiElements.clear();
        EditFilterBase filter = this.filters.get(index);
        Config cfg = filter.getCfg();
        Map<String, CfgParameter> map = cfg.parameters;
        int elementId = 500;
        int x = 150;
        int x2 = x + 60;
        int y = 0;
        int w = 100;
        int h = 20;
        block8: for (Map.Entry<String, CfgParameter> entry : map.entrySet()) {
            IGuiElement element;
            GuiTextFieldCustom field = this.setTextField(x, y, 60, h, entry.getKey());
            field.setDisplayMode(true);
            this.guiElementNames.add((GuiTextField)field);
            switch (entry.getValue().getType()) {
                case BOOLEAN: {
                    element = new GuiElementBoolean(elementId, x2, y, w, h, cfg, entry.getKey());
                    break;
                }
                case FLOAT: {
                    element = new GuiElementFloat(elementId, x2, y, w, h, cfg, entry.getKey());
                    break;
                }
                case INTEGER: {
                    element = new GuiElementInt(elementId, x2, y, w, h, cfg, entry.getKey());
                    break;
                }
                case STRING: {
                    element = new GuiElementString(elementId, x2, y, w, h, cfg, entry.getKey());
                    break;
                }
                case STRING_LIST: {
                    element = new GuiElementStringList(elementId, x2, y, w, h, cfg, entry.getKey());
                    break;
                }
                default: {
                    continue block8;
                }
            }
            this.guiElements.add(element);
            element.init(this);
            ++elementId;
        }
    }

    protected void save() {
        for (GuiTextField field : this.getTextFields()) {
            field.func_146195_b(false);
        }
        for (EditFilterBase filter : this.filters) {
            filter.save();
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 101) {
            this.closeGui();
        } else if (button.field_146127_k >= 200 && button.field_146127_k < 200 + this.filterButtons.size() * 2) {
            int index = button.field_146127_k - 200;
            if (index % 2 == 0) {
                this.parentGui.setFilterName(this.filterButtons.get((int)(index / 2)).field_146126_j);
                this.closeGui();
            } else {
                this.initGuiElements(index / 2);
            }
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        if (par2 == 1) {
            this.closeGui();
            return;
        }
        super.func_73869_a(par1, par2);
    }

    protected void closeGui() {
        this.save();
        this.field_146297_k.func_147108_a((GuiScreen)this.parentGui);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        GL11.glDisable((int)3553);
        NGTTessellator tessellator = NGTTessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0x404040);
        NGTRenderHelper.addQuadGuiFace((float)140.0f, (float)0.0f, (float)this.field_146294_l, (float)this.field_146295_m, (float)this.field_73735_i);
        int y = (this.selectedFilterId - this.currentScrollL) * 24 + 4;
        NGTRenderHelper.addQuadGuiFace((float)0.0f, (float)(y - 2), (float)140.0f, (float)(y + 20 + 4), (float)this.field_73735_i);
        tessellator.draw();
        GL11.glEnable((int)3553);
        super.func_73863_a(par1, par2, par3);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int scroll = Mouse.getEventDWheel();
        if (scroll != 0) {
            int n = scroll = scroll > 0 ? 1 : -1;
            if (x < this.field_146294_l / 2) {
                this.currentScrollL = this.scroll(this.currentScrollL - scroll, this.filterButtons.size());
            } else {
                this.currentScrollR = this.scroll(this.currentScrollR - scroll, this.guiElements.size());
            }
            this.updateElementsPos();
        }
    }

    private int scroll(int par1, int max) {
        int scroll = par1;
        if (scroll < 0) {
            scroll = 0;
        } else if (scroll >= max) {
            scroll = max - 1;
        }
        return scroll;
    }

    private void updateElementsPos() {
        int yPos;
        int i;
        for (i = 0; i < this.filterButtons.size(); ++i) {
            this.filterButtons.get((int)i).field_146129_i = yPos = (i - this.currentScrollL) * 24 + 4;
            this.filterSettingButtons.get((int)i).field_146129_i = yPos;
        }
        for (i = 0; i < this.guiElements.size(); ++i) {
            yPos = (i - this.currentScrollR) * 24 + 4;
            GuiTextField field = this.guiElementNames.get(i);
            field.field_146210_g = yPos;
            IGuiElement element = this.guiElements.get(i);
            element.setYPos(yPos);
        }
    }
}

