/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.item;

import jp.ngt.mcte.editor.Editor;
import jp.ngt.mcte.editor.EditorManager;
import jp.ngt.mcte.editor.EntityEditor;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.io.NGTLog;
import jp.ngt.ngtlib.item.ItemArgHolderBase;
import jp.ngt.ngtlib.item.ItemCustom;
import jp.ngt.ngtlib.math.NGTMath;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ItemEditor
extends ItemCustom {
    public ItemEditor() {
        this.func_77625_d(1);
    }

    protected ActionResult<ItemStack> onItemRightClick(ItemArgHolderBase.ItemArgHolder holder) {
        Editor editor;
        World world = holder.getWorld();
        EntityPlayer player = holder.getPlayer();
        if (world.field_72995_K) {
            return holder.success();
        }
        if (EditorManager.INSTANCE.canPlayerUseEditor(player) && (editor = EditorManager.INSTANCE.getEditor(player)) != null) {
            RayTraceResult target = editor.getEntity().getTarget(false);
            if (target != null) {
                BlockPos pos = target.func_178782_a();
                DataParameter<BlockPos> dp = editor.getEntity().isSelectEnd() ? EntityEditor.START_POS : EntityEditor.END_POS;
                editor.getEntity().setPos(dp, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return holder.success();
        }
        return holder.success();
    }

    protected ActionResult<ItemStack> onItemUse(ItemArgHolderBase.ItemArgHolder holder, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = holder.getItemStack();
        World world = holder.getWorld();
        EntityPlayer player = holder.getPlayer();
        BlockPos pos = holder.getBlockPos();
        if (!world.field_72995_K) {
            if (EditorManager.INSTANCE.canPlayerUseEditor(player)) {
                Editor editor = EditorManager.INSTANCE.getEditor(player);
                if (editor != null) {
                    DataParameter<BlockPos> dp = editor.getEntity().isSelectEnd() ? EntityEditor.START_POS : EntityEditor.END_POS;
                    editor.getEntity().setPos(dp, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    return holder.success();
                }
                EntityEditor entityEditor = Editor.getNewEditor(world, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                entityEditor.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f, 0.0f);
                world.func_72838_d((Entity)entityEditor);
            } else {
                NGTLog.sendChatMessage((ICommandSender)player, (String)"You don't have permission to use Editor.", (Object[])new Object[0]);
            }
        }
        return holder.success();
    }

    public static RayTraceResult getTarget(EntityPlayer player, boolean par2, boolean selectSide) {
        if (par2) {
            RayTraceResult target = BlockUtil.getMOPFromPlayer((EntityPlayer)player, (double)128.0, (boolean)true);
            if (target != null && target.field_72313_a == RayTraceResult.Type.BLOCK) {
                BlockPos pos = target.func_178782_a();
                if (selectSide) {
                    switch (target.field_178784_b) {
                        case DOWN: {
                            pos = pos.func_177977_b();
                            break;
                        }
                        case UP: {
                            pos = pos.func_177984_a();
                            break;
                        }
                        case NORTH: {
                            pos = pos.func_177978_c();
                            break;
                        }
                        case SOUTH: {
                            pos = pos.func_177968_d();
                            break;
                        }
                        case EAST: {
                            pos = pos.func_177974_f();
                            break;
                        }
                        case WEST: {
                            pos = pos.func_177976_e();
                        }
                    }
                }
                return new RayTraceResult(target.field_72307_f, target.field_178784_b, pos);
            }
        } else {
            float f = 1.0f;
            float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
            float yaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
            double dx = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
            double dy = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + 1.62 - player.func_70033_W();
            double dz = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
            Vec3d vec3 = new Vec3d(dx, dy, dz);
            float f3 = NGTMath.cos((float)(-yaw - 180.0f));
            float f4 = NGTMath.sin((float)(-yaw - 180.0f));
            float f5 = -NGTMath.cos((float)(-pitch));
            float f6 = NGTMath.sin((float)(-pitch));
            float x2 = f4 * f5;
            float z2 = f3 * f5;
            double distance = 8.0;
            Vec3d vec31 = vec3.func_72441_c((double)x2 * distance, (double)f6 * distance, (double)z2 * distance);
            int x = NGTMath.floor((double)vec31.field_72450_a);
            int y = NGTMath.floor((double)vec31.field_72448_b);
            int z = NGTMath.floor((double)vec31.field_72449_c);
            if (y >= 0) {
                if (y > 255) {
                    y = 255;
                }
                return new RayTraceResult(vec31, EnumFacing.UP, new BlockPos(x, y, z));
            }
        }
        return null;
    }
}

