/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.item;

import java.util.List;
import jp.ngt.mcte.MCTE;
import jp.ngt.mcte.block.MiniatureBlockState;
import jp.ngt.mcte.block.TileEntityMiniature;
import jp.ngt.ngtlib.block.BlockSet;
import jp.ngt.ngtlib.block.BlockUtil;
import jp.ngt.ngtlib.block.NGTObject;
import jp.ngt.ngtlib.item.ItemArgHolderBase;
import jp.ngt.ngtlib.item.ItemCustom;
import jp.ngt.ngtlib.item.ItemUtil;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemMiniature
extends ItemCustom {
    private static float[] offset = new float[3];
    private static int nextId;

    public ItemMiniature() {
        this.func_77625_d(1);
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return armorType == EntityEquipmentSlot.HEAD || armorType == EntityEquipmentSlot.CHEST;
    }

    protected ActionResult<ItemStack> onItemRightClick(ItemArgHolderBase.ItemArgHolder holder) {
        if (holder.getWorld().field_72995_K) {
            holder.getPlayer().openGui((Object)MCTE.instance, (int)MCTE.guiIdItemMiniature, holder.getWorld(), 0, 0, 0);
        }
        return holder.success();
    }

    protected ActionResult<ItemStack> onItemUse(ItemArgHolderBase.ItemArgHolder holder, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = holder.getItemStack();
        World world = holder.getWorld();
        EntityPlayer player = holder.getPlayer();
        BlockPos pos = holder.getBlockPos();
        if (itemStack.func_77942_o()) {
            if (!world.field_72995_K) {
                BlockPos newPos = ItemUtil.getPlacePos((BlockPos)pos, (EnumFacing)holder.getFacing());
                if (!player.func_175151_a(newPos, holder.getFacing(), itemStack)) {
                    return holder.success();
                }
                Block block = BlockUtil.getBlock((IBlockAccess)world, (BlockPos)newPos);
                if (!block.func_176200_f((IBlockAccess)world, newPos)) {
                    return holder.success();
                }
                NBTTagCompound nbt = itemStack.func_77978_p();
                NGTObject object = ItemMiniature.getNGTObject(nbt);
                if (object != null) {
                    float scale = ItemMiniature.getScale(nbt);
                    float[] fa = ItemMiniature.getOffset(nbt);
                    MiniatureMode mode = ItemMiniature.getMode(nbt);
                    MiniatureBlockState state = ItemMiniature.getMiniatureBlockState(nbt, itemStack);
                    if (mode == MiniatureMode.original) {
                        this.setOriginalBlocks(world, newPos, object);
                    } else {
                        BlockUtil.setBlock((World)world, (BlockPos)newPos, (Block)MCTE.miniature, (int)0, (int)3);
                        TileEntityMiniature tile = (TileEntityMiniature)world.func_175625_s(newPos);
                        tile.setRotation(player, MCTE.rotationInterval, false);
                        tile.attachSide = (byte)holder.getFacing().func_176745_a();
                        tile.setMBState(state);
                        tile.setBlockState(object, scale, fa[0], fa[1], fa[2], mode);
                    }
                    world.func_184134_a((double)newPos.func_177958_n() + 0.5, (double)newPos.func_177956_o() + 0.5, (double)newPos.func_177952_p() + 0.5, SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
                    itemStack.func_190918_g(1);
                }
            }
        } else if (world.field_72995_K) {
            player.openGui((Object)MCTE.instance, (int)MCTE.guiIdItemMiniature, player.field_70170_p, 0, 0, 0);
        }
        return holder.success();
    }

    private void setOriginalBlocks(World world, BlockPos pos, NGTObject ngto) {
        for (int i = 0; i < ngto.xSize; ++i) {
            for (int j = 0; j < ngto.ySize; ++j) {
                for (int k = 0; k < ngto.zSize; ++k) {
                    BlockSet set = ngto.getBlockSet(i, j, k);
                    BlockUtil.setBlock((World)world, (BlockPos)pos.func_177982_a(i, j, k), (Block)set.block, (int)set.metadata, (int)3);
                }
            }
        }
    }

    public static NGTObject getNGTObject(NBTTagCompound nbt) {
        if (nbt.func_74764_b("BlocksData")) {
            NBTTagCompound data = nbt.func_74775_l("BlocksData");
            return NGTObject.readFromNBT((NBTTagCompound)data);
        }
        return null;
    }

    public static void setNGTObject(NGTObject obj, NBTTagCompound nbt) {
        NBTTagCompound data = obj.writeToNBT();
        nbt.func_74782_a("BlocksData", (NBTBase)data);
    }

    public static float getScale(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Scale")) {
            return nbt.func_74760_g("Scale");
        }
        if (nbt.func_74764_b("MinimizeRate")) {
            int i = nbt.func_74762_e("MinimizeRate");
            if (i <= 0) {
                i = 1;
            }
            return 1.0f / (float)i;
        }
        return 1.0f;
    }

    public static void setScale(float scale, NBTTagCompound nbt) {
        nbt.func_74776_a("Scale", scale);
    }

    public static float[] getOffset(NBTTagCompound nbt) {
        ItemMiniature.offset[0] = nbt.func_74760_g("OffsetX");
        ItemMiniature.offset[1] = nbt.func_74760_g("OffsetY");
        ItemMiniature.offset[2] = nbt.func_74760_g("OffsetZ");
        return offset;
    }

    public static void setOffset(NBTTagCompound nbt, float x, float y, float z) {
        nbt.func_74776_a("OffsetX", x);
        nbt.func_74776_a("OffsetY", y);
        nbt.func_74776_a("OffsetZ", z);
    }

    public static MiniatureMode getMode(NBTTagCompound nbt) {
        byte i = nbt.func_74771_c("Mode");
        return MiniatureMode.values()[i];
    }

    public static void setMode(NBTTagCompound nbt, MiniatureMode mode) {
        nbt.func_74774_a("Mode", (byte)mode.id);
    }

    public static MiniatureBlockState getMiniatureBlockState(NBTTagCompound nbt, ItemStack stack) {
        MiniatureBlockState state;
        if (nbt.func_74764_b("MBState")) {
            state = MiniatureBlockState.readFromNBT(nbt.func_74775_l("MBState"), stack);
        } else {
            state = MiniatureBlockState.create(stack);
            state.lightValue = nbt.func_74771_c("LightValue");
        }
        return state;
    }

    public static void setMiniatureBlockState(NBTTagCompound nbt, MiniatureBlockState state) {
        nbt.func_74782_a("MBState", (NBTBase)state.writeToNBT());
    }

    protected void addInformation(ItemArgHolderBase.ItemArgHolder holder, List<String> list, ITooltipFlag flag) {
        if (holder.getItemStack().func_77942_o()) {
            NBTTagCompound nbt = holder.getItemStack().func_77978_p();
            NBTTagCompound data = nbt.func_74775_l("BlocksData");
            float scale = ItemMiniature.getScale(nbt);
            NGTObject.addInformation(list, (NBTTagCompound)data, (float)scale);
        }
    }

    public static ItemStack createMiniatureItem(NGTObject par1, float par2, float x, float y, float z, MiniatureMode mode, MiniatureBlockState state) {
        ItemStack stack = new ItemStack(MCTE.itemMiniature, 1, 0);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("BlocksData", (NBTBase)par1.writeToNBT());
        ItemMiniature.setScale(par2, nbt);
        ItemMiniature.setOffset(nbt, x, y, z);
        ItemMiniature.setMode(nbt, mode);
        ItemMiniature.setMiniatureBlockState(nbt, state);
        stack.func_77982_d(nbt);
        return stack;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            NGTObject ngto = ItemMiniature.getNGTObject(nbt);
            float scale = ItemMiniature.getScale(nbt);
            float power = (float)(ngto.blockList.size() / 16) * scale;
            entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), power);
        }
        return false;
    }

    static /* synthetic */ int access$008() {
        return nextId++;
    }

    public static enum MiniatureMode {
        miniature,
        sculpture,
        original;

        public final int id = ItemMiniature.access$008();
    }
}

