/*
 * Decompiled with CFR 0.152.
 */
package jp.ngt.mcte.network;

import io.netty.buffer.ByteBuf;
import java.io.File;
import jp.ngt.ngtlib.block.NGTObject;
import jp.ngt.ngtlib.event.TickProcessEntry;
import jp.ngt.ngtlib.event.TickProcessQueue;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketExportData
implements IMessage,
IMessageHandler<PacketExportData, IMessage> {
    private String fileName;
    private NGTObject blocksData;

    public PacketExportData() {
    }

    public PacketExportData(String par1, NGTObject par2) {
        this.fileName = par1;
        this.blocksData = par2;
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.fileName);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.blocksData.writeToNBT());
    }

    public void fromBytes(ByteBuf buffer) {
        this.fileName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.blocksData = NGTObject.readFromNBT((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buffer));
    }

    public IMessage onMessage(final PacketExportData message, MessageContext ctx) {
        TickProcessQueue.getInstance((Side)Side.CLIENT).add(new TickProcessEntry(){

            public boolean process(World world) {
                File file = new File(message.fileName);
                message.blocksData.exportToFile(file);
                return true;
            }
        });
        return null;
    }
}

